/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.dms.event.Event;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.LoadableDestination;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.FilteredLifecycleListener;
import oracle.dms.util.Validatable;

public class StdoutLifecycleListener
implements LoadableDestination {
    public static final String REPORT_NOUNS_PROPERTY_NAME = "oracle.dms.instrument.LifecycleListener.reportNouns";
    public static final String REPORT_SENSORS_PROPERTY_NAME = "oracle.dms.instrument.LifecycleListener.reportSensors";
    public static final String STACK_DECIM_PROPERTY_NAME = "oracle.dms.instrument.LifecycleListener.stackDecimation";
    private boolean mReportNouns = true;
    private boolean mReportSensors = true;
    private int mReportStackFrequency = 1;
    private int mReportStackCount = 0;
    private String mName;
    private String mId;
    private static AtomicInteger sInstanceCount = new AtomicInteger(0);
    private int mInstance = sInstanceCount.incrementAndGet();

    public StdoutLifecycleListener() {
        this.mReportNouns = DMSProperties.getPropertyBoolean(REPORT_NOUNS_PROPERTY_NAME, true);
        this.mReportSensors = DMSProperties.getPropertyBoolean(REPORT_SENSORS_PROPERTY_NAME, true);
        this.mReportStackFrequency = DMSProperties.getPropertyInt(STACK_DECIM_PROPERTY_NAME, 1);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.getSourceType().isTypeOf(EventSourceType.NOUN) && !this.mReportNouns) {
            return;
        }
        if (event.getSourceType().isTypeOf(EventSourceType.SENSOR) && !this.mReportSensors) {
            return;
        }
        boolean reportThisStack = true;
        if (this.mReportStackFrequency == 0) {
            reportThisStack = false;
        } else {
            ++this.mReportStackCount;
            if (this.mReportStackCount < this.mReportStackFrequency) {
                reportThisStack = false;
            } else {
                this.mReportStackCount = 0;
            }
        }
        System.out.println(FilteredLifecycleListener.getEventAsStringWithNoun(event, null, reportThisStack));
    }

    @Override
    public String getId() {
        if (this.mId == null) {
            this.mId = "StdoutLifecycleListener" + this.mInstance;
        }
        return this.mId;
    }

    @Override
    public void setId(String id) {
        if (this.mId == null) {
            this.mId = id;
        }
    }

    @Override
    public void setName(String name) {
        if (this.mName == null) {
            this.mName = name;
        }
    }

    @Override
    public String getName() {
        if (this.mName == null) {
            this.mName = "StdoutLifecycleListener" + this.mInstance;
        }
        return this.mName;
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public void initDestination() {
    }

    @Override
    public void shutdownDestination() {
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) {
    }
}

