/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal.wls;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;
import java.util.logging.Level;
import oracle.dms.context.ContextFamily;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.RID;
import oracle.dms.context.WrapOptions;
import oracle.dms.context.internal.AbstractContextFamily;
import oracle.dms.context.internal.DomainContextFamily;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.context.internal.wls.WLSContextManager;
import oracle.dms.context.internal.wls.WLSExecutionContext;

public class WLSContextFamily
extends AbstractContextFamily<WLSContextManager, WLSExecutionContext>
implements ContextFamily,
DomainContextFamily<WLSExecutionContext> {
    WLSContextFamily(WLSContextManager mgr, String ecid) {
        super(mgr, ecid);
    }

    public String getPrettyInstanceStateSummary(Level level) {
        StringBuilder sb = new StringBuilder();
        sb.append("WLSContextFamily instance: ");
        super.appendPrettyInstanceSummary(sb, level);
        return sb.toString();
    }

    public static String getPrettyClassStateSummary(Level level) {
        return "WLSContextFamily class summary: (no state information exists)";
    }

    public String toString() {
        return this.getPrettyInstanceStateSummary(Level.INFO);
    }

    public static class SerializableImpl
    implements Serializable {
        private static final long serialVersionUID = 0L;
        WLSExecutionContext mWLSExecutionContext = null;
        DomainExecutionContext mNonWLSDomainExecutionContext = null;
        boolean mPropagatedToHere = false;
        boolean mPropagationSuccess = false;

        public SerializableImpl() {
        }

        SerializableImpl(DomainExecutionContext dctx) {
            this.mNonWLSDomainExecutionContext = dctx;
        }

        SerializableImpl(WLSExecutionContext executionContext) {
            this.mWLSExecutionContext = executionContext;
        }

        WLSExecutionContext getWLSExecutionContext() {
            return this.mWLSExecutionContext;
        }

        boolean isPropagationSuccess() {
            return this.mPropagationSuccess;
        }

        boolean isPropagatedToHere() {
            return this.mPropagatedToHere;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            String wrapString = "";
            if (this.mNonWLSDomainExecutionContext != null) {
                wrapString = this.mNonWLSDomainExecutionContext.wrap(WrapOptions.DEFAULT_WRAP_OPTIONS);
            } else if (this.mWLSExecutionContext != null) {
                try {
                    String ecid = this.mWLSExecutionContext.getECID();
                    RID newRID = this.mWLSExecutionContext.getRID().createChildRID();
                    WLSContextFamily family = (WLSContextFamily)this.mWLSExecutionContext.getContextFamily();
                    Set<String> propKeys = this.mWLSExecutionContext.getParameterNames(DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
                    Set<String> logKeys = this.mWLSExecutionContext.getParameterNames(DomainContextManager.ParameterAttribute.LOGGABLE);
                    Set<String> limitKeys = this.mWLSExecutionContext.getParameterNames(DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP);
                    wrapString = WrapUtils.wrap(ecid, newRID, this.mWLSExecutionContext.getGlobalMap(), propKeys, logKeys, limitKeys, null, family.getLogLevel(), Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    DMSContextManager.getLogger().log(Level.WARNING, "Failed to create wrap string for propagation in WLS WorkContext map", e);
                }
            }
            out.writeUTF(wrapString);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.mPropagatedToHere = true;
            this.mPropagationSuccess = false;
            if (DMSContextManager.isEnabled()) {
                String wrappedString = in.readUTF();
                DomainContextManager domainContextManager = DMSContextManager.getDomainContextManager();
                if (wrappedString != null && !wrappedString.isEmpty()) {
                    if (domainContextManager instanceof WLSContextManager) {
                        this.readContextForWLS((WLSContextManager)domainContextManager, wrappedString);
                    } else {
                        this.readContextForCurrentManager(domainContextManager, wrappedString);
                    }
                } else {
                    this.mPropagatedToHere = false;
                    this.mPropagationSuccess = false;
                }
            } else {
                String dummy = in.readUTF();
                this.mPropagationSuccess = true;
            }
        }

        private void readContextForWLS(WLSContextManager contextManager, String wrapString) throws IOException {
            WrapUtils.UnwrapResult unwrapResult = WrapUtils.unwrap(contextManager, wrapString, false, true, false, false, Level.WARNING);
            if (unwrapResult.getUnwrapSuccess()) {
                this.mWLSExecutionContext = (WLSExecutionContext)unwrapResult.getUnwrappedDomainExecutionContext();
                this.mPropagationSuccess = true;
            }
        }

        private void readContextForCurrentManager(DomainContextManager contextManager, String wrapString) throws IOException {
            WrapUtils.UnwrapResult unwrapResult = WrapUtils.unwrap(contextManager, wrapString, false, true, true, false, Level.WARNING);
            if (unwrapResult.getUnwrapSuccess()) {
                this.mPropagationSuccess = true;
            }
        }
    }
}

