/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump.formatter;

import java.util.Vector;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.formatter.Formatter;

public class TableFormatter
extends Formatter {
    private String m_headerFormat = "";
    private String m_columnFormat = "";
    private Vector<String> m_columnNames = new Vector(5);
    private Vector<String> m_columnUnderlines = new Vector(5);
    private int m_columnCount = 0;
    private boolean m_columnsLocked = false;
    private boolean m_outputHeaders = true;
    private static final int DEFAULT_HEADER_WIDTH = 10;
    private static final char UNDERLINE_CHAR = '-';
    private static final String TRUNCATE_VALUES_FORMAT = "-%1$d.%1$ds";
    private static final String NO_TRUNCATE_FORMAT = "-%1$ds";

    public TableFormatter(DumpWriter writer) {
        super(writer);
    }

    public TableFormatter(DumpWriter writer, boolean outputHeaders) {
        super(writer);
        this.m_outputHeaders = outputHeaders;
    }

    public void addColumn(String name, String format, int headerWidth, boolean truncateValues) {
        if (this.m_columnsLocked || name == null || name.length() == 0) {
            return;
        }
        if (headerWidth == 0) {
            headerWidth = 10;
        }
        if (format == null || format.length() == 0) {
            format = String.format(truncateValues ? TRUNCATE_VALUES_FORMAT : NO_TRUNCATE_FORMAT, headerWidth);
        }
        this.m_columnNames.add(name);
        StringBuffer underline = new StringBuffer();
        int columnNameSize = headerWidth;
        for (int i = 0; i < columnNameSize; ++i) {
            underline.append('-');
        }
        this.m_columnUnderlines.add(underline.toString());
        String temp = "%" + Integer.toString(++this.m_columnCount) + "$";
        this.m_headerFormat = this.m_headerFormat + temp + "-" + headerWidth + "." + headerWidth + "s ";
        this.m_columnFormat = this.m_columnFormat + temp + format + " ";
    }

    public void addColumn(String name, String format, int headerWidth) {
        this.addColumn(name, format, headerWidth, false);
    }

    public void addColumn(String name, int width, boolean truncateValues) {
        this.addColumn(name, null, width, truncateValues);
    }

    public void addColumn(String name, int width) {
        this.addColumn(name, null, width, false);
    }

    public void addRow(Object ... values) {
        if (values == null || values.length != this.m_columnCount) {
            throw new IllegalArgumentException("Incorrect number of column values");
        }
        if (!this.m_columnsLocked) {
            this.lockColumns();
        }
        this.m_writer.dumpln(String.format(this.m_columnFormat, values));
    }

    private void lockColumns() {
        this.m_columnsLocked = true;
        if (this.m_outputHeaders) {
            this.m_writer.dumpln(String.format(this.m_headerFormat, this.m_columnNames.toArray()));
            this.m_writer.dumpln(String.format(this.m_headerFormat, this.m_columnUnderlines.toArray()));
        }
    }
}

