/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import oracle.dms.http.Request;
import oracle.dms.reporter.MetricTableReporter;
import oracle.dms.reporter.TableBaseReporter;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.QueryOptions;

public class HtmlReporter
extends TableBaseReporter {
    public HtmlReporter(Request request) {
        super(request);
    }

    @Override
    protected void setQueryOptions() {
        super.setQueryOptions();
        this.m_options.setQueryType(QueryOptions.QueryType.SCHEMA);
        this.m_options.setUseCache(QueryOptions.UseCache.REFRESH_ALL);
    }

    @Override
    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    @Override
    public final void printResponse(PrintWriter out) {
        MetricTableReporter.printHTMLStart(out);
        out.print("<frameset cols=\"23%,77%\"><frame src=\"");
        out.print(DMSUtil.urlXssEscape(this.m_request.getRequestURI()));
        out.print("?format=metriclist");
        out.print("&value=false&units=true&description=true");
        out.print("\" name=metricListFrame><frame src=\"");
        out.print(DMSUtil.urlXssEscape(this.m_request.getRequestURI()));
        out.print("?format=metriclist");
        out.print("&value=false&units=true&description=true");
        out.print("\" name=");
        out.print("metricTableFrame");
        out.print("></frameset></html>");
    }
}

