/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.dms.event.Destination;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.spy.Metric;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.Validatable;

public class FilteredLifecycleListener
implements Destination {
    private List<EventHandler> mEventHandlers = new ArrayList<EventHandler>();
    private PrintStream mOut = System.out;
    private Set<String> mIgnoreSet = null;
    private Set<String> mIgnoreStartsWithSet = null;
    private Set<String> mReportOnceSet = null;
    private Boolean mReportNouns = null;
    private Boolean mReportSensors = null;
    private Integer mReportStackFrequency = null;
    private int mReportStackCount = 0;
    private static AtomicInteger sInstanceCount = new AtomicInteger(0);
    private int mInstance = sInstanceCount.incrementAndGet();

    public FilteredLifecycleListener() {
        long upperNounDuration = 0L;
        long upperSensorDuration = 0L;
        long lowerChildSensorCountForNoun = Long.MAX_VALUE;
        long lowerChildNounCountForNoun = Long.MAX_VALUE;
        String tooManyDescendantsConfig = null;
        try {
            String propFileName = DMSProperties.getProperty("oracle.dms.util.FilteredLifecycleListener.propertiesFile");
            if (propFileName != null) {
                FileInputStream stream = new FileInputStream(propFileName);
                PropertyResourceBundle resource = new PropertyResourceBundle(stream);
                Enumeration<String> enumeration = resource.getKeys();
                while (enumeration.hasMoreElements()) {
                    String key = enumeration.nextElement();
                    String value = (String)resource.getObject(key);
                    if ("nounTooYoungIfLessThan".equals(key)) {
                        upperNounDuration = Long.parseLong(value);
                        continue;
                    }
                    if ("sensorTooYoungIfLessThan".equals(key)) {
                        upperSensorDuration = Long.parseLong(value);
                        continue;
                    }
                    if ("tooManySensorsForNounIfMoreThan".equals(key)) {
                        lowerChildSensorCountForNoun = Long.parseLong(value);
                        continue;
                    }
                    if ("tooManyChildNounsForNounIfMoreThan".equals(key)) {
                        lowerChildNounCountForNoun = Long.parseLong(value);
                        continue;
                    }
                    if ("tooManyDescendantsConfig".equals(key)) {
                        tooManyDescendantsConfig = value;
                        continue;
                    }
                    if ("outputFilename".equals(key)) {
                        this.setupOutputFile(value);
                        continue;
                    }
                    if ("ignoreNouns".equals(key)) {
                        this.setIgnoreList(value);
                        continue;
                    }
                    if ("reportOnce".equals(key)) {
                        if (!"true".equals(value)) continue;
                        this.mReportOnceSet = new HashSet<String>();
                        continue;
                    }
                    if ("oracle.dms.instrument.LifecycleListener.reportNouns".equals(key)) {
                        this.mReportNouns = true;
                        if (!"false".equals(value)) continue;
                        this.mReportNouns = false;
                        continue;
                    }
                    if ("oracle.dms.instrument.LifecycleListener.reportSensors".equals(key)) {
                        this.mReportSensors = true;
                        if (!"false".equals(value)) continue;
                        this.mReportSensors = false;
                        continue;
                    }
                    if (!"oracle.dms.instrument.LifecycleListener.stackDecimation".equals(key)) continue;
                    this.mReportStackFrequency = Integer.parseInt(value);
                }
            }
            this.mOut.println("FilteredLifeycleListener configured as follows:");
            this.mEventHandlers.add(new NounTooYoungHandler(upperNounDuration));
            this.mOut.println("  nounTooYoungIfLessThan   = " + upperNounDuration);
            this.mEventHandlers.add(new NounTooManyChildNounsHandler(lowerChildNounCountForNoun));
            this.mOut.println("  tooManyChildNounsForNoun = " + lowerChildNounCountForNoun);
            this.mEventHandlers.add(new SensorTooYoungHandler(upperSensorDuration));
            this.mOut.println("  sensorTooYoungIfLessThan = " + upperSensorDuration);
            this.mEventHandlers.add(new NounTooManySensorsHandler(lowerChildSensorCountForNoun));
            this.mOut.println("  tooManySensorsForNoun    = " + lowerChildSensorCountForNoun);
            this.mEventHandlers.add(new NounTooManyDescendantsHandler(tooManyDescendantsConfig));
            this.mOut.println("  tooManyDescendantsConfig = " + tooManyDescendantsConfig);
            if (this.mIgnoreSet != null) {
                this.mOut.println("  ignoreList:");
                this.mOut.println("    name matches:");
                for (String s : this.mIgnoreSet) {
                    this.mOut.println("      " + s);
                }
                this.mOut.println("    name starts with:");
                for (String s : this.mIgnoreStartsWithSet) {
                    this.mOut.println("      " + s);
                }
            }
            if (this.mReportOnceSet != null) {
                this.mOut.println("  reportOnce = true");
            }
            if (this.mReportNouns != null) {
                this.mOut.println("  reportNouns = " + this.mReportNouns);
            } else {
                this.mReportNouns = true;
            }
            if (this.mReportSensors != null) {
                this.mOut.println("  reportSensors = " + this.mReportSensors);
            } else {
                this.mReportSensors = true;
            }
            if (this.mReportStackFrequency != null) {
                this.mOut.println("  reportStackFrequency = " + this.mReportStackFrequency);
            } else {
                this.mReportStackFrequency = 1;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void setupOutputFile(String outputFilename) throws FileNotFoundException {
        if (outputFilename != null) {
            File file = new File(outputFilename);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream outStream = new FileOutputStream(file);
            this.mOut = new PrintStream(outStream);
        }
    }

    private void setIgnoreList(String ignoreString) {
        StringTokenizer st = new StringTokenizer(ignoreString, ";");
        if (st.hasMoreElements()) {
            this.mIgnoreSet = new HashSet<String>();
            this.mIgnoreStartsWithSet = new HashSet<String>();
            while (st.hasMoreTokens()) {
                String nounName = st.nextToken().trim();
                if (!nounName.startsWith("/")) continue;
                if (nounName.endsWith("*")) {
                    this.mIgnoreStartsWithSet.add(nounName.substring(0, nounName.length() - 1));
                    continue;
                }
                this.mIgnoreSet.add(nounName);
            }
        }
    }

    private synchronized boolean ignoreNoun(Noun noun) {
        String nounName = noun.toString();
        if (this.mIgnoreSet != null) {
            if (this.mIgnoreSet.contains(nounName)) {
                return true;
            }
            for (String s : this.mIgnoreStartsWithSet) {
                if (!nounName.startsWith(s)) continue;
                return true;
            }
        }
        return this.mReportOnceSet != null && this.mReportOnceSet.contains(nounName);
    }

    private synchronized void nounReported(Noun n) {
        if (this.mReportOnceSet != null) {
            this.mReportOnceSet.add(n.toString());
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (event.getSourceType().isTypeOf(EventSourceType.NOUN) && !this.mReportNouns.booleanValue()) {
            return;
        }
        if (event.getSourceType().isTypeOf(EventSourceType.SENSOR) && !this.mReportSensors.booleanValue()) {
            return;
        }
        boolean reportThisStack = true;
        if (this.mReportStackFrequency == 0) {
            reportThisStack = false;
        } else {
            ++this.mReportStackCount;
            if (this.mReportStackCount < this.mReportStackFrequency) {
                reportThisStack = false;
            } else {
                this.mReportStackCount = 0;
            }
        }
        for (EventHandler h : this.mEventHandlers) {
            h.handleEvent(event, reportThisStack);
        }
    }

    @Override
    public String getId() {
        return "FilteredLifecycleListener" + this.mInstance;
    }

    public void setId(String id) {
    }

    public void setName(String name) {
    }

    @Override
    public String getName() {
        return "FilteredLifecycleListener" + this.mInstance;
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public void initDestination() {
    }

    @Override
    public void shutdownDestination() {
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) {
    }

    public static String getEventAsStringWithNoun(Event event, Noun nounToReport, boolean reportStack) {
        Noun n = null;
        Sensor s = null;
        EventSourceType sourceType = event.getSourceType();
        if (sourceType == EventSourceType.NOUN) {
            n = (Noun)event.getSource();
        } else if (sourceType.isTypeOf(EventSourceType.SENSOR)) {
            s = (Sensor)event.getSource();
            n = s.getParent();
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append(event.getActionType().name()).append(':').append(event.getSourceType().name()).append("[time=").append(event.getTime()).append("]:");
        if (n != null) {
            FilteredLifecycleListener.appendNounDetails(event, n, sb, nounToReport);
        }
        if (s != null) {
            FilteredLifecycleListener.appendSensorDetails(event, s, n, sb);
        }
        sb.append("\n");
        if (reportStack) {
            ClassUtils.appendPrettyStack(sb, event.getStack());
        }
        return sb.toString();
    }

    private static void appendNounDetails(Event event, Noun noun, StringBuilder sb, Noun nounToReport) {
        sb.append(" Event on noun '").append(noun.toString()).append('\'');
        if (nounToReport == null) {
            nounToReport = noun;
        } else {
            sb.append(", noun with issues '").append(nounToReport.toString()).append('\'');
        }
        if (event.getSourceType() == EventSourceType.NOUN) {
            long creationTime = nounToReport.getCreateTime();
            sb.append(" (").append("age:").append(creationTime == -1L ? "?" : Long.toString(event.getTime() - creationTime)).append("ms, depth:").append(nounToReport.getDepthInTree()).append(", child-nouns:").append(nounToReport.getChildNounCount()).append(", siblings-inc-self:").append(nounToReport.getParent() == null ? "?" : Integer.toString(nounToReport.getParent().getChildNounCount())).append(", desc-nouns:").append(nounToReport.getDescendantNounCount()).append(", child-sens:").append(nounToReport.getChildSensorCount()).append(", desc-sens:").append(nounToReport.getDescendantSensorCount()).append(")");
        }
    }

    private static void appendSensorDetails(Event event, Sensor sensor, Noun noun, StringBuilder sb) {
        sb.append(" Sensor='").append(sensor.getName()).append('\'');
        if (event.getSourceType().isTypeOf(EventSourceType.SENSOR)) {
            long creationTime = sensor.getCreateTime();
            sb.append("(").append("age:").append(creationTime == -1L ? "?" : Long.toString(event.getTime() - creationTime)).append("ms, siblings-inc-self:").append(noun == null ? "?" : Integer.toString(noun.getChildSensorCount())).append(")");
        }
    }

    private static void appendMetricDetails(Event event, Metric metric, StringBuilder sb) {
        if (metric != null) {
            sb.append(" Metric='").append(metric.getName()).append('\'');
        }
    }

    private class NounTooManyDescendantsHandler
    extends EventHandler {
        private Map<Integer, Integer> mConfig;

        NounTooManyDescendantsHandler(String configString) {
            try {
                if (configString != null) {
                    this.mConfig = new HashMap<Integer, Integer>();
                    StringTokenizer tokenizer = new StringTokenizer(configString, ";");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        int splitPoint = (token = token.trim()).indexOf("->");
                        if (splitPoint <= 0) continue;
                        String depthString = token.substring(0, splitPoint);
                        String descCountString = token.substring(splitPoint + 2);
                        this.mConfig.put(Integer.parseInt(depthString), Integer.parseInt(descCountString));
                    }
                }
            }
            catch (Throwable t) {
                this.mConfig = null;
            }
        }

        @Override
        void handleEvent(Event event, boolean reportStack) {
            if (event.getSourceType().isTypeOf(EventSourceType.NOUN) && event.getActionType() == EventActionType.CREATE) {
                for (Noun noun = ((Noun)event.getSource()).getParent(); noun != null; noun = noun.getParent()) {
                    int depth;
                    Integer maxDescendants;
                    if (FilteredLifecycleListener.this.ignoreNoun(noun) || (maxDescendants = this.mConfig.get(depth = noun.getDepthInTree())) == null || noun.getDescendantNounCount() <= maxDescendants) continue;
                    FilteredLifecycleListener.this.mOut.println("Parent noun has too many descendants for its depth in the noun tree (rule: depth " + depth + " -> " + maxDescendants + " nouns) :\n " + FilteredLifecycleListener.getEventAsStringWithNoun(event, noun, reportStack));
                    FilteredLifecycleListener.this.nounReported(noun);
                }
            }
        }
    }

    private class NounTooManyChildNounsHandler
    extends EventHandler {
        private long mLowerChildNounCountForNoun;

        NounTooManyChildNounsHandler(long lowerChildNounCountForNoun) {
            this.mLowerChildNounCountForNoun = lowerChildNounCountForNoun;
        }

        @Override
        void handleEvent(Event event, boolean reportStack) {
            if (event.getSourceType().isTypeOf(EventSourceType.NOUN) && event.getActionType() == EventActionType.CREATE) {
                Noun childNoun = (Noun)event.getSource();
                Noun parentNoun = childNoun.getParent();
                if (FilteredLifecycleListener.this.ignoreNoun(parentNoun)) {
                    return;
                }
                if ((long)parentNoun.getChildNounCount() > this.mLowerChildNounCountForNoun) {
                    FilteredLifecycleListener.this.mOut.println("Parent noun has rather a lot of child Nouns:\n " + FilteredLifecycleListener.getEventAsStringWithNoun(event, parentNoun, reportStack));
                    FilteredLifecycleListener.this.nounReported(parentNoun);
                }
            }
        }
    }

    private class NounTooManySensorsHandler
    extends EventHandler {
        private long mLowerChildSensorCountForNoun;

        NounTooManySensorsHandler(long lowerChildSensorCountForNoun) {
            this.mLowerChildSensorCountForNoun = lowerChildSensorCountForNoun;
        }

        @Override
        void handleEvent(Event event, boolean reportStack) {
            if (event.getSourceType().isTypeOf(EventSourceType.SENSOR) && event.getActionType() == EventActionType.CREATE) {
                Sensor s = (Sensor)event.getSource();
                Noun n = s.getParent();
                if (FilteredLifecycleListener.this.ignoreNoun(n)) {
                    return;
                }
                if ((long)n.getChildSensorCount() > this.mLowerChildSensorCountForNoun) {
                    FilteredLifecycleListener.this.mOut.println("Noun has rather a lot of Sensors:\n " + FilteredLifecycleListener.getEventAsStringWithNoun(event, null, reportStack));
                    FilteredLifecycleListener.this.nounReported(n);
                }
            }
        }
    }

    private class SensorTooYoungHandler
    extends EventHandler {
        private long mUpperSensorDuration;

        SensorTooYoungHandler(long upperSensorDuration) {
            this.mUpperSensorDuration = upperSensorDuration;
        }

        @Override
        void handleEvent(Event event, boolean reportStack) {
            if (event.getSourceType().isTypeOf(EventSourceType.SENSOR) && event.getActionType() == EventActionType.DELETE) {
                Sensor s = (Sensor)event.getSource();
                Noun n = s.getParent();
                if (FilteredLifecycleListener.this.ignoreNoun(n)) {
                    return;
                }
                if (event.getTime() - s.getCreateTime() < this.mUpperSensorDuration) {
                    FilteredLifecycleListener.this.mOut.println("Sensor destroyed before it got old:\n " + FilteredLifecycleListener.getEventAsStringWithNoun(event, null, reportStack));
                }
            }
        }
    }

    private class NounTooYoungHandler
    extends EventHandler {
        private long mUpperNounDuration;

        NounTooYoungHandler(long upperNounDuration) {
            this.mUpperNounDuration = upperNounDuration;
        }

        @Override
        void handleEvent(Event event, boolean reportStack) {
            if (event.getSourceType().isTypeOf(EventSourceType.NOUN) && event.getActionType() == EventActionType.DELETE) {
                Noun noun = (Noun)event.getSource();
                if (FilteredLifecycleListener.this.ignoreNoun(noun)) {
                    return;
                }
                if (event.getTime() - noun.getCreateTime() < this.mUpperNounDuration) {
                    FilteredLifecycleListener.this.mOut.println("Noun destroyed before it got old:\n " + FilteredLifecycleListener.getEventAsStringWithNoun(event, null, reportStack));
                    FilteredLifecycleListener.this.nounReported(noun);
                }
            }
        }
    }

    private abstract class EventHandler {
        private EventHandler() {
        }

        abstract void handleEvent(Event var1, boolean var2);
    }
}

