/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dms.context.ContextParameterFactory;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.DMSCtxParamDescriptor;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.ExecutionContextComponents;
import oracle.dms.context.RID;
import oracle.dms.context.internal.ActivationException;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.ContextParameterFactoryImpl;
import oracle.dms.context.internal.DomainContextFamily;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.util.ExpirationMap;
import oracle.dms.util.LogFloodController;
import oracle.dms.util.Time;
import oracle.dms.util.WeakReferenceWithKey;

public abstract class AbstractContextManager<F extends DomainContextFamily, C extends DomainExecutionContext> {
    private long mCleanerSleepMillis = 300000L;
    private int mMaxBytes = 0;
    private AtomicInteger mDefaultMaxParamLength = new AtomicInteger(256);
    private boolean mCleanerDone = false;
    private ContextCleaner mCleaner = null;
    Object mCleanInProgressLockObj = null;
    ContextParameterFactoryImpl mContextParameterFactory;
    Map<String, WeakReference<ContextParameterDescriptorInternal>> mCtxParamDescMap;
    Map<String, WeakReference<ContextParameterDescriptorInternal>> mValueHolderCtxParamMap;
    protected ConcurrentHashMap<String, WeakReferenceWithKey<String, F>> mFamilyMap;
    protected ReferenceQueue<WeakReferenceWithKey<String, F>> mFamilyMapReferenceQueue;
    protected ReentrantLock mFamilyReferenceQueueLock;
    protected ExpirationMap<Object, C> mCtxStashMap;
    protected ExpirationMap<Object, C> mCtxSuspendMap;
    protected static final Logger sLogger = DMSContextManager.getLogger();
    protected AtomicInteger mCustomLogLevelCount;
    protected LogFloodController mLogFloodController;
    protected EnumMap<DomainContextManager.ParameterAttribute, Set<String>> mParamAttribute2ParamNameMap = new EnumMap(DomainContextManager.ParameterAttribute.class);
    private static final String CLASS_NAME = AbstractContextManager.class.getName();
    private static final String IS_VALUE_LEGAL_METHOD_NAME = "isLegalValue";

    protected AbstractContextManager() {
        this.mLogFloodController = new LogFloodController(DMSContextManager.getLogger());
        this.mLogFloodController.addMaxMsgsTimeWindowPolicy(CLASS_NAME, IS_VALUE_LEGAL_METHOD_NAME, "DMS-57015", 30000L, 10);
        for (DomainContextManager.ParameterAttribute pa : DomainContextManager.ParameterAttribute.values()) {
            this.mParamAttribute2ParamNameMap.put(pa, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        Set<String> propagateNames = this.mParamAttribute2ParamNameMap.get((Object)DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
        propagateNames.add("wlmPC");
        propagateNames.add("wlmWRC");
        propagateNames.add("dmsTrace");
        propagateNames.add("sqltrace");
        Set<String> propagateToDBNames = this.mParamAttribute2ParamNameMap.get((Object)DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
        propagateToDBNames.add("wlmPC");
        propagateToDBNames.add("wlmWRC");
        propagateToDBNames.add("dmsTrace");
        propagateToDBNames.add("sqltrace");
        for (DMSCtxParamDescriptor desc : DMSCtxParamDescriptor.values()) {
            if (desc.getScope().isPropagatedViaWrap()) {
                propagateNames.add(desc.getName().intern());
            }
            if (!desc.getScope().isPropagatedToDB()) continue;
            propagateToDBNames.add(desc.getName().intern());
        }
        Set<String> loggableNames = this.mParamAttribute2ParamNameMap.get((Object)DomainContextManager.ParameterAttribute.LOGGABLE);
        loggableNames.add(DMSCtxParamDescriptor.DBOperation.getName());
        loggableNames.add(DMSCtxParamDescriptor.FlowId.getName());
        loggableNames.add(DMSCtxParamDescriptor.RequestClassId.getName());
        this.mContextParameterFactory = new ContextParameterFactoryImpl((DomainContextManager)((Object)this));
        this.mCtxParamDescMap = new ConcurrentHashMap<String, WeakReference<ContextParameterDescriptorInternal>>();
        this.mValueHolderCtxParamMap = new ConcurrentHashMap<String, WeakReference<ContextParameterDescriptorInternal>>();
        this.mFamilyMap = new ConcurrentHashMap(64, 0.75f);
        this.mFamilyMapReferenceQueue = new ReferenceQueue();
        this.mFamilyReferenceQueueLock = new ReentrantLock();
        this.mCtxStashMap = new ExpirationMap(new ConcurrentHashMap(), true);
        this.mCtxSuspendMap = new ExpirationMap(new ConcurrentHashMap(), true);
        this.mCustomLogLevelCount = new AtomicInteger(0);
    }

    protected boolean isCleanerDone() {
        return this.mCleanerDone;
    }

    public boolean initNoLogging() {
        this.initNoLogging2();
        return true;
    }

    protected abstract void initNoLogging2();

    public void postInit() {
        this.mCleanInProgressLockObj = new Object();
        this.mCleaner = new ContextCleaner();
        this.mCleaner.start();
    }

    public synchronized void shutdown() {
        this.stopCleaner();
        this.mFamilyMap = null;
        this.mFamilyMapReferenceQueue = null;
        this.mFamilyReferenceQueueLock = null;
        this.mCtxStashMap = null;
        this.mCtxSuspendMap = null;
        this.mCustomLogLevelCount = null;
        this.shutdown2();
    }

    protected abstract void shutdown2();

    public C getContext() throws ActivationException {
        return this.getContext(true);
    }

    protected abstract C getContext(boolean var1) throws ActivationException;

    public C findContext(String ecid, RID rid) {
        return this.findContext(ecid, rid.toString());
    }

    protected abstract C findContext(String var1, String var2);

    public void setMaxStashMinutes(int minutes) {
        this.setMaxStashSeconds(minutes * 60);
    }

    public void setMaxStashSeconds(int seconds) {
        if (seconds < 0) {
            this.mCtxStashMap.setMaxLengthOfStayInMillis(3600000L);
        } else {
            if (seconds > 1440) {
                seconds = 1440;
            }
            this.mCtxStashMap.setMaxLengthOfStayInMillis(seconds * 1000);
        }
    }

    public long getMaxStashMillis() {
        long retVal = 0L;
        if (this.mCtxStashMap != null) {
            retVal = this.mCtxStashMap.getMaxLengthOfStayInMillis();
        }
        return retVal;
    }

    public void setMaxSuspendMinutes(int minutes) {
        this.setMaxSuspendSeconds(minutes * 60);
    }

    public void setMaxSuspendSeconds(int seconds) {
        if (seconds < 0) {
            this.mCtxSuspendMap.setMaxLengthOfStayInMillis(3600000L);
        } else {
            if (seconds > 1440) {
                seconds = 1440;
            }
            this.mCtxSuspendMap.setMaxLengthOfStayInMillis(seconds * 1000);
        }
    }

    public long getMaxSuspendMillis() {
        long retVal = 0L;
        if (this.mCtxSuspendMap != null) {
            retVal = this.mCtxSuspendMap.getMaxLengthOfStayInMillis();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanerSleepSecs(long seconds) {
        this.mCleanerSleepMillis = seconds < 0L ? 300000L : seconds * 1000L;
        Object object = this.mCleanInProgressLockObj;
        synchronized (object) {
            this.mCleaner.interrupt();
        }
    }

    public long getCleanerSleepMillis() {
        return this.mCleanerSleepMillis;
    }

    public Object getValue(String ecid, RID rid, String key) {
        return this.getValue(ecid, rid.toString(), key);
    }

    public Object getValue(String ecid, String ridStr, String paramName) {
        C ctx;
        String retVal = null;
        if (paramName != null && (ctx = this.findContext(ecid, ridStr)) != null) {
            ContextParameterDescriptorInternal desc = this.findContextParameterDescriptor(paramName);
            if (desc != null) {
                if (desc.isValid()) {
                    ctx.getValueAccordingToDescriptor(desc, false);
                }
            } else {
                retVal = ctx.getLocalValue(paramName);
                if (retVal == null) {
                    retVal = ctx.getGlobalValue(paramName);
                }
            }
        }
        return retVal;
    }

    public void setMaxBytes(int maxBytes) {
        this.mMaxBytes = maxBytes;
    }

    public int getMaxBytes() {
        return this.mMaxBytes;
    }

    public void setParameterAttribute(String key, DomainContextManager.ParameterAttribute paramAttr) {
        if (key == null) {
            return;
        }
        String internedKey = key.intern();
        Set<String> names = this.mParamAttribute2ParamNameMap.get((Object)paramAttr);
        boolean added = names.add(internedKey);
    }

    public Set<String> getParameterNames(DomainContextManager.ParameterAttribute paramAttr) {
        Set<String> retVal = this.mParamAttribute2ParamNameMap.get((Object)paramAttr);
        return retVal;
    }

    @Deprecated
    public int getContextCount(String ecid) {
        int retVal = 0;
        F ctf = this.findFamily(ecid);
        if (ctf != null) {
            retVal = ctf.getContexts().size();
        }
        return retVal;
    }

    public void deactivateContext() {
        C ctx = this.getActiveContext();
        if (ctx != null) {
            ctx.deactivate(true);
        }
    }

    protected abstract Logger getLogger();

    protected abstract C getActiveContext();

    protected void stopCleaner() {
        this.mCleanerDone = true;
        if (this.mCleaner != null) {
            try {
                this.mCleaner.stopCleaner();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mCleaner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(PhaseEvent cleanerPE, Event cleanedEvent, Event notCleanedEvent) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AbstractContextManager.cleanup - Before Cleanup: {0}", new String[]{this.getPrettyInstanceStateSummary(Level.FINE)});
        }
        long token = 0L;
        try {
            long now = System.currentTimeMillis();
            if (cleanerPE != null) {
                token = cleanerPE.start();
            }
            this.mCtxStashMap.expire();
            this.mCtxSuspendMap.expire();
            this.purgeFamilyMap();
            this.refreshLogLevelCount();
            this.cleanup2(now);
            if (cleanedEvent != null) {
                cleanedEvent.occurred();
            }
        }
        finally {
            if (cleanerPE != null) {
                cleanerPE.stop(token);
            }
            if (notCleanedEvent != null) {
                notCleanedEvent.occurred();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AbstractContextManager.cleanup - After Cleanup: {0}", new String[]{this.getPrettyInstanceStateSummary(Level.FINE)});
        }
    }

    @Deprecated
    public Map<String, C> getContexts(String ecid) {
        Map retVal = null;
        F ctf = this.findFamily(ecid);
        retVal = ctf != null ? ctf.getContexts() : new HashMap(1, 1.0f);
        return retVal;
    }

    public F findFamily(String ecid) {
        Reference ctfRef = null;
        if (this.mFamilyMap != null) {
            ctfRef = this.mFamilyMap.get(ecid);
        }
        return (F)(ctfRef == null ? null : (DomainContextFamily)ctfRef.get());
    }

    public void stashNewChild(Object key) throws ActivationException {
        DomainExecutionContext ctx = null;
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        C pctx = this.getContext(true);
        if (pctx == null) {
            throw new IllegalStateException("no context retrieved for this thread, can not create child context of it.");
        }
        ctx = pctx.createChild();
        if (ctx == null) {
            throw new IllegalStateException("failed to create a child execution when required to do so");
        }
        this.mCtxStashMap.put(key, ctx);
    }

    public C activateStashedContext(Object key) throws ActivationException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        DomainExecutionContext dctx = (DomainExecutionContext)this.mCtxStashMap.remove(key);
        if (dctx != null) {
            C oldContext = this.getActiveContext();
            dctx.activate(true, oldContext);
        }
        return (C)dctx;
    }

    public C activateContextComponents(ExecutionContextComponents components) throws ActivationException {
        String ecid = components.getECID();
        if (ecid == null) {
            throw new IllegalArgumentException("Can not activate a context if it has no ECID.");
        }
        RID rid = null;
        if (components.getRIDasString() != null) {
            rid = RID.createRID(components.getRIDasString(), false);
            if (rid == null) {
                throw new IllegalArgumentException("Invalid RID found in context: " + components.getRIDasString());
            }
        } else {
            rid = RID.createRIDWithUnknownLineage();
        }
        boolean newFamily = false;
        Object dctf = this.findFamily(ecid);
        DomainExecutionContext dctx = null;
        if (dctf == null) {
            newFamily = true;
            dctx = (DomainExecutionContext)((DomainContextManager)((Object)this)).newFamily(ecid, rid);
            dctf = dctx.getContextFamily();
        } else {
            dctx = (DomainExecutionContext)((DomainContextManager)((Object)this)).createContextForUnwrap(dctf, rid);
            dctf.addContext(dctx);
        }
        if (components.getGlobalMap() != null) {
            for (Map.Entry<String, String> entry : components.getGlobalMap().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                dctx.setGlobalValue(entry.getKey(), entry.getValue());
            }
        }
        if (components.getLogLevel() != null) {
            dctf.setLogLevel(components.getLogLevel());
        }
        Set<String> keySet = null;
        keySet = components.getKeys(2);
        if (keySet != null) {
            for (String string : keySet) {
                if (string == null) continue;
                dctf.setParameterAttribute(string, DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
                dctf.setParameterAttribute(string, DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
            }
        }
        if ((keySet = components.getKeys(1)) != null) {
            for (String string : keySet) {
                if (string == null) continue;
                dctf.setParameterAttribute(string, DomainContextManager.ParameterAttribute.LOGGABLE);
            }
        }
        if (components.getLocalMap() != null) {
            for (Map.Entry entry : components.getLocalMap().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                dctx.setLocalValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        dctx.activate();
        return (C)dctx;
    }

    public C removeStashedContext(Object key) {
        DomainExecutionContext ctx = (DomainExecutionContext)this.mCtxStashMap.remove(key);
        if (ctx != null) {
            ctx.getContextFamily().removeContext(ctx);
        }
        return (C)ctx;
    }

    public boolean resumeSuspendedContext(Object key) throws ActivationException {
        boolean retVal = false;
        DomainExecutionContext newContext = (DomainExecutionContext)this.mCtxSuspendMap.remove(key);
        if (newContext != null) {
            newContext.activate();
            retVal = true;
            EventReportingManager eMgr = EventSystem.getEventReportingManager();
            if (eMgr != null) {
                eMgr.reportEvent(newContext.getAsMutableExecutionContext(), EventSourceType.EXECUTION_CONTEXT, EventActionType.RESUME, Time.currentTimeMillis(), newContext.getAsMutableExecutionContext(), null);
            }
        }
        return retVal;
    }

    public String[] getEcids() {
        String[] retVal = null;
        this.purgeFamilyMap();
        if (this.mFamilyMap != null) {
            Set keys = null;
            keys = this.mFamilyMap.keySet();
            String[] ecids = new String[keys.size()];
            retVal = keys.toArray(ecids);
        }
        return retVal;
    }

    public int getLogLevelCount() {
        int retVal = 0;
        if (this.mCustomLogLevelCount != null) {
            retVal = this.mCustomLogLevelCount.get();
        }
        return retVal;
    }

    public boolean hasContext() {
        return this.getActiveContext() != null;
    }

    protected abstract void cleanup2(long var1);

    protected abstract String getPrettyInstanceStateSummary(Level var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int purgeFamilyMap() {
        int retVal = 0;
        if (this.mFamilyMap != null && this.mFamilyReferenceQueueLock != null && this.mFamilyReferenceQueueLock.tryLock()) {
            try {
                Reference<WeakReferenceWithKey<String, F>> ref = null;
                while ((ref = this.mFamilyMapReferenceQueue.poll()) != null) {
                    WeakReferenceWithKey refWithKey = (WeakReferenceWithKey)ref;
                    this.mFamilyMap.remove(refWithKey.getKey());
                    ++retVal;
                }
            }
            finally {
                this.mFamilyReferenceQueueLock.unlock();
            }
        }
        return retVal;
    }

    public void deregisterFamily(F ctf) {
        if (ctf == null) {
            throw new IllegalArgumentException("DomainContextFamily ctf must not be null");
        }
        if (this.mFamilyMap != null) {
            String ecid = ctf.getECID();
            ctf.setLogLevel(null);
            WeakReference toss = this.mFamilyMap.remove(ecid);
            this.purgeFamilyMap();
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.log(Level.FINER, "DomainContextFamily {0} deregistered.", new Object[]{ecid});
            }
        }
    }

    public void incrementLevels() {
        this.mCustomLogLevelCount.incrementAndGet();
    }

    public void decrementLevels() {
        this.mCustomLogLevelCount.decrementAndGet();
    }

    public C getSuspendedContext(Object key) {
        DomainExecutionContext ctxFromMap = null;
        if (this.mCtxSuspendMap != null) {
            ctxFromMap = (DomainExecutionContext)this.mCtxSuspendMap.get(key);
        }
        return (C)ctxFromMap;
    }

    public void addToSuspendedMap(Object key, C context) {
        this.mCtxSuspendMap.put(key, context);
    }

    public boolean removeSuspendedContext(C context) {
        boolean retVal = false;
        if (context != null) {
            Collection<C> valuesCollection = this.mCtxSuspendMap.values();
            Iterator<C> iterator = valuesCollection.iterator();
            while (iterator.hasNext()) {
                DomainExecutionContext contextFromMap = (DomainExecutionContext)iterator.next();
                if (!context.equals(contextFromMap)) continue;
                iterator.remove();
                retVal = true;
            }
        }
        return retVal;
    }

    protected void registerFamily(F ctf) {
        String ecid = null;
        if (ctf == null) {
            throw new IllegalArgumentException("ctf must not be null");
        }
        ecid = ctf.getECID();
        if (ecid == null) {
            throw new IllegalArgumentException("ecid of context family must not be null");
        }
        if (this.mFamilyMap != null) {
            this.purgeFamilyMap();
            this.mFamilyMap.put(ecid, new WeakReferenceWithKey<String, F>(ecid, ctf, this.mFamilyMapReferenceQueue));
        }
    }

    protected void refreshLogLevelCount() {
        int newLogLevelCount = 0;
        if (this.mFamilyMap != null) {
            Set<Map.Entry<String, WeakReferenceWithKey<String, F>>> set = this.mFamilyMap.entrySet();
            for (Map.Entry<String, WeakReferenceWithKey<String, F>> entry : set) {
                WeakReference tRef = entry.getValue();
                DomainContextFamily ctf = (DomainContextFamily)tRef.get();
                if (ctf == null || ctf.getLogLevel() == null) continue;
                ++newLogLevelCount;
            }
        }
        this.mCustomLogLevelCount.set(newLogLevelCount);
    }

    public ContextParameterDescriptorInternal findContextParameterDescriptor(String name) {
        WeakReference<ContextParameterDescriptorInternal> almostRetVal;
        ContextParameterDescriptorInternal retVal = null;
        retVal = DMSCtxParamDescriptor.findDescriptor(name);
        if (retVal == null && (almostRetVal = this.mCtxParamDescMap.get(name)) != null) {
            retVal = (ContextParameterDescriptorInternal)almostRetVal.get();
        }
        return retVal;
    }

    public Collection<ContextParameterDescriptorInternal> getValueHolderDescriptors(boolean allDescriptors) {
        LinkedList<ContextParameterDescriptorInternal> retVal = new LinkedList<ContextParameterDescriptorInternal>();
        if (allDescriptors) {
            retVal.addAll(DMSCtxParamDescriptor.getAllValueHolderDescriptors());
            for (WeakReference<ContextParameterDescriptorInternal> ref : this.mValueHolderCtxParamMap.values()) {
                ContextParameterDescriptorInternal c = (ContextParameterDescriptorInternal)ref.get();
                if (c == null) continue;
                retVal.add(c);
            }
        } else {
            retVal.addAll(DMSCtxParamDescriptor.getAllRemoteThreadSafeValueHolderDescriptors());
        }
        return retVal;
    }

    public Set<ContextParameterDescriptorInternal> getContextParameterDescriptors() {
        HashSet<ContextParameterDescriptorInternal> retVal = new HashSet<ContextParameterDescriptorInternal>();
        for (DMSCtxParamDescriptor p : DMSCtxParamDescriptor.values()) {
            retVal.add(p);
        }
        for (WeakReference<ContextParameterDescriptorInternal> value : this.mCtxParamDescMap.values()) {
            if (value.get() == null) continue;
            retVal.add((ContextParameterDescriptorInternal)value.get());
        }
        return retVal;
    }

    public void addContextParameterDescriptor(ContextParameterDescriptorInternal ctxParamDesc) {
        WeakReference<ContextParameterDescriptorInternal> ref = new WeakReference<ContextParameterDescriptorInternal>(ctxParamDesc);
        this.mCtxParamDescMap.put(ctxParamDesc.getName(), ref);
        if (ctxParamDesc.getValueHolder() != null) {
            this.mValueHolderCtxParamMap.put(ctxParamDesc.getName(), ref);
        }
    }

    public ContextParameterFactory getContextParameterFactory() {
        return this.mContextParameterFactory;
    }

    public int getDefaultMaxParamValueLength() {
        return this.mDefaultMaxParamLength.intValue();
    }

    public boolean isValueLegal(ContextParameterDescriptorInternal ctxParamDesc, String paramName, String value) {
        boolean retVal = true;
        if (value != null) {
            int maxLength = this.getDefaultMaxParamValueLength();
            if (ctxParamDesc != null) {
                maxLength = ctxParamDesc.getMaxValueLength();
            }
            if (value.length() > maxLength) {
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-57015");
                lr.setResourceBundle(sLogger.getResourceBundle());
                lr.setSourceClassName(CLASS_NAME);
                lr.setSourceMethodName(IS_VALUE_LEGAL_METHOD_NAME);
                lr.setParameters(new Object[]{ctxParamDesc != null ? ctxParamDesc.getName() : paramName, Integer.toString(value.length()), Integer.toString(maxLength)});
                this.mLogFloodController.log(lr);
                retVal = false;
            }
        }
        return retVal;
    }

    private class ContextCleaner
    extends Thread {
        private Noun m_noun = null;
        private PhaseEvent m_cleanerPE = null;
        private Event m_cleanedEvent = null;
        private Event m_notCleanedEvent = null;
        private oracle.dms.console.DMSConsole m_console = null;
        private boolean m_alive = true;

        private ContextCleaner() {
            AbstractContextManager.this.getLogger().log(Level.FINE, "Creating new Context Cleaner Thread");
            this.setName("ContextCleaner");
            this.setDaemon(true);
            this.setPriority(4);
            this.m_console = oracle.dms.console.DMSConsole.getConsole();
            if (this.m_console.isActive() && DMSConsole.getSensorWeight() > 0) {
                this.m_noun = Noun.create("/DMS-Internal/ContextManager", "ContextManager");
                this.m_cleanerPE = PhaseEvent.create(this.m_noun, "cleanup", "duration of cleanup");
                this.m_cleanerPE.deriveMetric(511);
                this.m_cleanedEvent = Event.create(this.m_noun, "cleaned", "Number removed by cleaner thread");
                this.m_notCleanedEvent = Event.create(this.m_noun, "notCleaned", "Number skipped by cleaner thread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopCleaner() throws InterruptedException {
            this.m_alive = false;
            Object object = AbstractContextManager.this.mCleanInProgressLockObj;
            synchronized (object) {
                this.interrupt();
            }
            this.join();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutionContext ctx = DMSContextManager.getContext();
            try {
                while (!AbstractContextManager.this.isCleanerDone() && this.m_alive) {
                    Object object = AbstractContextManager.this.mCleanInProgressLockObj;
                    synchronized (object) {
                        AbstractContextManager.this.cleanup(this.m_cleanerPE, this.m_cleanedEvent, this.m_notCleanedEvent);
                    }
                    try {
                        ContextCleaner.sleep(AbstractContextManager.this.getCleanerSleepMillis());
                    }
                    catch (InterruptedException ie) {
                        AbstractContextManager.this.getLogger().log(Level.FINER, "DMS-57034");
                    }
                }
            }
            finally {
                if (ctx != null) {
                    ctx.deactivate();
                }
                if (this.m_noun != null && this.m_console.isActive()) {
                    this.m_noun.destroy();
                }
            }
        }
    }
}

