/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import java.util.StringTokenizer;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;

public class EventParser {
    public static final long NULL_LONG = 0x7FFFFFFFFFFFFFFCL;

    public static ParsedEvent parseEvent(String eventAsString) {
        ParsedEvent retVal = null;
        try {
            if (eventAsString != null && eventAsString.startsWith("v1:")) {
                StringTokenizer st = new StringTokenizer(eventAsString, ":");
                retVal = new ParsedEvent();
                String versionField = st.nextToken();
                if ("v1".equals(versionField)) {
                    String timeStampField = st.nextToken();
                    long timestamp = Long.parseLong(timeStampField);
                    retVal.mEventTime = timestamp;
                    String sourceTypeField = st.nextToken();
                    retVal.mEventSourceType = EventSourceType.valueOf(sourceTypeField);
                    String actionTypeField = st.nextToken();
                    retVal.mEventActionType = EventActionType.valueOf(actionTypeField);
                    if (retVal.mEventSourceType == EventSourceType.HTTP_REQUEST) {
                        String urlToken = EventParser.getTail(eventAsString, 4);
                        ParsedEvent.access$302(retVal, new String[]{urlToken});
                    } else if (retVal.mEventSourceType == EventSourceType.EXECUTION_CONTEXT) {
                        String idAsString = st.nextToken();
                        ParsedEvent.access$302(retVal, new String[]{idAsString});
                    } else if (retVal.mEventSourceType.isTypeOf(EventSourceType.SENSOR)) {
                        String nounTypeToken = st.nextToken();
                        String sensorNameToken = st.nextToken();
                        String nounPathToken = st.nextToken();
                        if (retVal.mEventActionType == EventActionType.CREATE || retVal.mEventActionType == EventActionType.DELETE || retVal.mEventActionType == EventActionType.METRIC_SELECTION_CHANGED) {
                            ParsedEvent.access$302(retVal, new String[]{nounTypeToken, nounPathToken, sensorNameToken});
                        } else if (retVal.mEventActionType.isTypeOf(EventActionType.UPDATE)) {
                            block1 : switch (retVal.mEventSourceType) {
                                case PHASE_SENSOR: {
                                    ParsedEvent.access$302(retVal, new String[]{nounTypeToken, nounPathToken, sensorNameToken});
                                    switch (retVal.mEventActionType) {
                                        case START: {
                                            long startTime = Long.parseLong(st.nextToken());
                                            ParsedEvent.access$402(retVal, new long[]{startTime});
                                            break block1;
                                        }
                                        case STOP: {
                                            long startTime = Long.parseLong(st.nextToken());
                                            long endTime = Long.parseLong(st.nextToken());
                                            ParsedEvent.access$402(retVal, new long[]{startTime, endTime});
                                            break block1;
                                        }
                                    }
                                    break;
                                }
                                case STATE_SENSOR: {
                                    switch (retVal.mEventActionType) {
                                        case UPDATE: {
                                            String stateTypeAsString = st.nextToken();
                                            String stateValueAsString = EventParser.getTail(eventAsString, 8);
                                            if ("State.DOUBLE".equals(stateTypeAsString)) {
                                                ParsedEvent.access$402(retVal, new long[]{1L});
                                                ParsedEvent.access$302(retVal, new String[]{nounTypeToken, nounPathToken, sensorNameToken, stateValueAsString});
                                                break block1;
                                            }
                                            if ("State.LONG".equals(stateTypeAsString)) {
                                                ParsedEvent.access$402(retVal, new long[]{2L});
                                                ParsedEvent.access$302(retVal, new String[]{nounTypeToken, nounPathToken, sensorNameToken, stateValueAsString});
                                                break block1;
                                            }
                                            if ("State.INTEGER".equals(stateTypeAsString)) {
                                                ParsedEvent.access$402(retVal, new long[]{3L});
                                                ParsedEvent.access$302(retVal, new String[]{nounTypeToken, nounPathToken, sensorNameToken, stateValueAsString});
                                                break block1;
                                            }
                                            ParsedEvent.access$402(retVal, new long[]{5L});
                                            ParsedEvent.access$302(retVal, new String[]{nounTypeToken, nounPathToken, sensorNameToken, stateValueAsString});
                                            break block1;
                                        }
                                    }
                                    break;
                                }
                                case EVENT_SENSOR: {
                                    switch (retVal.mEventActionType) {
                                        case UPDATE: {
                                            ParsedEvent.access$302(retVal, new String[]{nounTypeToken, nounPathToken, sensorNameToken});
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            retVal = null;
        }
        return retVal;
    }

    private static String getTail(String s, int maxColonCount) {
        int charIndex = 0;
        int colonCount = 0;
        while (charIndex < s.length() && colonCount < maxColonCount) {
            if (s.charAt(++charIndex) != ':') continue;
            ++colonCount;
        }
        String retVal = null;
        if (colonCount == maxColonCount && charIndex + 1 < s.length() - 1) {
            retVal = s.substring(charIndex + 1);
        }
        return retVal;
    }

    public static class ParsedEvent {
        private EventSourceType mEventSourceType;
        private EventActionType mEventActionType;
        private long mEventTime;
        private String[] mStrings;
        private long[] mLongs;

        public EventSourceType getEventSourceType() {
            return this.mEventSourceType;
        }

        public EventActionType getEventActionType() {
            return this.mEventActionType;
        }

        public long getEventTime() {
            return this.mEventTime;
        }

        public String getString(StringValueKeys key) {
            String retVal = null;
            if (this.mStrings != null && key.mIndex >= 0 && key.mIndex < this.mStrings.length) {
                retVal = this.mStrings[key.mIndex];
            }
            return retVal;
        }

        public long getLong(LongValueKeys key) {
            long retVal = 0x7FFFFFFFFFFFFFFCL;
            if (this.mLongs != null && key.mIndex >= 0 && key.mIndex < this.mLongs.length) {
                retVal = this.mLongs[key.mIndex];
            }
            return retVal;
        }

        static /* synthetic */ String[] access$302(ParsedEvent x0, String[] x1) {
            x0.mStrings = x1;
            return x1;
        }

        static /* synthetic */ long[] access$402(ParsedEvent x0, long[] x1) {
            x0.mLongs = x1;
            return x1;
        }
    }

    public static enum LongValueKeys {
        START_TIME(0),
        END_TIME(1),
        STATE_SENSOR_TYPE(0);

        int mIndex;

        private LongValueKeys(int index) {
            this.mIndex = index;
        }
    }

    public static enum StringValueKeys {
        URL(0),
        ECID_RID(0),
        NOUN_TYPE_NAME(0),
        NOUN_PATH(1),
        SENSOR_NAME(2),
        STATE_SENSOR_VALUE_AS_STRING(3);

        int mIndex;

        private StringValueKeys(int index) {
            this.mIndex = index;
        }
    }
}

