/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal.was;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import oracle.dms.context.RID;
import oracle.dms.context.internal.AbstractExecutionContext;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.ParameterValueListener;
import oracle.dms.context.internal.was.WASContextFamily;
import oracle.dms.context.internal.was.WASContextManager;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.Time;

public class WASExecutionContext
extends AbstractExecutionContext<WASContextManager, WASContextFamily, WASExecutionContext>
implements DomainExecutionContext<WASExecutionContext> {
    private static final String CLASS_NAME = WASExecutionContext.class.getName();
    private WeakReference<Thread> m_threadRef = null;

    WASExecutionContext(WASContextManager mgr, WASContextFamily ctf, RID rid) {
        super(mgr, ctf, rid);
    }

    WASExecutionContext(WASContextManager mgr, WASExecutionContext parentCtx) {
        super(mgr, parentCtx);
    }

    @Override
    public void suspend2() {
        ((WASContextManager)this.mContextManager).detachFromThread(this, true);
    }

    Thread getThread() {
        return this.m_threadRef == null ? null : (Thread)this.m_threadRef.get();
    }

    void setThread(Thread t) {
        this.m_threadRef = new WeakReference<Thread>(t);
    }

    @Override
    public boolean isActive() {
        return this.m_threadRef == null ? false : this.m_threadRef.get() != null;
    }

    @Override
    protected void disassociateWithThread() {
        ((WASContextManager)this.mContextManager).detachFromThread(this, true);
    }

    @Override
    public void activate() {
        this.activate(false, (WASExecutionContext)null);
    }

    @Override
    public void activate(boolean oldContextKnown, WASExecutionContext oldDomainContext) {
        WASExecutionContext oldContext = oldDomainContext;
        ((WASContextManager)this.mContextManager).attachToThread(this, oldContextKnown, oldContext);
        this.mActivationTime = Time.currentTimeMillis();
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null) {
            eMgr.reportEvent(this.getAsMutableExecutionContext(), EventSourceType.EXECUTION_CONTEXT, EventActionType.START, this.mActivationTime, this.getAsMutableExecutionContext(), null);
        }
        if (this.sLogger.isLoggable(Level.FINER)) {
            this.sLogger.log(Level.FINER, "WASExecutionContext activated [{0}, {1}] - invoked with stack:\n{2}{3}", new Object[]{this.mECID, this.mRID, ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace()), this.getPrettyInstanceStateSummary(Level.FINE)});
        }
    }

    @Override
    @Deprecated
    public String getPrettyInstanceStateSummary(Level level) {
        StringBuilder sb = new StringBuilder();
        sb.append("WASExecutionContext instance: ").append(this.getIDasString());
        if (level.intValue() <= Level.FINE.intValue()) {
            sb.append("\n    m_thread (id): ");
            if (this.m_threadRef == null || this.m_threadRef.get() == null) {
                sb.append("null (-)");
            } else {
                sb.append(((Thread)this.m_threadRef.get()).getName()).append(" (").append(((Thread)this.m_threadRef.get()).getId()).append(')');
            }
            sb.append("\n      m_suspended: ").append(this.mSuspended);
            sb.append("\n  mActivationTime: ").append(this.mActivationTime);
            sb.append("\n  m_ctxContentMap: ").append(this.mCtxContentMap == null ? "null" : Integer.toString(this.mCtxContentMap.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mCtxContentMap != null) {
                for (Map.Entry entry : this.mCtxContentMap.entrySet()) {
                    sb.append("\n                 : ").append(entry.getKey()).append(" -> ").append(entry.getValue());
                }
            }
            sb.append("\n   m_ctxGlobalMap: ").append(this.mCtxGlobalMap == null ? "null" : Integer.toString(this.mCtxGlobalMap.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mCtxGlobalMap != null) {
                for (Map.Entry entry : this.mCtxGlobalMap.entrySet()) {
                    sb.append("\n                 : ").append(entry.getKey()).append(" -> ").append(entry.getValue());
                }
            }
            sb.append("\n    m_ctxLocalMap: ").append(this.mCtxLocalMap == null ? "null" : Integer.toString(this.mCtxLocalMap.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mCtxLocalMap != null) {
                for (Map.Entry entry : this.mCtxLocalMap.entrySet()) {
                    sb.append("\n                 : ").append(entry.getKey()).append(" -> ").append(entry.getValue());
                }
            }
            sb.append("\n    m_inheritable: ").append(this.mInheritable);
            sb.append("\n      m_listeners: ").append(this.mValueListeners == null ? "null" : Integer.toString(this.mValueListeners.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mValueListeners != null) {
                for (ParameterValueListener lsnr : this.mValueListeners) {
                    sb.append("\n                  ").append(lsnr.getClass().getName()).append(" -> ").append(lsnr.toString());
                }
            }
            sb.append("\n m_ctf:" + ((WASContextFamily)this.mContextFamily).getPrettyInstanceStateSummary(level));
            sb.append("\n");
        }
        return sb.toString();
    }

    static String getPrettyClassStateSummary(Level level) {
        return "WASExecutionContext class sumary: (no state information exists)";
    }

    @Override
    protected WASExecutionContext createChildContext(WASContextManager manager, WASExecutionContext parent) {
        WASExecutionContext retVal = new WASExecutionContext(manager, parent);
        return retVal;
    }
}

