/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.PhaseEvent;

public class PhaseEventActivationToken {
    private final long mStartTimeToken;
    private final int mActivationUID;
    private final ActivationParameter[] mActivationParameters;
    private final boolean mIsAnonymous;
    private final String mAnonymousStartOfPath;
    private final String mAnonymousNounType;

    PhaseEventActivationToken(long startTimeToken, int activationUID, ActivationParameter[] activationParameters) {
        this.mStartTimeToken = startTimeToken;
        this.mActivationUID = activationUID;
        this.mActivationParameters = activationParameters;
        this.mIsAnonymous = false;
        this.mAnonymousStartOfPath = null;
        this.mAnonymousNounType = null;
    }

    PhaseEventActivationToken(long startTimeToken, ActivationParameter[] activationParameters, String startOfSensorsPath, String nounType) {
        this.mStartTimeToken = startTimeToken;
        this.mActivationUID = -3;
        this.mActivationParameters = activationParameters;
        this.mIsAnonymous = true;
        this.mAnonymousStartOfPath = startOfSensorsPath;
        this.mAnonymousNounType = nounType;
    }

    boolean isAnonymous() {
        return this.mIsAnonymous;
    }

    boolean sensorMatchesAnonymousStart(PhaseEvent pe) {
        boolean pathMatches = false;
        boolean nounTypeMatches = false;
        if (pe != null) {
            if (this.mAnonymousStartOfPath != null) {
                String phaseName = pe.toString();
                pathMatches = phaseName.startsWith(this.mAnonymousStartOfPath);
            } else {
                pathMatches = true;
            }
            nounTypeMatches = this.mAnonymousNounType != null ? this.mAnonymousNounType.equals(pe.getParent().getType()) : true;
        }
        return pathMatches && nounTypeMatches;
    }

    long getStartTimeToken() {
        return this.mStartTimeToken;
    }

    int getActivationUID() {
        return this.mActivationUID;
    }

    String getAnonymousNounType() {
        return this.mAnonymousNounType;
    }

    String getAnonymousStartOfPath() {
        return this.mAnonymousStartOfPath;
    }

    ActivationParameter[] getActivationParameters() {
        return this.mActivationParameters;
    }
}

