/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config.internal;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.as.jmx.framework.mapping.MBeanProxy;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.config.EventConfigMBean;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;

public class EventConfigHelper {
    private static final String CLASS_NAME = "EventConfigHelper";
    private static final Logger sLogger = Logger.getLogger("oracle.dms.event", EventResourceBundle.class.getName());

    public static EventConfigMBean getLocalEventConfig(MBeanType mbeanType, String serverName) {
        String METHOD_NAME = "getEventConfig";
        EventConfigMBean retVal = null;
        try {
            PlatformSupport sps = PlatformSupportFactory.getPlatformSupport();
            if (!sps.isAdminServer() && mbeanType.getServerType() == MBeanServerType.DOMAIN_RUNTIME) {
                throw new IllegalArgumentException("The EventConfigMBean type requested, " + (Object)((Object)mbeanType) + ", can only be found in the domain runtime mbean server, and the domain runtime mbean server is not available on this server.");
            }
            if (serverName == null) {
                serverName = sps.getServerName();
            }
            MBeanServerConnection mbsc = null;
            mbsc = mbeanType.getServerType().getLocalMBeanServerConnection();
            ObjectName mBeanName = mbeanType.getMBeanName(serverName);
            retVal = (EventConfigMBean)MBeanProxy.newProxyInstance((MBeanServerConnection)mbsc, (ObjectName)mBeanName, EventConfigMBean.class, (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            sLogger.logp(Level.WARNING, CLASS_NAME, "getEventConfig", "Failed to fetch the " + (Object)((Object)mbeanType) + " EventConfigMBean for server " + serverName, e);
        }
        return retVal;
    }

    public static Set<ObjectName> findMBeanNames(MBeanType mbeanType, MBeanServerConnection mbsc) throws Exception {
        ObjectName objectNamePattern = mbeanType.getMBeanName("*");
        Set<ObjectName> matchingNames = mbsc.queryNames(objectNamePattern, null);
        return matchingNames;
    }

    public static enum MBeanServerType {
        DOMAIN_RUNTIME("/jndi/weblogic.management.mbeanservers.domainruntime", new String[]{"java:comp/jmx/domainRuntime", "java:comp/env/jmx/domainRuntime"}),
        RUNTIME("/jndi/weblogic.management.mbeanservers.runtime", new String[]{"java:comp/jmx/runtime", "java:comp/env/jmx/runtime"});

        private String mRemoteJndiName;
        private String[] mLocalJndiNames;

        private MBeanServerType(String jndiName, String[] localJndiNames) {
            this.mRemoteJndiName = jndiName;
            this.mLocalJndiNames = localJndiNames;
        }

        public JMXServiceURL getJMXServiceURL(String serverHostName, String serverHostPort) throws Exception {
            if (serverHostName.startsWith("localhost")) {
                throw new IllegalArgumentException("MBean servers are not exposed on localhost, must use proper host name.");
            }
            String providerUrl = this.getProviderURL(serverHostName, serverHostPort);
            JMXServiceURL retVal = new JMXServiceURL("service:jmx:" + providerUrl + this.mRemoteJndiName);
            return retVal;
        }

        public String getProviderURL(String serverHostName, String serverHostPort) throws Exception {
            return "t3://" + serverHostName + ":" + serverHostPort;
        }

        public MBeanServerConnection getLocalMBeanServerConnection() {
            MBeanServer retVal = null;
            InitialContext ctx = null;
            if (System.getProperty("weblogic.Name") != null) {
                try {
                    ctx = new InitialContext();
                    retVal = (MBeanServer)ctx.lookup(this.mLocalJndiNames[0]);
                }
                catch (NamingException e) {
                    try {
                        if (ctx != null && this.mLocalJndiNames.length >= 1) {
                            retVal = (MBeanServer)ctx.lookup(this.mLocalJndiNames[1]);
                        }
                    }
                    catch (NamingException e2) {
                        // empty catch block
                    }
                }
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            return retVal;
        }
    }

    public static enum MBeanType {
        READ_WRITE(MBeanServerType.DOMAIN_RUNTIME, true, false){

            @Override
            public ObjectName getMBeanName(String serverName) throws Exception {
                return new ObjectName("oracle.dms.event.config:type=JMXEventConfig,name=DMSEventConfigMBean,ServerName=" + serverName);
            }
        }
        ,
        READ_ONLY(MBeanServerType.RUNTIME, false, true){

            @Override
            public ObjectName getMBeanName(String serverName) throws Exception {
                return new ObjectName("oracle.dms.event.config:name=DMSEventConfigMBean,type=JMXEventConfig");
            }
        }
        ,
        READ_ONLY_PROXY_ON_ADMIN_SERVER(MBeanServerType.DOMAIN_RUNTIME, false, false){

            @Override
            public ObjectName getMBeanName(String serverName) throws Exception {
                return new ObjectName("oracle.dms.event.config:Location=" + serverName + ",name=DMSEventConfigMBean,type=JMXEventConfig");
            }
        };

        MBeanServerType mMBeanServerType;
        boolean mCanUpdate;
        boolean mSendsChangeNotifications;

        private MBeanType(MBeanServerType mbeanServerType, boolean canUpdate, boolean sendsChangeNotifications) {
            this.mMBeanServerType = mbeanServerType;
            this.mCanUpdate = canUpdate;
            this.mSendsChangeNotifications = sendsChangeNotifications;
        }

        public MBeanServerType getServerType() {
            return this.mMBeanServerType;
        }

        public boolean canUpdate() {
            return this.mCanUpdate;
        }

        public boolean sendsChangeNotifications() {
            return this.mSendsChangeNotifications;
        }

        public ObjectName getMBeanName(String serverName) throws Exception {
            throw new RuntimeException("Operation getMBeanName() called on an MBeanType that does not support it.");
        }
    }
}

