/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.dump.formatter.TableFormatter;
import oracle.dfw.impl.dump.AccessCheck;
import oracle.dfw.impl.dump.ExternalUtility;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

public class ThreadDump
extends ComponentDiagnosticDump
implements DiagnosticsListener {
    public static final String HEADER = "===== FULL THREAD DUMP ===============";
    public static final String FOOTER = "===== END OF THREAD DUMP ===============";
    private static final String EMPTY_STRING = "";
    private static final String TIMING_ARG = "timing";
    private static final String CONTEXT_ARG = "context";
    private static final String PROGRESSIVE_ARG = "progressive";
    private static final String DEPTH_ARG = "depth";
    private static final String SAMETHRGRP_ARG = "samegroup";
    private static final String THRESHOLD_ARG = "threshold";
    private static final String EXTERNAL_ARG = "external";
    private static final String IDS_ARG = "ids";
    private static final String THREAD_STATE_FIELD = "   java.lang.Thread.State: ";
    private static final int MAX_PROGRESSIVE_LEVEL = 5;
    private static final int THRESHOLD_PARTIAL_STACK = 0;
    private static final int THRESHOLD_CONTEXT = 1;
    private static final int THRESHOLD_TIMING = 2;
    private static final int THRESHOLD_FULLSTACKTRACE = 3;
    private static final int THRESHOLD_LOCKOWNERTHREADS = 4;
    private static final int DEFAULT_THRESHOLD = 30000;
    private volatile boolean m_useExternal = true;
    private static boolean s_platformCanUseExternal = true;
    private static boolean s_alreadyIdentifiedPlatform = false;
    private DiagnosticsConfiguration m_config;
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();
    private static ThreadMXBean s_bean = ManagementFactory.getThreadMXBean();
    private static String INDENT = "        ";
    private static boolean s_timingSupported = s_bean.isThreadCpuTimeSupported() && s_bean.isThreadCpuTimeEnabled();
    private static String s_header = "";
    private static DateFormat s_headerDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ThreadDump() {
        this.defineArgument(TIMING_ARG, ArgumentType.BOOLEAN, false, DFW_MESSAGES, "DFW_THREADS_TIMING_ARG");
        this.defineArgument(CONTEXT_ARG, ArgumentType.BOOLEAN, false, DFW_MESSAGES, "DFW_THREADS_CONTEXT_ARG");
        this.defineArgument(PROGRESSIVE_ARG, ArgumentType.BOOLEAN, false, DFW_MESSAGES, "DFW_THREADS_PROGRESSIVE_ARG");
        this.defineArgument(DEPTH_ARG, ArgumentType.INTEGER, false, DFW_MESSAGES, "DFW_THREADS_STACKTRACE_DEPTH_ARG");
        this.defineArgument(SAMETHRGRP_ARG, ArgumentType.BOOLEAN, false, DFW_MESSAGES, "DFW_THREADS_SAMETHRGRP_ARG");
        this.defineArgument(THRESHOLD_ARG, ArgumentType.LONG, false, DFW_MESSAGES, "DFW_THREADS_THRESHOLD_ARG");
        this.defineArgument(IDS_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_THREADS_IDS_ARG");
        this.defineArgument(EXTERNAL_ARG, ArgumentType.BOOLEAN, false, DFW_MESSAGES, "DFW_THREADS_EXTERNAL_ARG");
        ThreadDump.identifyPlatform();
        ThreadDump.constructHeaderInfo();
    }

    public ThreadDump(boolean useExternalCommands) {
        this();
        this.m_useExternal = useExternalCommands;
    }

    public ThreadDump(DiagnosticsConfiguration config) {
        this();
        this.m_config = config;
        this.m_useExternal = this.m_config.useThreadDumpExternalCommands();
        DiagnosticsEventManager.registerListener(this);
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        DumpWriter dw = new DumpWriter(context);
        boolean includeTimingInfo = context.getArguments().getBool(TIMING_ARG, false);
        boolean includeContextInfo = context.getArguments().getBool(CONTEXT_ARG, false);
        boolean isProgressive = context.getArguments().getBool(PROGRESSIVE_ARG, false);
        int depth = context.getArguments().getInt(DEPTH_ARG, Integer.MAX_VALUE);
        boolean isSameThreadGroup = context.getArguments().getBool(SAMETHRGRP_ARG, false);
        long threshold = context.getArguments().getLong(THRESHOLD_ARG, 30000L);
        boolean isForceExternal = context.getArguments().getBool(EXTERNAL_ARG, false);
        String idsStr = context.getArguments().getString(IDS_ARG, null);
        long[] thresholds = new long[5];
        for (int i = 0; i < 5; ++i) {
            thresholds[i] = (long)(i + 1) * threshold;
        }
        long[] excIDs = null;
        if (idsStr != null && idsStr.length() > 0) {
            excIDs = ThreadDump.parseIDs(idsStr);
        }
        long capturedTime = System.currentTimeMillis();
        ArrayList<ThreadSnapshot> snapshots = null;
        boolean alreadyDumped = false;
        if (isForceExternal || !isProgressive && this.m_useExternal && s_platformCanUseExternal) {
            try {
                ExternalUtility.execute(ExternalUtility.COMMAND.THREAD, dw);
                alreadyDumped = true;
                if (includeTimingInfo && s_timingSupported || includeContextInfo) {
                    long[] ids = excIDs;
                    if (ids == null) {
                        ids = ThreadDump.getThreadIds(isSameThreadGroup);
                    }
                    snapshots = ThreadDump.takeSnapshot(System.currentTimeMillis(), ids, 0, false, thresholds);
                }
            }
            catch (Exception e) {
                dw.dumpln("Unable to collect thread dump externally due to " + e.getMessage());
                dw.dumpln("Use internal thread dump via JMX");
            }
        }
        if (!alreadyDumped) {
            snapshots = ThreadDump.internalThreadDump(capturedTime, dw, depth, isProgressive, isSameThreadGroup, thresholds, excIDs);
        }
        int snapshotCount = 0;
        if (snapshots != null && snapshots.size() > 0) {
            if (includeTimingInfo && s_timingSupported) {
                ThreadDump.dumpThreadTimingInfo(snapshots, isProgressive, thresholds, dw);
            }
            if (includeContextInfo) {
                ThreadDump.dumpContextInfo(snapshots, isProgressive, thresholds, dw);
            }
            snapshotCount = snapshots.size();
        }
        ThreadDump.dumpStatistics(capturedTime, snapshotCount, thresholds[0], isProgressive, dw);
        if (snapshots != null) {
            snapshots.clear();
        }
        return dw.getDumpResult();
    }

    public static void dumpStatistics(long capturedTime, int dumpCount, long threshold, boolean progressive, DumpWriter dw) {
        dw.dumpln("===== THREAD STATISTICS =====");
        dw.dumpln("Live threads: " + s_bean.getThreadCount());
        dw.dumpln("Started threads: " + s_bean.getTotalStartedThreadCount());
        dw.dumpln("Peak live threads: " + s_bean.getPeakThreadCount());
        dw.dumpln("Daemon threads: " + s_bean.getDaemonThreadCount());
        dw.dumpln("Thread Dump mode: " + (progressive ? "Partial" : "Full"));
        dw.dumpln("Threads dumped: " + dumpCount);
        dw.dumpln("Progressive threshold: " + threshold + " msec");
        dw.dumpln("Thread Dump Elapsed: " + Long.toString(System.currentTimeMillis() - capturedTime) + " msec");
        dw.dumpln("===== END OF THREAD STATISTICS =====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void constructHeaderInfo() {
        String string = s_header;
        synchronized (string) {
            if (s_header.length() == 0) {
                StringBuffer header = new StringBuffer();
                header.append(" thread dump ");
                header.append(AccessCheck.getProperty("java.vm.name"));
                header.append(" (");
                header.append(AccessCheck.getProperty("java.vm.version"));
                header.append(" ");
                header.append(AccessCheck.getProperty("java.vm.info"));
                header.append("):\n");
                s_header = header.toString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ThreadSnapshot> internalThreadDump(long capturedTime, DumpWriter dw, int depth, boolean progressive, boolean sameThreadGroup, long[] thresholds, long[] excIDs) {
        StringBuffer header = new StringBuffer();
        String timestamp = EMPTY_STRING;
        if (s_headerDateFormat != null) {
            DateFormat dateFormat = s_headerDateFormat;
            synchronized (dateFormat) {
                timestamp = s_headerDateFormat.format(new Date(capturedTime));
            }
        }
        header.append("\n");
        header.append(HEADER);
        header.append("\n");
        header.append(timestamp);
        header.append("\n");
        String headerPrefix = progressive ? "Progressive" : "Full";
        header.append(headerPrefix);
        header.append(s_header);
        dw.dumpln(header.toString());
        long[] tids = null;
        tids = excIDs == null ? (sameThreadGroup ? ThreadDump.getThreadIdsFromThisGroupOnly() : ThreadDump.getAllThreadIds()) : excIDs;
        ArrayList<ThreadSnapshot> snapshots = ThreadDump.takeSnapshot(capturedTime, tids, depth, progressive, thresholds);
        for (ThreadSnapshot ts : snapshots) {
            ThreadDump.dumpThreadInfo(ts, dw, true);
        }
        if (!progressive && excIDs == null) {
            ThreadDump.dumpDeadlockThreads(dw, snapshots);
        }
        dw.dumpln(FOOTER);
        dw.dumpln(EMPTY_STRING);
        return snapshots;
    }

    private static long[] getDeadLockedThreads() {
        long[] tids = null;
        tids = AccessController.doPrivileged(new PrivilegedAction<long[]>(){

            @Override
            public long[] run() {
                return s_bean.findMonitorDeadlockedThreads();
            }
        });
        return tids;
    }

    private static long[] getThreadIdsFromThisGroupOnly() {
        Thread[] tarray;
        int count;
        long[] ids = null;
        Thread.currentThread();
        int n = Thread.activeCount();
        if (n > 0 && (count = ThreadDump.getThreadsOfThisGroup(tarray = new Thread[n])) > 0) {
            ids = new long[count];
            for (int i = 0; i < count && i < tarray.length; ++i) {
                if (tarray[i] == null) continue;
                ids[i] = tarray[i].getId();
            }
        }
        return ids;
    }

    private static long[] getThreadIds(boolean isSameThreadGroup) {
        long[] tids = null;
        tids = isSameThreadGroup ? ThreadDump.getThreadIdsFromThisGroupOnly() : ThreadDump.getAllThreadIds();
        return tids;
    }

    private static long[] getAllThreadIds() {
        long[] ids = AccessController.doPrivileged(new PrivilegedAction<long[]>(){

            @Override
            public long[] run() {
                return s_bean.getAllThreadIds();
            }
        });
        return ids;
    }

    private static int getThreadsOfThisGroup(final Thread[] tarray) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                Thread.currentThread();
                return Thread.enumerate(tarray);
            }
        });
    }

    private static ThreadInfo getThreadInfo(final long id, final int depth) {
        ThreadInfo info = null;
        info = AccessController.doPrivileged(new PrivilegedAction<ThreadInfo>(){

            @Override
            public ThreadInfo run() {
                return s_bean.getThreadInfo(id, depth);
            }
        });
        return info;
    }

    private static ThreadInfo[] getThreadInfo(final long[] ids, final int depth) {
        ThreadInfo[] info = null;
        info = AccessController.doPrivileged(new PrivilegedAction<ThreadInfo[]>(){

            @Override
            public ThreadInfo[] run() {
                return s_bean.getThreadInfo(ids, depth);
            }
        });
        return info;
    }

    private static ThreadInfo[] getThreadInfo(final long[] ids, final boolean lockedMonitors, final boolean lockedSynchronizers) {
        ThreadInfo[] info = null;
        info = AccessController.doPrivileged(new PrivilegedAction<ThreadInfo[]>(){

            @Override
            public ThreadInfo[] run() {
                return s_bean.getThreadInfo(ids, lockedMonitors, lockedSynchronizers);
            }
        });
        return info;
    }

    private static ArrayList<ThreadSnapshot> takeSnapshot(long capturedTime, long[] ids, int maxDepth, boolean isProgressive, long[] thresholds) {
        int initialLength = 0;
        if (ids != null) {
            initialLength = ids.length;
        }
        ArrayList<ThreadSnapshot> snapshots = new ArrayList<ThreadSnapshot>(initialLength);
        if (isProgressive) {
            Hashtable<Long, ThreadSnapshot> fullStackSh = new Hashtable<Long, ThreadSnapshot>();
            Hashtable<Long, ThreadSnapshot> partialStackSh = new Hashtable<Long, ThreadSnapshot>();
            boolean toExcludeMyself = true;
            long myOwnId = Thread.currentThread().getId();
            for (int i = 0; i < ids.length; ++i) {
                String key;
                Map<String, String> contextValues;
                StackTraceElement ste;
                String topMethodName;
                StackTraceElement[] stes;
                LockInfo lockInfo;
                String thrName;
                ThreadInfo ti;
                long beginTime;
                long ctxElapsedTime = -1L;
                long tid = ids[i];
                if (toExcludeMyself && myOwnId == tid) {
                    toExcludeMyself = false;
                    continue;
                }
                ExecutionContext ctx = DMSContextManager.getContext(tid);
                if (ctx == null || (beginTime = ctx.getActivationTime()) < 0L || (ti = ThreadDump.getThreadInfo(tid, 1)) == null || (thrName = ti.getThreadName()) != null && (thrName = thrName.toLowerCase()).indexOf("standby") != -1 || (lockInfo = ti.getLockInfo()) != null && (stes = ti.getStackTrace()) != null && stes.length > 0 && stes[0] != null && (topMethodName = (ste = stes[0]).getMethodName()) != null && topMethodName.equals("park") || (contextValues = ctx.getAllValues()) == null || contextValues.size() == 0 || contextValues.size() == 1 && (key = contextValues.keySet().iterator().next()) != null && key.indexOf("dbRID") != -1) continue;
                String ecid = ctx.getECID();
                String rid = ctx.getRIDasString();
                ctxElapsedTime = capturedTime - beginTime;
                ThreadSnapshot snapshot = null;
                if (ctxElapsedTime >= thresholds[4]) {
                    long ownerId = ti.getLockOwnerId();
                    if (ownerId > 0L && !fullStackSh.containsKey(ownerId)) {
                        ThreadSnapshot s = ThreadDump.takeAContextSnapshot(ownerId, null, capturedTime);
                        fullStackSh.put(ownerId, s);
                        snapshots.add(s);
                    }
                    snapshot = new ThreadSnapshot(tid, null, ecid, rid, contextValues, ctxElapsedTime);
                    fullStackSh.put(tid, snapshot);
                } else if (ctxElapsedTime >= thresholds[3]) {
                    snapshot = new ThreadSnapshot(tid, null, ecid, rid, contextValues, ctxElapsedTime);
                    fullStackSh.put(tid, snapshot);
                } else if (ctxElapsedTime >= thresholds[0]) {
                    snapshot = new ThreadSnapshot(tid, null, ecid, rid, contextValues, ctxElapsedTime);
                    partialStackSh.put(tid, snapshot);
                } else {
                    snapshot = new ThreadSnapshot(tid, ti, ecid, rid, contextValues, ctxElapsedTime);
                }
                snapshots.add(snapshot);
            }
            if (fullStackSh.size() > 0) {
                ThreadDump.updateSnapshotsWithStackTrace(fullStackSh, true, maxDepth);
            }
            if (partialStackSh.size() > 0) {
                ThreadDump.updateSnapshotsWithStackTrace(partialStackSh, false, maxDepth);
            }
        } else {
            ThreadInfo[] tInfos = null;
            if (maxDepth != Integer.MAX_VALUE) {
                tInfos = new ThreadInfo[ids.length];
                for (int i = 0; i < tInfos.length; ++i) {
                    tInfos[i] = ThreadDump.getThreadInfo(ids[i], maxDepth);
                }
            } else {
                try {
                    tInfos = ThreadDump.getThreadInfo(ids, s_bean.isObjectMonitorUsageSupported(), s_bean.isSynchronizerUsageSupported());
                }
                catch (UnsupportedOperationException uoex) {
                    tInfos = ThreadDump.getThreadInfo(ids, false, false);
                }
            }
            for (ThreadInfo ti : tInfos) {
                if (ti == null) continue;
                snapshots.add(ThreadDump.takeAContextSnapshot(ti.getThreadId(), ti, capturedTime));
            }
        }
        ThreadDump.verifySnapshots(snapshots);
        return snapshots;
    }

    private static ThreadSnapshot takeAContextSnapshot(long tid, ThreadInfo ti, long dumpTime) {
        ExecutionContext ctx = DMSContextManager.getContext(tid);
        String ecid = null;
        String rid = null;
        Map<String, String> contextValues = null;
        long elapsed = -1L;
        if (ctx != null) {
            ecid = ctx.getECID();
            rid = ctx.getRIDasString();
            contextValues = ctx.getAllValues();
            long actTime = ctx.getActivationTime();
            if (actTime >= 0L) {
                elapsed = dumpTime - actTime;
            }
        }
        return new ThreadSnapshot(tid, ti, ecid, rid, contextValues, elapsed);
    }

    private static long[] threadIdsOf(Hashtable<Long, ThreadSnapshot> snapshots) {
        long[] tids = null;
        if (snapshots.size() <= 0) {
            return tids;
        }
        Long[] tidObjs = new Long[snapshots.size()];
        tidObjs = snapshots.keySet().toArray(tidObjs);
        tids = new long[tidObjs.length];
        for (int i = 0; i < tids.length; ++i) {
            tids[i] = tidObjs[i];
        }
        return tids;
    }

    private static void updateSnapshotsWithStackTrace(Hashtable<Long, ThreadSnapshot> snapshots, boolean fullStack, int depth) {
        long[] tids = ThreadDump.threadIdsOf(snapshots);
        ThreadInfo[] tinfos = null;
        if (fullStack) {
            try {
                tinfos = ThreadDump.getThreadInfo(tids, s_bean.isObjectMonitorUsageSupported(), false);
            }
            catch (UnsupportedOperationException uoex) {
                tinfos = ThreadDump.getThreadInfo(tids, false, false);
            }
        } else {
            tinfos = ThreadDump.getThreadInfo(tids, depth);
        }
        if (tinfos != null) {
            for (ThreadInfo tinfo : tinfos) {
                ThreadSnapshot snapshot;
                if (tinfo == null || (snapshot = snapshots.get(tinfo.getThreadId())) == null) continue;
                snapshot.m_threadInfo = tinfo;
            }
        } else {
            snapshots.clear();
        }
    }

    private static void dumpThreadInfo(ThreadSnapshot ts, DumpWriter dw, boolean withThreadState) {
        ThreadInfo ti = ts.m_threadInfo;
        if (ti == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (withThreadState) {
            sb.append("\"");
            sb.append(ti.getThreadName());
            sb.append("\"");
            sb.append(" prio=10 id=");
            sb.append(ts.m_tid);
            sb.append(" ");
            if (ts.m_ecid != null) {
                sb.append("ecid=");
                sb.append(ts.m_ecid);
                sb.append(" elapsed=");
                sb.append(ts.m_elapsed);
                sb.append(" ");
            }
            sb.append("\n");
            sb.append(THREAD_STATE_FIELD);
            Thread.State state = ti.getThreadState();
            if (state != null) {
                sb.append(state.toString().toUpperCase());
            }
            if (ti.isSuspended()) {
                sb.append(" (suspended)");
            }
        }
        String topMethodName = null;
        boolean isNatveFrameOnTop = false;
        StackTraceElement[] stes = ti.getStackTrace();
        if (stes != null && stes.length > 0 && stes[0] != null) {
            StackTraceElement ste = stes[0];
            topMethodName = ste.getMethodName();
            isNatveFrameOnTop = ste.isNativeMethod();
        }
        int initialStackIdx = 0;
        LockInfo lockInfo = ti.getLockInfo();
        String extendedState = EMPTY_STRING;
        if (lockInfo != null) {
            if (topMethodName != null && topMethodName.equals("park")) {
                if (withThreadState) {
                    extendedState = " (parking)";
                    sb.append(extendedState);
                    dw.dumpln(sb.toString());
                }
                if (isNatveFrameOnTop) {
                    dw.dumpln(INDENT + "at " + stes[0].toString());
                    initialStackIdx = 1;
                }
                dw.dumpln(ThreadDump.getLockDescription("parking to wait for", lockInfo));
            } else {
                if (withThreadState) {
                    extendedState = " (on object monitor)";
                    sb.append(extendedState);
                    dw.dumpln(sb.toString());
                }
                if (isNatveFrameOnTop) {
                    dw.dumpln(INDENT + "at " + stes[0].toString());
                    initialStackIdx = 1;
                }
                dw.dumpln(ThreadDump.getLockDescription("waiting on", lockInfo));
            }
        } else if (withThreadState) {
            if (topMethodName != null && topMethodName.equals("sleep")) {
                extendedState = " (sleeping)";
                sb.append(extendedState);
            }
            dw.dumpln(sb.toString());
        }
        MonitorInfo[] lockMonInfo = ti.getLockedMonitors();
        int lockMonIdx = 0;
        if (stes != null) {
            for (int i = initialStackIdx; i < stes.length; ++i) {
                StackTraceElement ste = stes[i];
                if (ste == null) continue;
                while (lockMonInfo != null && lockMonIdx < lockMonInfo.length && lockMonInfo[lockMonIdx].getLockedStackDepth() == i) {
                    dw.dumpln(ThreadDump.getLockDescription("locked", lockMonInfo[lockMonIdx]));
                    ++lockMonIdx;
                }
                dw.dumpln(INDENT + "at " + ste.toString());
                if (ts.m_threadInfo == ti) continue;
                ts.m_threadInfo = ti;
            }
        }
        if (withThreadState) {
            LockInfo[] lockSyncInfo = ti.getLockedSynchronizers();
            dw.dumpln(EMPTY_STRING);
            dw.dumpln("   Locked ownable synchronizers:");
            if (lockSyncInfo != null && lockSyncInfo.length > 0) {
                for (LockInfo li : lockSyncInfo) {
                    if (li == null) continue;
                    dw.dumpln(ThreadDump.getLockDescription(EMPTY_STRING, li));
                }
            } else {
                dw.dumpln(INDENT + "- None");
            }
        }
        dw.dumpln();
    }

    private static void verifySnapshots(ArrayList<ThreadSnapshot> snapshots) {
        if (snapshots == null) {
            return;
        }
        for (int i = 0; i < snapshots.size(); ++i) {
            ThreadSnapshot s = snapshots.get(i);
            if (s != null && s.m_threadInfo != null) continue;
            snapshots.remove(i--);
            if (snapshots.size() <= 0) break;
        }
    }

    private static String getLockDescription(String state, LockInfo mInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT);
        sb.append("- ");
        sb.append(state);
        sb.append(" <0x");
        sb.append(Long.toHexString(mInfo.getIdentityHashCode()));
        sb.append("> (a ");
        sb.append(mInfo.getClassName());
        sb.append(")");
        return sb.toString();
    }

    private static int dumpDeadlockThreads(DumpWriter dw, ArrayList<ThreadSnapshot> snapshotList) {
        long[] deadlocktids = ThreadDump.getDeadLockedThreads();
        int deadlocks = 0;
        if (deadlocktids == null || deadlocktids.length == 0 || snapshotList == null || snapshotList.size() == 0) {
            return 0;
        }
        Hashtable<Long, Long> ownerIds = new Hashtable<Long, Long>(deadlocktids.length);
        Hashtable<Long, ThreadSnapshot> snapshots = new Hashtable<Long, ThreadSnapshot>(deadlocktids.length);
        for (ThreadSnapshot s : snapshotList) {
            long ownerId;
            ThreadInfo tinfo;
            if (s == null || (tinfo = s.m_threadInfo) == null || (ownerId = tinfo.getLockOwnerId()) == -1L) continue;
            ownerIds.put(s.m_tid, s.m_threadInfo.getLockOwnerId());
            snapshots.put(s.m_tid, s);
        }
        ArrayList<ArrayList<Long>> chains = ThreadDump.findCircularChains(deadlocktids, ownerIds);
        if (chains == null) {
            return deadlocks;
        }
        deadlocks = chains.size();
        for (int i = 0; i < chains.size(); ++i) {
            ThreadSnapshot snapshot;
            Long tid;
            ArrayList<Long> chain = chains.get(i);
            if (chain.size() <= 0) continue;
            dw.dumpln("Found one Java-level deadlock:");
            dw.dumpln("=============================");
            for (int j = 0; j < chain.size(); ++j) {
                ThreadSnapshot ownerSnapshot;
                ThreadInfo tinfo;
                LockInfo linfo;
                tid = chain.get(j);
                snapshot = (ThreadSnapshot)snapshots.get(tid);
                if (snapshot == null || (linfo = (tinfo = snapshot.m_threadInfo).getLockInfo()) == null) continue;
                dw.dumpln("\"" + tinfo.getThreadName() + "\":");
                dw.dump("  waiting to lock monitor (object 0x");
                dw.dump(Long.toHexString(linfo.getIdentityHashCode()));
                dw.dump(", a ");
                dw.dump(linfo.getClassName());
                dw.dumpln("),");
                long ownerId = tinfo.getLockOwnerId();
                if (ownerId < 0L || (ownerSnapshot = (ThreadSnapshot)snapshots.get(ownerId)) == null) continue;
                dw.dumpln("  which is held by \"" + ownerSnapshot.m_threadInfo.getThreadName() + "\"");
            }
            dw.dumpln();
            dw.dumpln("Java stack information for the threads listed above:");
            dw.dumpln("===================================================");
            for (int n = 0; n < chain.size(); ++n) {
                tid = chain.get(n);
                snapshot = (ThreadSnapshot)snapshots.get(tid);
                if (snapshot == null) continue;
                dw.dumpln("\"" + snapshot.m_threadInfo.getThreadName() + "\":");
                ThreadDump.dumpThreadInfo(snapshot, dw, false);
            }
            dw.dumpln();
        }
        if (deadlocks > 0) {
            dw.dump("Found " + deadlocks + " deadlock");
            dw.dumpln(deadlocks > 1 ? "s." : ".");
            dw.dumpln();
        }
        return deadlocks;
    }

    private static ArrayList<ArrayList<Long>> findCircularChains(long[] deadlocktids, Hashtable<Long, Long> ownertids) {
        ArrayList<ArrayList<Long>> chains = new ArrayList<ArrayList<Long>>(1);
        ArrayList<Long> workingSet = new ArrayList<Long>(deadlocktids.length);
        long[] arr$ = deadlocktids;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long id = arr$[i$];
            if (id < 0L) continue;
            workingSet.add(id);
        }
        block1: while (workingSet.size() > 0) {
            ArrayList<Long> chain = new ArrayList<Long>(2);
            long head = (Long)workingSet.remove(0);
            Long tail = ownertids.get(head);
            if (tail == null) continue;
            int i = 0;
            while (i < workingSet.size()) {
                Long tId = (Long)workingSet.get(i);
                if (tail.equals(tId)) {
                    chain.add(tId);
                    workingSet.remove(i);
                    tail = ownertids.get(tId);
                    if (tail == null) continue block1;
                    if (tail.equals(head)) {
                        chain.add(head);
                        chains.add(chain);
                        continue block1;
                    }
                    i = 0;
                    continue;
                }
                ++i;
            }
        }
        return chains;
    }

    private static void dumpThreadTimingInfo(long id, ThreadInfo ti, String ecid, long ctxElapsed, TableFormatter tf) {
        String elapsedStr = ctxElapsed < 0L ? "NA" : Long.toString(ctxElapsed);
        tf.addRow("id=" + id, s_bean.getThreadCpuTime(id) / 1000000L, s_bean.getThreadUserTime(id) / 1000000L, ti.getBlockedTime(), ti.getWaitedTime(), ti.getBlockedCount(), ti.getWaitedCount(), elapsedStr, ecid);
    }

    static void dumpThreadTimingInfo(ArrayList<ThreadSnapshot> snapshots, boolean isProgressive, long[] thresholds, DumpWriter dw) {
        dw.dumpln("===== THREAD TIMING STATISTICS =====");
        dw.dumpln();
        TableFormatter tf = new TableFormatter(dw, true);
        tf.addColumn("id", 10, false);
        tf.addColumn("Cpu/ms", 12, false);
        tf.addColumn("User/ms", 12, false);
        tf.addColumn("Blk/ms", 12, false);
        tf.addColumn("Wait/ms", 12, false);
        tf.addColumn("#Blk", 12, false);
        tf.addColumn("#Wait", 12, false);
        tf.addColumn("CxEl/ms", 12, false);
        tf.addColumn("ECID", 40, false);
        for (ThreadSnapshot ts : snapshots) {
            if (ts == null || ts.m_threadInfo == null || isProgressive && ts.m_elapsed <= thresholds[2]) continue;
            ThreadDump.dumpThreadTimingInfo(ts.m_tid, ts.m_threadInfo, ts.m_ecid, ts.m_elapsed, tf);
        }
        dw.dumpln();
        dw.dumpln("===== END OF THREAD TIMING STATISTICS =====\n");
    }

    static void dumpContextInfo(ArrayList<ThreadSnapshot> snapshots, boolean isProgressive, long[] thresholds, DumpWriter dw) {
        dw.dumpln("===== THREAD CONTEXT INFORMATION =====");
        dw.dumpln(EMPTY_STRING);
        TableFormatter tf = new TableFormatter(dw, true);
        tf.addColumn("id", 10, false);
        tf.addColumn("ECID", 50, false);
        tf.addColumn("RID", 5, false);
        tf.addColumn("Elapsed/ms", 12, false);
        tf.addColumn("Context Values", 60, false);
        for (ThreadSnapshot ts : snapshots) {
            if (ts.m_ecid == null || isProgressive && ts.m_elapsed <= thresholds[1]) continue;
            ThreadDump.dumpContextInfo(ts.m_tid, ts.m_ecid, ts.m_rid, ts.m_elapsed, ts.m_contextValues, tf);
        }
        dw.dumpln(EMPTY_STRING);
        dw.dumpln("===== END OF THREAD CONTEXT INFORMATION =====\n");
    }

    private static void dumpContextInfo(long ti, String ecid, String rid, long elapsed, Map<String, String> contextValues, TableFormatter tf) {
        String elapsedStr;
        String string = elapsedStr = elapsed < 0L ? "NA" : Long.toString(elapsed);
        if (contextValues == null || contextValues.size() == 0) {
            tf.addRow("id=" + ti, ecid, rid, elapsedStr, EMPTY_STRING);
        } else {
            boolean first = true;
            for (Map.Entry<String, String> entry : contextValues.entrySet()) {
                if (first) {
                    tf.addRow("id=" + ti, ecid, rid, elapsedStr, entry.getKey() + "=" + entry.getValue());
                    first = false;
                    continue;
                }
                tf.addRow(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, entry.getKey() + "=" + entry.getValue());
            }
        }
    }

    private static long[] parseIDs(String str) {
        long[] ids = null;
        ArrayList<Long> list = new ArrayList<Long>();
        StringTokenizer tknz = new StringTokenizer(str.trim(), ",");
        while (tknz.hasMoreTokens()) {
            String idStr = tknz.nextToken();
            try {
                long id = Long.parseLong(idStr.trim());
                if (id <= 0L) continue;
                list.add(id);
            }
            catch (Exception ex) {
                idStr = null;
            }
        }
        if (list.size() > 0) {
            ids = new long[list.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (Long)list.get(i);
            }
        }
        return ids;
    }

    @Override
    public String getName() {
        return "threads";
    }

    @Override
    public String getOwner() {
        return "jvm";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.THREADS);
    }

    @Override
    public String getDumpDescription() {
        return this.getMsg("DFW_THREADS_DESCRIPTION", null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_THREADS_DESCRIPTION", locale);
    }

    @Override
    public DiagnosticDump.DumpRunMode getRunMode() {
        return DiagnosticDump.DumpRunMode.SYNCHRONOUS_ASYNCHRONOUS;
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    static void identifyPlatform() {
        if (s_alreadyIdentifiedPlatform) {
            return;
        }
        boolean isSunOS = false;
        boolean isBIServer = false;
        boolean isJRockit = false;
        try {
            String val = AccessCheck.getProperty("os.name");
            if (val != null && val.indexOf("Sun") != -1) {
                isSunOS = true;
            }
            if ((val = AccessCheck.getProperty("bi.oracle.home")) != null && val.length() > 0) {
                isBIServer = true;
            }
            if ((val = AccessCheck.getProperty("java.vm.name")) != null && val.indexOf("JRockit") != -1) {
                isJRockit = true;
            }
            s_platformCanUseExternal = !isSunOS && !isBIServer && isJRockit;
        }
        catch (Throwable th) {
            s_platformCanUseExternal = false;
        }
        s_alreadyIdentifiedPlatform = true;
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        DiagnosticsConfiguration config;
        if (event instanceof DiagnosticsConfigurationChangedEvent && (config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration()) != null) {
            this.m_useExternal = config.useThreadDumpExternalCommands();
        }
    }

    static class ThreadSnapshot {
        long m_tid;
        ThreadInfo m_threadInfo;
        String m_ecid;
        String m_rid;
        Map<String, String> m_contextValues;
        long m_elapsed;

        ThreadSnapshot(long tid, ThreadInfo threadInfo, String ecid, String rid, Map<String, String> contextValues, long elapsed) {
            this.m_tid = tid;
            this.m_threadInfo = threadInfo;
            this.m_ecid = ecid;
            this.m_rid = rid;
            this.m_contextValues = contextValues;
            this.m_elapsed = elapsed;
        }
    }
}

