/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.dms.reporter.TbmlReporter;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.ColumnGroup;
import oracle.dms.table.ColumnGroupSupport;
import oracle.dms.table.Schema;
import oracle.dms.table.TableBaseSupport;
import oracle.dms.table.TableSupport;
import oracle.dms.util.NameSupport;

public class SchemaSupport
extends TableBaseSupport
implements Schema {
    private volatile String m_description = null;
    private Hashtable<String, ColumnDefinitionSupport> m_columnDefinitions = new Hashtable(8);
    private Hashtable<String, ColumnGroupSupport> m_columnGroups = new Hashtable(8);
    private Hashtable<String, String> m_variableDefinitions = new Hashtable(8);
    private Hashtable<String, String> m_properties = new Hashtable(8);
    private static final long serialVersionUID = -1150676615528L;

    public SchemaSupport(String description, TableSupport table) {
        super(table);
        table.setSchema(this);
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public int columnCount() {
        return this.m_columnDefinitions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnNames() {
        String[] ret = null;
        Hashtable<String, ColumnDefinitionSupport> hashtable = this.m_columnDefinitions;
        synchronized (hashtable) {
            ret = new String[this.m_columnDefinitions.size()];
            this.m_columnDefinitions.keySet().toArray(ret);
        }
        return ret;
    }

    @Override
    public boolean containsColumn(String column) {
        if (column == null || column.trim().length() == 0) {
            return false;
        }
        return this.m_columnDefinitions.containsKey(column);
    }

    @Override
    public ColumnDefinition getColumnDefinition(String column) {
        if (column == null || column.trim().length() == 0) {
            return null;
        }
        return this.m_columnDefinitions.get(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColumnDefinition[] getColumnDefinitions() {
        ColumnDefinition[] columnDefinitions;
        Hashtable<String, ColumnDefinitionSupport> hashtable = this.m_columnDefinitions;
        synchronized (hashtable) {
            columnDefinitions = new ColumnDefinitionSupport[this.m_columnDefinitions.size()];
            this.m_columnDefinitions.values().toArray(columnDefinitions);
        }
        return columnDefinitions;
    }

    @Override
    public Enumeration<? extends ColumnDefinition> enumerateColumnDefinitions(boolean sorted) {
        if (!sorted) {
            return this.m_columnDefinitions.elements();
        }
        Vector<ColumnDefinitionSupport> vec = new Vector<ColumnDefinitionSupport>(this.m_columnDefinitions.values());
        Collections.sort(vec);
        return vec.elements();
    }

    @Override
    public int columnGroupCount() {
        return this.m_columnGroups.size();
    }

    @Override
    public ColumnGroup getColumnGroup(String group) {
        if (group == null || group.trim().length() == 0) {
            return null;
        }
        return this.m_columnGroups.get(group);
    }

    @Override
    public boolean containsColumnGroup(String group) {
        if (group == null || group.trim().length() == 0) {
            return false;
        }
        return this.m_columnGroups.containsKey(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColumnGroup[] getColumnGroups() {
        ColumnGroup[] columnGroups;
        Hashtable<String, ColumnGroupSupport> hashtable = this.m_columnGroups;
        synchronized (hashtable) {
            columnGroups = new ColumnGroupSupport[this.m_columnGroups.size()];
            this.m_columnGroups.values().toArray(columnGroups);
        }
        return columnGroups;
    }

    @Override
    public Enumeration<? extends ColumnGroup> enumerateColumnGroups(boolean sorted) {
        return Collections.enumeration(this.m_columnGroups.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getColumnGroupNames() {
        String[] ret = null;
        Hashtable<String, ColumnGroupSupport> hashtable = this.m_columnGroups;
        synchronized (hashtable) {
            ret = new String[this.m_columnGroups.size()];
            this.m_columnGroups.keySet().toArray(ret);
        }
        return ret;
    }

    public int variableCount() {
        return this.m_variableDefinitions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVariableNames() {
        String[] ret;
        Hashtable<String, String> hashtable = this.m_variableDefinitions;
        synchronized (hashtable) {
            ret = new String[this.m_variableDefinitions.size()];
            this.m_variableDefinitions.keySet().toArray(ret);
        }
        return ret;
    }

    public String getVariableDescription(String variableName) {
        if (variableName == null || variableName.trim().length() == 0) {
            return null;
        }
        return this.m_variableDefinitions.get(variableName);
    }

    public void addProperty(String key, String value) {
        if (key == null || key.trim().length() == 0 || value == null) {
            return;
        }
        this.m_properties.put(key, value);
    }

    public String getProperty(String key) {
        if (key == null || key.trim().length() == 0) {
            return null;
        }
        return this.m_properties.get(key);
    }

    public void addProperties(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public String toString() {
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter out = new PrintWriter(buf);
        this.printTbml(true, out);
        out.close();
        return buf.toString();
    }

    public void addColumnDefinition(ColumnDefinitionSupport desc) {
        if (desc == null) {
            return;
        }
        String name = desc.getName();
        this.m_columnDefinitions.put(name, desc);
    }

    public void addColumnGroup(ColumnGroupSupport group) {
        if (group == null) {
            return;
        }
        this.m_columnGroups.put(group.getName(), group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariableDescription(String name, String description) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        if (description == null || description.trim().length() == 0) {
            description = "";
        }
        Hashtable<String, String> hashtable = this.m_variableDefinitions;
        synchronized (hashtable) {
            if (!this.m_variableDefinitions.containsKey(name) || description.length() > 0) {
                this.m_variableDefinitions.put(name, description);
            }
        }
    }

    public SchemaSupport clone(boolean includeDescriptions) {
        SchemaSupport clone = null;
        try {
            clone = (SchemaSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.m_columnDefinitions = (Hashtable)this.m_columnDefinitions.clone();
        for (Map.Entry<String, ColumnDefinitionSupport> entry : clone.m_columnDefinitions.entrySet()) {
            ColumnDefinitionSupport cdef = entry.getValue();
            ColumnDefinitionSupport newdef = cdef.clone(clone, includeDescriptions);
            entry.setValue(newdef);
        }
        clone.m_columnGroups = (Hashtable)this.m_columnGroups.clone();
        for (Map.Entry<String, NameSupport> entry : clone.m_columnGroups.entrySet()) {
            ColumnGroupSupport group = (ColumnGroupSupport)entry.getValue();
            ColumnGroupSupport newGroup = group.clone(includeDescriptions);
            entry.setValue(newGroup);
        }
        clone.m_variableDefinitions = (Hashtable)this.m_variableDefinitions.clone();
        clone.m_properties = (Hashtable)this.m_properties.clone();
        if (!includeDescriptions) {
            clone.m_description = null;
        }
        return clone;
    }

    public SchemaSupport clone(TableSupport table, boolean includeDescriptions) {
        SchemaSupport clone = this.clone(includeDescriptions);
        if (table != null) {
            clone.m_table = table;
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(SchemaSupport schema, boolean updateDescriptions) {
        String name;
        if (schema == null) {
            return false;
        }
        boolean ret = false;
        if (updateDescriptions) {
            this.m_description = schema.m_description;
        }
        ret |= this._updateColumnDefinition(schema.m_columnDefinitions, updateDescriptions);
        schema.m_columnDefinitions.clear();
        Hashtable<String, Object> hashtable = this.m_variableDefinitions;
        synchronized (hashtable) {
            for (Map.Entry<String, String> entry : schema.m_variableDefinitions.entrySet()) {
                name = entry.getKey();
                String description = entry.getValue();
                this.addVariableDescription(name, description);
            }
        }
        this.m_properties.putAll(schema.m_properties);
        hashtable = this.m_columnGroups;
        synchronized (hashtable) {
            for (Map.Entry<String, Object> entry : this.m_columnGroups.entrySet()) {
                name = entry.getKey();
                ColumnGroupSupport group = (ColumnGroupSupport)entry.getValue();
                ColumnGroupSupport another = schema.m_columnGroups.remove(name);
                if (another == null) continue;
                ret |= group.update(another, updateDescriptions);
            }
            if (schema.m_columnGroups.size() > 0) {
                if (!updateDescriptions) {
                    for (ColumnGroupSupport columnGroupSupport : schema.m_columnGroups.values()) {
                        columnGroupSupport.setDescription(null);
                    }
                }
                this.m_columnGroups.putAll(schema.m_columnGroups);
                schema.m_columnGroups.clear();
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _updateColumnDefinition(Map<String, ColumnDefinitionSupport> source, boolean updateDescriptions) {
        boolean ret = false;
        for (Map.Entry<String, ColumnDefinitionSupport> entry : source.entrySet()) {
            String column = entry.getKey();
            ColumnDefinitionSupport sourceColumnDef = entry.getValue();
            Hashtable<String, ColumnDefinitionSupport> hashtable = this.m_columnDefinitions;
            synchronized (hashtable) {
                if (!this.m_columnDefinitions.containsKey(column)) {
                    if (!updateDescriptions) {
                        sourceColumnDef.setDescription(null);
                    }
                    this.m_columnDefinitions.put(column, sourceColumnDef);
                    ret = true;
                } else {
                    ColumnDefinitionSupport destColumnDef = this.m_columnDefinitions.get(column);
                    if (!destColumnDef.hasUnit()) {
                        String unit = sourceColumnDef.getUnit();
                        destColumnDef.setUnit(unit);
                        ret = true;
                    }
                    if (updateDescriptions && !destColumnDef.hasDescription()) {
                        String description = sourceColumnDef.getDescription();
                        destColumnDef.setDescription(description);
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }

    protected void close() {
        this.m_columnDefinitions.clear();
        Hashtable columnGroups = (Hashtable)this.m_columnGroups.clone();
        this.m_columnGroups.clear();
        this.m_variableDefinitions.clear();
        this.m_properties.clear();
        for (ColumnGroupSupport group : columnGroups.values()) {
            group.close();
        }
        columnGroups.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printTbml(boolean verbose, PrintWriter out) {
        String name;
        Hashtable<String, Object> hashtable;
        if (verbose) {
            hashtable = this.m_columnGroups;
            synchronized (hashtable) {
                for (ColumnGroupSupport columnGroupSupport : this.m_columnGroups.values()) {
                    columnGroupSupport.printTbml(out);
                }
            }
        }
        hashtable = this.m_columnDefinitions;
        synchronized (hashtable) {
            for (ColumnDefinitionSupport columnDefinitionSupport : this.m_columnDefinitions.values()) {
                columnDefinitionSupport.printTbml(out);
            }
        }
        hashtable = this.m_variableDefinitions;
        synchronized (hashtable) {
            for (Map.Entry entry : this.m_variableDefinitions.entrySet()) {
                name = (String)entry.getKey();
                String description = (String)entry.getValue();
                TbmlReporter.printVariableName(name, description, out);
            }
        }
        hashtable = this.m_properties;
        synchronized (hashtable) {
            for (Map.Entry entry : this.m_properties.entrySet()) {
                name = (String)entry.getKey();
                String value = (String)entry.getValue();
                TbmlReporter.printProperty(name, value, out);
            }
        }
    }
}

