/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dms.ParameterDescriptor;
import oracle.dms.util.ObjectUtils;

public abstract class AbstractParameterDescriptor
implements ParameterDescriptor {
    private final int mHashCode;
    private final String mName;
    private volatile Set<WeakReference<Class<? extends ResourceBundle>>> mResourceBundleClassRefSet;
    private final ReentrantReadWriteLock mResourceBundleClassRefSetLock;
    private final String mResourceBundleClassName;
    private final String mResourceKeyPrefix;
    private final Set<String> mValueSet;
    private final int mValueSetSize;
    private String mAsString;
    private Set<String> mFailedTranslationKeys;
    private static String RESOURCE_PROPERTIES_FILE_NAME = "oracle.dms.util.dms";

    protected AbstractParameterDescriptor(String name, Class<? extends ResourceBundle> resourceBundleClass, String resourceKeyPrefix, Set<String> valueSet, int valueSetSize) {
        this.mName = name;
        if (resourceBundleClass == null) {
            this.mResourceBundleClassRefSetLock = null;
            this.mResourceBundleClassRefSet = null;
            this.mResourceBundleClassName = null;
        } else {
            this.mResourceBundleClassRefSetLock = new ReentrantReadWriteLock();
            this.mResourceBundleClassRefSet = new HashSet<WeakReference<Class<? extends ResourceBundle>>>();
            this.mResourceBundleClassRefSet.add(new WeakReference<Class<? extends ResourceBundle>>(resourceBundleClass));
            this.mResourceBundleClassName = resourceBundleClass.getName();
        }
        this.mResourceKeyPrefix = resourceKeyPrefix == null ? "" : resourceKeyPrefix;
        if (valueSet != null && valueSet.size() > 0) {
            HashSet<String> tmpSet = new HashSet<String>();
            tmpSet.addAll(valueSet);
            this.mValueSet = Collections.unmodifiableSet(tmpSet);
        } else {
            this.mValueSet = null;
        }
        this.mValueSetSize = this.mValueSet == null ? valueSetSize : this.mValueSet.size();
        int hashCode = (this.mName == null ? 0 : this.mName.hashCode()) ^ (this.mResourceBundleClassName == null ? 0 : this.mResourceBundleClassName.hashCode()) ^ (this.mResourceKeyPrefix == null ? 0 : this.mResourceKeyPrefix.hashCode());
        if (this.mValueSet != null) {
            for (String value : this.mValueSet) {
                hashCode ^= value.hashCode();
            }
        }
        this.mHashCode = hashCode;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getLabel(Locale locale) {
        String retVal = null;
        String key = this.mResourceKeyPrefix + this.getName() + "_label";
        retVal = this.getTranslation(key, locale);
        if (retVal == null) {
            retVal = this.mName;
        }
        return retVal;
    }

    @Override
    public String getDescription(Locale locale) {
        String retVal = null;
        String key = this.mResourceKeyPrefix + this.getName() + "_description";
        retVal = this.getTranslation(key, locale);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTranslation(String key, Locale locale) {
        String METHOD_NAME = "getTranslation";
        String retVal = null;
        if (this.mResourceBundleClassRefSet != null) {
            this.mResourceBundleClassRefSetLock.readLock().lock();
            try {
                for (WeakReference<Class<? extends ResourceBundle>> wRef : this.mResourceBundleClassRefSet) {
                    Class resourceBundleClass = (Class)wRef.get();
                    if (resourceBundleClass != null) {
                        try {
                            ClassLoader cl = resourceBundleClass.getClassLoader();
                            ResourceBundle rb = ResourceBundle.getBundle(resourceBundleClass.getName(), locale, cl);
                            retVal = rb.getString(key);
                        }
                        catch (Exception e) {
                            Logger logger = this.getLogger();
                            logger.log(Level.FINEST, "Hit a problem trying to fetch translation for parameter descriptor: " + this.mName + ", key: " + key + " locale: " + locale + " using resourceBundleClass " + resourceBundleClass, e);
                        }
                    }
                    if (retVal == null) continue;
                    break;
                }
            }
            finally {
                this.mResourceBundleClassRefSetLock.readLock().unlock();
            }
            if (retVal == null) {
                AbstractParameterDescriptor abstractParameterDescriptor = this;
                synchronized (abstractParameterDescriptor) {
                    if (this.mFailedTranslationKeys == null) {
                        this.mFailedTranslationKeys = new HashSet<String>();
                    }
                    if (!this.mFailedTranslationKeys.contains(key)) {
                        this.mFailedTranslationKeys.add(key);
                        Logger logger = this.getLogger();
                        LogRecord lr = new LogRecord(Level.WARNING, "DMS-50761");
                        lr.setSourceClassName(this.getClass().getName());
                        lr.setSourceMethodName("getTranslation");
                        lr.setParameters(new Object[]{key, locale, this.getName()});
                        lr.setResourceBundle(ResourceBundle.getBundle(RESOURCE_PROPERTIES_FILE_NAME));
                        logger.log(lr);
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public Set<String> getValueSet() {
        return this.mValueSet;
    }

    @Override
    public int getValueSetSize() {
        return this.mValueSetSize;
    }

    @Override
    public String getValueDescription(String value, Locale locale) {
        String retVal = null;
        if (value != null) {
            String key = this.mResourceKeyPrefix + this.getName() + "_value_" + value + "_description";
            retVal = this.getTranslation(key, locale);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceBundleClass(Class<? extends ResourceBundle> resBundleClass) {
        String resBundleClassName;
        String string = resBundleClassName = resBundleClass == null ? null : resBundleClass.getName();
        if (this.mResourceBundleClassName != null) {
            if (!this.mResourceBundleClassName.equals(resBundleClassName)) {
                throw new IllegalArgumentException("Conflicting resource bundle classes: trying to add " + resBundleClassName + " to instance with bundle name set to " + this.mResourceBundleClassName);
            }
            this.mResourceBundleClassRefSetLock.writeLock().lock();
            try {
                HashSet<WeakReference<Class<? extends ResourceBundle>>> replacementSet = new HashSet<WeakReference<Class<? extends ResourceBundle>>>(this.mResourceBundleClassRefSet.size() + 1);
                boolean presentInSet = false;
                for (WeakReference<Class<? extends ResourceBundle>> wr : this.mResourceBundleClassRefSet) {
                    if (wr.get() == null) continue;
                    replacementSet.add(wr);
                    if (wr.get() != resBundleClass) continue;
                    presentInSet = true;
                }
                if (!presentInSet) {
                    replacementSet.add(new WeakReference<Class<? extends ResourceBundle>>(resBundleClass));
                }
                this.mResourceBundleClassRefSet = replacementSet;
            }
            finally {
                this.mResourceBundleClassRefSetLock.writeLock().unlock();
            }
        } else if (resBundleClass != null) {
            throw new IllegalArgumentException("Conflicting resource bundle classes: trying to add " + resBundleClassName + " to instance with no resource bundle name.");
        }
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object o) {
        boolean retVal = false;
        if (o != null && o instanceof AbstractParameterDescriptor && this.hashCode() == o.hashCode()) {
            AbstractParameterDescriptor that = (AbstractParameterDescriptor)o;
            retVal = ObjectUtils.areEqual(this.mName, that.mName) && ObjectUtils.areEqual(this.mResourceBundleClassName, that.mResourceBundleClassName) && ObjectUtils.areEqual(this.mResourceKeyPrefix, that.mResourceKeyPrefix) && ObjectUtils.areEqual(this.mValueSet, that.mValueSet);
        }
        return retVal;
    }

    public String toString() {
        if (this.mAsString == null) {
            this.mAsString = super.toString() + ":[name:" + this.mName + "]";
        }
        return this.mAsString;
    }

    protected abstract Logger getLogger();
}

