/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.weblogic;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.impl.common.SecurityContext;
import oracle.security.jps.internal.api.runtime.SubjectSecurity;
import weblogic.security.Security;
import weblogic.security.SubjectUtils;

class SecurityContextImpl
implements SecurityContext {
    private SubjectSecurity m_jpsSecurity = SubjectSecurity.getInstance();
    private Logger m_logger = LoggerFactory.getFrameworkLogger();

    SecurityContextImpl() throws Exception {
    }

    @Override
    public String getUserName() {
        try {
            return SubjectUtils.getUsername((Subject)this.getCurrentSubject());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Subject getCurrentSubject() {
        Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(AccessController.getContext());
            }
        });
        if (subject == null) {
            subject = Security.getCurrentSubject();
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.finer("unable to get Subject using JAAS API; using WebLogic Server security got: " + subject);
            }
        } else if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("using the JAAS API got Subject: " + subject);
        }
        return subject;
    }

    @Override
    public <T> T executeAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return (T)this.m_jpsSecurity.executeAs(subject, action);
    }
}

