/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.reporter.MetricTableReporter;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnGroup;
import oracle.dms.table.Schema;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.QueryOptions;

public class MetricHelpReporter
extends MetricTableReporter {
    public MetricHelpReporter(TableSource tableSource, Request request) {
        super(tableSource, request);
    }

    @Override
    protected void setQueryOptions() {
        super.setQueryOptions();
        this.m_options.setQueryType(QueryOptions.QueryType.SCHEMA);
        this.m_options.setUseCache(QueryOptions.UseCache.CACHE_COPY);
    }

    @Override
    protected void printHeading(PrintWriter out) {
        String title = DMSNLSupport.getString("TV_METRICS_HELP", "DMS Metrics Help");
        out.print("<html><head><title>");
        out.print(title);
        out.println("</title>");
        MetricHelpReporter.printStyleSheet(out);
        out.println("</head><body>");
    }

    @Override
    protected void printEnding(PrintWriter out) {
        out.println("<hr>");
        out.print(new Date());
        out.println("</body></html>");
    }

    @Override
    protected void printTable(Table table, PrintWriter out) {
        String name = table.getName();
        MetricHelpReporter.printBanner("<a" + MetricHelpReporter.getTableSort(name, DMSUtil.urlXssEscape(this.m_request.getRequestURI())) + '>' + DMSUtil.xssEscape(name) + "</a>", this.m_request, out);
        MetricHelpReporter.printTableStart(1, 1, out, 100);
        out.print("<tr>");
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("OSO_NAME", "Names"), 1, out);
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("OSO_DESCRIPTION", "Descriptions"), 1, out);
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("TV_DERIVS", "Derivatives"), 1, out);
        MetricHelpReporter.printHeaderCellGrey(DMSNLSupport.getString("OSO_UNITS", "Units"), 1, out);
        out.print("</tr>");
        Schema schema = table.getSchema();
        if (schema != null) {
            boolean lightBG = false;
            if (schema.containsColumn("Name")) {
                this._printHelpRow("Name", DMSNLSupport.getString("QU_Name", "Name of metric instance"), "&nbsp;", lightBG, out);
                boolean bl = lightBG = !lightBG;
            }
            if (schema.containsColumn("Host")) {
                this._printHelpRow("Host", DMSNLSupport.getString("QU_Host", "Host where metrics come"), "&nbsp;", lightBG, out);
                boolean bl = lightBG = !lightBG;
            }
            if (schema.containsColumn("Process")) {
                this._printHelpRow("Process", DMSNLSupport.getString("QU_Process", "Process where metrics come"), "&nbsp;", lightBG, out);
                lightBG = !lightBG;
            }
            String[] sensors = schema.getColumnGroupNames();
            String[][] metrics = null;
            if (sensors != null) {
                metrics = new String[sensors.length][];
            }
            String[] properties = MetricHelpReporter.getTableHeader(schema, sensors, metrics);
            this._printHelpRows(schema, sensors, metrics, properties, lightBG, out);
        }
        out.println("</table><p>");
    }

    private void _printHelpRows(Schema schema, String[] sensors, String[][] metrics, String[] properties, boolean lightBG, PrintWriter out) {
        int i;
        if (sensors != null) {
            for (i = 0; i < sensors.length; ++i) {
                int size;
                if (sensors[i] == null || metrics[i] == null || (size = metrics[i].length) == 0) continue;
                ColumnGroup group = schema.getColumnGroup(sensors[i]);
                String groupDesc = null;
                if (group != null) {
                    groupDesc = group.getDescription();
                }
                MetricHelpReporter.printRowStart(lightBG, out);
                MetricHelpReporter.printDataCell(sensors[i], size, true, out);
                if (groupDesc != null && groupDesc.trim().length() > 0) {
                    MetricHelpReporter.printDataCell(groupDesc, size, false, out);
                }
                for (int j = 0; j < metrics[i].length; ++j) {
                    ColumnDefinition mdesc = schema.getColumnDefinition(metrics[i][j]);
                    String description = null;
                    String unit = null;
                    if (mdesc != null) {
                        description = mdesc.getDescription();
                        unit = mdesc.getUnit();
                    }
                    if (j > 0) {
                        MetricHelpReporter.printRowStart(lightBG, out);
                    }
                    if (groupDesc == null || groupDesc.trim().length() == 0) {
                        if (description == null || description.trim().length() == 0) {
                            description = "&nbsp;";
                        }
                        MetricHelpReporter.printDataCell(description, 1, false, out);
                    }
                    String extension = metrics[i][j];
                    int index = metrics[i][j].indexOf(sensors[i]);
                    if (index >= 0 && index < metrics[i][j].length() - sensors[i].length()) {
                        extension = metrics[i][j].substring(index + sensors[i].length());
                    }
                    if (extension.startsWith(".")) {
                        extension = extension.substring(1);
                    }
                    MetricHelpReporter.printDataCell(extension, 1, false, out);
                    if (unit == null || unit.trim().length() == 0) {
                        unit = "&nbsp;";
                    }
                    MetricHelpReporter.printDataCell(unit, 1, false, out);
                    out.print("</tr>");
                }
                lightBG = !lightBG;
            }
        }
        for (i = 0; i < properties.length; ++i) {
            if (properties[i] == null) continue;
            ColumnDefinition mdesc = schema.getColumnDefinition(properties[i]);
            String description = null;
            String unit = null;
            if (mdesc != null) {
                description = mdesc.getDescription();
                unit = mdesc.getUnit();
            }
            this._printHelpRow(properties[i], description, unit, lightBG, out);
            lightBG = !lightBG;
        }
    }

    private void _printHelpRow(String name, String description, String unit, boolean lightBG, PrintWriter out) {
        if (name == null || name.trim().length() == 0) {
            name = "&nbsp;";
        }
        if (unit == null || unit.trim().length() == 0) {
            unit = "&nbsp;";
        }
        MetricHelpReporter.printRowStart(lightBG, out);
        MetricHelpReporter.printDataCell(name, 1, true, out);
        MetricHelpReporter.printDataCell(description, 1, false, out);
        MetricHelpReporter.printDataCell("&nbsp;", 1, false, out);
        MetricHelpReporter.printDataCell(unit, 1, false, out);
        out.print("</tr>");
    }
}

