/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.streaming;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import oracle.as.management.streaming.StreamingMBean;

public class MBeanOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 10000;
    private byte[] m_buffer;
    private int m_end;
    private StreamingMBean m_stream;
    private String m_handle;
    private boolean m_closed = false;

    public MBeanOutputStream(String handle, Object mBeanProxy) throws IOException {
        this(handle, mBeanProxy, 0);
    }

    public MBeanOutputStream(String handle, MBeanServerConnection conn, ObjectName name, int bufSz) throws IOException {
        this(handle, MBeanServerInvocationHandler.newProxyInstance(conn, name, StreamingMBean.class, false), bufSz);
    }

    public MBeanOutputStream(String handle, Object mBeanProxy, int bufSz) throws IOException {
        if (bufSz < 1) {
            bufSz = 10000;
        }
        this.m_buffer = new byte[bufSz];
        if (mBeanProxy instanceof StreamingMBean) {
            this.m_stream = (StreamingMBean)mBeanProxy;
        } else if (Proxy.isProxyClass(mBeanProxy.getClass())) {
            this.m_stream = (StreamingMBean)Proxy.newProxyInstance(StreamingMBean.class.getClassLoader(), new Class[]{StreamingMBean.class}, Proxy.getInvocationHandler(mBeanProxy));
        } else {
            throw new IOException("Cannot stream the data from " + mBeanProxy + ": must be a StreamingMBean");
        }
        this.m_handle = handle;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        byte[] a = new byte[]{(byte)b};
        this.write(a);
    }

    @Override
    public synchronized void write(byte[] w) throws IOException {
        this.write(w, 0, w.length);
    }

    @Override
    public synchronized void write(byte[] w, int off, int len) throws IOException {
        int toBuffer;
        if (len == 0 || w == null) {
            return;
        }
        if ((len -= (toBuffer = (this.m_end + len) % this.m_buffer.length)) > 0) {
            this._write(w, off, len);
            off += len;
        }
        System.arraycopy(w, off, this.m_buffer, this.m_end, toBuffer - this.m_end);
        this.m_end = toBuffer;
    }

    private void _write(byte[] w, int off, int len) throws IOException {
        if (off + len > w.length) {
            throw new IOException("Could not write: array of bytes shorter than requested");
        }
        byte[] b = new byte[this.m_end + len];
        System.arraycopy(this.m_buffer, 0, b, 0, this.m_end);
        System.arraycopy(w, off, b, this.m_end, len);
        try {
            this.m_stream.streamingOperation(this.m_handle, 1, b);
            this.m_end = 0;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable th) {
            while (th.getCause() != null && th instanceof UndeclaredThrowableException) {
                th = th.getCause();
            }
            IOException e = new IOException("Could not write: " + th.getMessage());
            e.initCause(th);
            throw e;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this._write(this.m_buffer, 0, 0);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (!this.m_closed) {
                this.flush();
                this.m_stream.streamingOperation(this.m_handle, 2, null);
                this.m_closed = true;
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable th) {
            while (th.getCause() != null && th instanceof UndeclaredThrowableException) {
                th = th.getCause();
            }
            IOException e = new IOException("Could not close the stream: " + th.getMessage());
            e.initCause(th);
            throw e;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

