/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.producer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import oracle.dms.producer.ColumnInfo;

public class RowInfo {
    protected String m_tableName;
    protected ObjectName m_objectName;
    protected String[] m_attributeNames;
    private MBeanServerConnection m_mbeanServer;
    protected Map<String, ColumnInfo> m_columnInfoByNames = new ConcurrentHashMap<String, ColumnInfo>();

    protected RowInfo(String tableName, ObjectName objectName, String[] attributeNames, MBeanServerConnection mbeanServer) {
        if (objectName == null) {
            throw new IllegalArgumentException("tableName=" + tableName + " objectName=null");
        }
        if (attributeNames == null) {
            throw new IllegalArgumentException("tableName=" + tableName + " objectName=" + objectName + " attributeNames=null");
        }
        if (mbeanServer == null) {
            throw new IllegalArgumentException("tableName=" + tableName + " objectName=" + objectName + " mbeanServer=null");
        }
        this.m_tableName = tableName;
        this.m_objectName = objectName;
        this.m_attributeNames = attributeNames;
        this.m_mbeanServer = mbeanServer;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public ObjectName getObjectName() {
        return this.m_objectName;
    }

    public String[] getAttributeNames() {
        return this.m_attributeNames == null ? null : (String[])this.m_attributeNames.clone();
    }

    public MBeanServerConnection getMBeanServer() {
        return this.m_mbeanServer;
    }

    public void addColumnInfos(Map<String, ColumnInfo> columnInfos) {
        if (columnInfos != null) {
            this.m_columnInfoByNames.putAll(columnInfos);
        }
    }

    public Map<String, ColumnInfo> getColumnInfos() {
        return this.m_columnInfoByNames;
    }

    public ColumnInfo getColumnInfo(String columnName) {
        return this.m_columnInfoByNames.get(columnName);
    }
}

