/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.statistics;

import java.util.LinkedList;
import java.util.List;
import oracle.dms.statistics.DataPoint1D;

public class Statistics1D<N extends Number> {
    int mCount = 0;
    private N mTotalValue;
    private N mMinValue;
    private int mMinIndex;
    private N mMaxValue;
    private int mMaxIndex;
    private N mMaxAbsValue;
    private int mMaxAbsIndex;
    double mAverage;
    double mAveAbsDeviation;

    public static <N extends Number> Statistics1D<N> create(List<N> values) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Can not create Statistics1D without any values.");
        }
        return new Statistics1D<N>(values);
    }

    public static <N extends Number, T> Statistics1D<N> createFromDataPoints(List<DataPoint1D<N, T>> DataPoint1Ds) {
        if (DataPoint1Ds == null || DataPoint1Ds.size() == 0) {
            throw new IllegalArgumentException("Can not create Statistics1D without any values.");
        }
        LinkedList<N> values = new LinkedList<N>();
        for (DataPoint1D<N, T> dp : DataPoint1Ds) {
            values.add(dp.getValue());
        }
        return new Statistics1D(values);
    }

    public int getCount() {
        return this.mCount;
    }

    public double getAverage() {
        return this.mAverage;
    }

    public N getTotal() {
        return this.mTotalValue;
    }

    public N getMinValue() {
        return this.mMinValue;
    }

    public int getMinIndex() {
        return this.mMinIndex;
    }

    public N getMaxValue() {
        return this.mMaxValue;
    }

    public N getMaxAbsValue() {
        return this.mMaxAbsValue;
    }

    public int getMaxIndex() {
        return this.mMaxIndex;
    }

    public double getAveAbsDeviation() {
        return this.mAveAbsDeviation;
    }

    private Statistics1D(List<N> values) {
        this.mCount = values.size();
        this.mTotalValue = (Number)values.get(0);
        this.mMaxValue = (Number)values.get(0);
        this.mMaxIndex = 0;
        this.mMaxAbsValue = Statistics1D.abs((Number)values.get(0));
        this.mMaxAbsIndex = 0;
        this.mMinValue = (Number)values.get(0);
        this.mMinIndex = 0;
        for (int i = 1; i < values.size(); ++i) {
            Number value = (Number)values.get(i);
            if (Statistics1D.gt(value, this.mMaxValue)) {
                this.mMaxValue = value;
                this.mMaxIndex = i;
            }
            if (Statistics1D.gt(Statistics1D.abs(value), this.mMaxAbsValue)) {
                this.mMaxAbsValue = Statistics1D.abs(value);
                this.mMaxAbsIndex = i;
            }
            if (Statistics1D.lt(value, this.mMinValue)) {
                this.mMinValue = value;
                this.mMinIndex = i;
            }
            this.mTotalValue = Statistics1D.add(this.mTotalValue, (Number)values.get(i));
        }
        this.mAverage = ((Number)this.mTotalValue).doubleValue() / (double)this.mCount;
        double runningTotal_double = 0.0;
        for (Number l : values) {
            runningTotal_double += Math.abs(l.doubleValue() - this.mAverage);
        }
        this.mAveAbsDeviation = runningTotal_double / (double)this.mCount;
    }

    static <N extends Number> N add(N n1, N n2) {
        Number retVal = null;
        if (n1 instanceof Long) {
            retVal = new Long(n1.longValue() + n2.longValue());
        } else if (n1 instanceof Integer) {
            retVal = new Integer(n1.intValue() + n2.intValue());
        } else {
            if (n1 instanceof Byte) {
                throw new IllegalArgumentException("Don't know how to add to bytes to yield a byte.");
            }
            if (n1 instanceof Float) {
                retVal = new Float(n1.floatValue() + n2.floatValue());
            } else if (n1 instanceof Double) {
                retVal = new Double(n1.doubleValue() + n2.doubleValue());
            }
        }
        return (N)retVal;
    }

    static <N extends Number> boolean gt(N n1, N n2) {
        boolean retVal = true;
        if (n1 instanceof Long) {
            retVal = n1.longValue() > n2.longValue();
        } else if (n1 instanceof Integer) {
            retVal = n1.intValue() > n2.intValue();
        } else if (n1 instanceof Byte) {
            retVal = n1.byteValue() > n2.byteValue();
        } else if (n1 instanceof Float) {
            retVal = n1.floatValue() > n2.floatValue();
        } else if (n1 instanceof Double) {
            retVal = n1.doubleValue() > n2.doubleValue();
        }
        return retVal;
    }

    static <N extends Number> boolean lt(N n1, N n2) {
        return Statistics1D.gt(n2, n1);
    }

    static <N extends Number> N abs(N n) {
        Number retVal = null;
        if (n instanceof Long) {
            long abs = Math.abs(n.longValue());
            retVal = abs;
        } else if (n instanceof Integer) {
            int abs = Math.abs(n.intValue());
            retVal = abs;
        } else if (n instanceof Byte) {
            byte abs = (byte)Math.abs(n.byteValue());
            retVal = abs;
        } else if (n instanceof Float) {
            float abs = Math.abs(n.floatValue());
            retVal = Float.valueOf(abs);
        } else if (n instanceof Double) {
            double abs = Math.abs(n.doubleValue());
            retVal = abs;
        }
        return (N)retVal;
    }
}

