/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.internal;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import oracle.dms.instrument.internal.SensorCoreData;

public class EventSensorCoreData
implements SensorCoreData {
    private AtomicLong mLastUpdateTime = new AtomicLong();
    private AtomicInteger mNumberOfOccurrences = new AtomicInteger();
    private String mBaseString = super.toString();

    EventSensorCoreData() {
    }

    void occurred(long lastUpdateTime) {
        this.mLastUpdateTime.set(lastUpdateTime);
        this.mNumberOfOccurrences.incrementAndGet();
    }

    public String toString() {
        return this.mBaseString + ":[occurrences=" + this.mNumberOfOccurrences.get() + "]";
    }

    @Override
    public String toShortString() {
        return "occurrences=" + this.mNumberOfOccurrences.get();
    }

    @Override
    public Object[] getValues() {
        Object[] retVal = new Object[10];
        retVal[1] = this.mNumberOfOccurrences.get();
        return retVal;
    }

    @Override
    public void reset() {
        this.mLastUpdateTime.set(0L);
        this.mNumberOfOccurrences.set(0);
    }
}

