/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.IncidentFacts;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.EventResourceBundle;

public class HTTPRequestTracker {
    private static final int MAXCLEAN = 100;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static HTTPRequestTracker s_tracker = new HTTPRequestTracker();
    private static String s_lock = "";
    private HashMap<Integer, ArrayList<RequestInfo>> m_requestMap;
    private HashSet<String> m_excludedList;
    private long m_requestThresholdMilliseconds = 0L;
    private long m_generateIncidentMilliseconds = 0L;
    private long m_maxRequestsReport = 0L;
    private String[] m_incidentDumps;
    private int m_cleanInterval = 0;
    private boolean m_cleanMap = false;
    private boolean m_trackerActive = false;
    private DiagnosticsFramework m_dfw;
    private Timer m_timer;
    private SlowRequestChecker m_checker;
    private Logger m_logger = Logger.getLogger("oracle.dms.event", EventResourceBundle.class.getName());
    private static final String CLASS_NAME = HTTPRequestTracker.class.getName();

    public static HTTPRequestTracker getInstance() {
        return s_tracker;
    }

    public static HTTPRequestTracker activateInstance() {
        HTTPRequestTracker tracker = HTTPRequestTracker.getInstance();
        tracker.setActive();
        return tracker;
    }

    public boolean isActive() {
        return this.m_trackerActive;
    }

    public synchronized void addRequest(HttpServletRequest request, ExecutionContext ctx, long time) {
        int id = System.identityHashCode(request);
        ArrayList<RequestInfo> requests = this.m_requestMap.get(id);
        if (requests == null) {
            requests = new ArrayList();
            this.m_requestMap.put(id, requests);
        }
        RequestInfo info = new RequestInfo(ctx, new WeakReference<HttpServletRequest>(request), time);
        requests.add(info);
        ++this.m_cleanInterval;
        if (this.m_cleanMap || this.m_cleanInterval % 100 == 0) {
            ArrayList<Integer> cleanList = new ArrayList<Integer>();
            for (Integer chkId : this.m_requestMap.keySet()) {
                requests = this.m_requestMap.get(chkId);
                int len = requests.size();
                for (int i = 0; i < len; ++i) {
                    info = requests.get(i);
                    if (info.getRequest() == null) {
                        requests.remove(i);
                        --i;
                        --len;
                    }
                    if (!requests.isEmpty()) continue;
                    cleanList.add(chkId);
                }
            }
            for (Integer chkId : cleanList) {
                this.m_requestMap.remove(chkId);
            }
        }
    }

    public synchronized void updateRequest(HttpServletRequest request, ExecutionContext newCtx) {
        if (request == null) {
            return;
        }
        int id = System.identityHashCode(request);
        ArrayList<RequestInfo> requests = this.m_requestMap.get(id);
        if (requests == null) {
            return;
        }
        int len = requests.size();
        if (len == 1) {
            requests.get((int)0).ctx = newCtx;
            return;
        }
        for (int i = 0; i < len; ++i) {
            RequestInfo info = requests.get(i);
            HttpServletRequest sRequest = info.getRequest();
            if (sRequest == null) {
                requests.remove(info);
                --i;
                --len;
                continue;
            }
            if (request != sRequest) continue;
            info.ctx = newCtx;
            break;
        }
        if (requests.isEmpty()) {
            this.m_requestMap.remove(id);
        }
    }

    public synchronized void removeRequest(HttpServletRequest request, long time) {
        if (request == null) {
            return;
        }
        int id = System.identityHashCode(request);
        ArrayList<RequestInfo> requests = this.m_requestMap.get(id);
        if (requests == null) {
            return;
        }
        int len = requests.size();
        if (len == 1) {
            this.handleEndRequest(requests.get(0), time);
            this.m_requestMap.remove(id);
            return;
        }
        for (int i = 0; i < len; ++i) {
            RequestInfo info = requests.get(i);
            HttpServletRequest sRequest = info.getRequest();
            if (sRequest == null) {
                requests.remove(info);
                --i;
                --len;
                continue;
            }
            if (request != sRequest) continue;
            this.handleEndRequest(info, time);
            requests.remove(info);
            break;
        }
        if (requests.isEmpty()) {
            this.m_requestMap.remove(id);
        }
    }

    private void handleEndRequest(RequestInfo info, long endTime) {
        String METHOD_NAME = "handleEndRequest";
        if (this.m_requestThresholdMilliseconds > 0L && info != null && this.m_dfw != null && endTime - info.time > this.m_requestThresholdMilliseconds) {
            HttpServletRequest request = info.getRequest();
            if (request == null) {
                this.m_cleanMap = true;
                return;
            }
            String desc = this.getRequestDescription(request, info.ctx, false, info.time, endTime);
            if (this.m_checker != null) {
                this.m_checker.addSlowRequest(desc, false);
                return;
            }
            IncidentFacts facts = IncidentFacts.createSystemIncidentFacts(endTime, ErrorMessage.SystemErrorMessage.SLOW_HTTP_REQUEST_ERROR_MESSAGE.getErrorMessage(), request.getRequestURI(), null);
            facts.setDescription("The following request exceeded the configured slow request threshold of " + this.m_requestThresholdMilliseconds / 1000L + " seconds:\n\n" + desc);
            if (this.m_incidentDumps != null) {
                facts.setEvaluateDiagnosticRules(false);
                for (String dump : this.m_incidentDumps) {
                    facts.addNamedDiagnosticDump(dump, null, null);
                }
            }
            try {
                this.m_dfw.getDDE().createIncident(facts, false);
            }
            catch (Exception e) {
                LogRecord logRecord = new LogRecord(Level.WARNING, "DMS-60001");
                logRecord.setSourceClassName(CLASS_NAME);
                logRecord.setSourceMethodName("handleEndRequest");
                logRecord.setThrown(e);
                logRecord.setParameters(new Object[]{desc});
                this.m_logger.log(logRecord);
            }
        }
    }

    public synchronized ArrayList<String> getRequests() {
        ArrayList<String> list = new ArrayList<String>();
        for (ArrayList<RequestInfo> requests : this.m_requestMap.values()) {
            for (RequestInfo info : requests) {
                HttpServletRequest request = info.getRequest();
                if (request == null) {
                    this.m_cleanMap = true;
                    continue;
                }
                list.add(this.getRequestDescription(request, info.ctx, true, info.time, 0L));
            }
        }
        return list;
    }

    public synchronized String getRequest(String ecid) {
        if (ecid == null) {
            return null;
        }
        for (ArrayList<RequestInfo> requests : this.m_requestMap.values()) {
            for (RequestInfo info : requests) {
                if (info.ctx == null || info.ctx.getECID() == null || info.ctx.getECID().compareTo(ecid) != 0) continue;
                HttpServletRequest request = info.getRequest();
                if (request == null) {
                    this.m_cleanMap = true;
                    return null;
                }
                return this.getRequestDescription(request, info.ctx, true, info.time, 0L);
            }
        }
        return null;
    }

    private String getRequestDescription(HttpServletRequest request, ExecutionContext ctx, boolean includeHeaders, long startTime, long endTime) {
        if (request == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String URI2 = request.getRequestURI();
        Enumeration headerNames = request.getHeaderNames();
        if (URI2 == null && !headerNames.hasMoreElements()) {
            return null;
        }
        buf.append("StartTime: ");
        buf.append(dateFormat.format(new Date(startTime)));
        buf.append("\n");
        if (endTime > 0L) {
            buf.append("EndTime: ");
            buf.append(dateFormat.format(new Date(endTime)));
            buf.append("\n");
        }
        buf.append("ECID: ");
        if (ctx != null) {
            buf.append(ctx.getIDasString());
            buf.append("\n");
            buf.append("Context Values:");
            buf.append("\n");
            Map<String, String> contextValues = ctx.getAllValues();
            if (contextValues != null) {
                for (Map.Entry<String, String> nameValue : contextValues.entrySet()) {
                    buf.append("   ");
                    buf.append(nameValue.getKey());
                    buf.append(": ");
                    buf.append(nameValue.getValue());
                    buf.append("\n");
                }
            }
        }
        buf.append("\n");
        buf.append("URI: ");
        buf.append(URI2);
        buf.append("\n");
        buf.append("RequestType: ");
        buf.append(request.getMethod());
        buf.append("\n");
        buf.append("QueryString: ");
        buf.append(request.getQueryString());
        if (includeHeaders) {
            buf.append("\n");
            buf.append("Headers:");
            buf.append("\n");
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (this.m_excludedList.contains(headerName) || headerName.compareToIgnoreCase("Cookie") == 0) continue;
                buf.append("   ");
                buf.append(headerName);
                buf.append(": ");
                Enumeration headers = request.getHeaders(headerName);
                while (headers.hasMoreElements()) {
                    buf.append((String)headers.nextElement());
                    buf.append("\n");
                    if (!headers.hasMoreElements()) continue;
                    buf.append("   ");
                }
            }
        }
        buf.append("\n");
        return buf.toString();
    }

    void setExcludeHeaderNames(String headerNames) {
        if (headerNames != null) {
            StringTokenizer tok = new StringTokenizer(headerNames, ",");
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                this.m_excludedList.add(name.trim());
            }
        }
    }

    public void setRequestThresholdSeconds(long threshold) {
        if (threshold > 0L) {
            this.m_requestThresholdMilliseconds = threshold * 1000L;
        }
    }

    public void setIncidentDumps(String incidentDumps) {
        if (incidentDumps != null) {
            this.m_incidentDumps = incidentDumps.split(",");
        }
    }

    public void setGenerateIncidentMinutes(long minutes) {
        if (minutes > 0L) {
            this.m_generateIncidentMilliseconds = minutes * 60L * 1000L;
        }
    }

    public void setMaxRequestsReport(long maxRequestsReport) {
        this.m_maxRequestsReport = maxRequestsReport;
    }

    void setActive() {
        String METHOD_NAME = "setActive";
        this.m_trackerActive = true;
        if (this.m_requestThresholdMilliseconds > 0L) {
            try {
                this.m_dfw = new DiagnosticsFramework();
            }
            catch (Exception e) {
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "setActive", "DMS-60003");
            }
            if (this.m_generateIncidentMilliseconds > 0L) {
                this.m_checker = new SlowRequestChecker();
                this.m_timer = new Timer(this.getClass().getName() + " - Slow Request Tracker", true);
                this.m_timer.scheduleAtFixedRate((TimerTask)this.m_checker, this.m_generateIncidentMilliseconds, this.m_generateIncidentMilliseconds);
            }
        }
    }

    void resetTracker() {
        this.m_requestMap.clear();
        this.m_excludedList.clear();
        this.m_requestThresholdMilliseconds = 0L;
        this.m_generateIncidentMilliseconds = 0L;
        this.m_maxRequestsReport = 0L;
        this.m_incidentDumps = null;
        this.m_dfw = null;
        this.m_cleanInterval = 0;
        this.m_cleanMap = false;
        this.m_trackerActive = false;
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
            this.m_checker = null;
        }
    }

    private HTTPRequestTracker() {
        this.m_requestMap = new HashMap();
        this.m_excludedList = new HashSet();
    }

    class SlowRequestChecker
    extends TimerTask {
        private LinkedList<String> m_slowRequests = new LinkedList();
        private long m_startTime = System.currentTimeMillis();
        private long m_requestCount = 0L;
        private String[] STRING_ARRAY = new String[0];
        private final String CLASS_NAME = SlowRequestChecker.class.getName();

        SlowRequestChecker() {
        }

        @Override
        public void run() {
            String METHOD_NAME = "run";
            long requestCount = this.m_requestCount;
            String[] slowRequests = this.addSlowRequest(null, true);
            long endTime = System.currentTimeMillis();
            long startTime = this.m_startTime;
            this.m_startTime = endTime;
            if (slowRequests != null && slowRequests.length > 0) {
                IncidentFacts facts = IncidentFacts.createSystemIncidentFacts(System.currentTimeMillis(), ErrorMessage.SystemErrorMessage.SLOW_HTTP_REQUEST_ERROR_MESSAGE.getErrorMessage(), "slow requests", null);
                facts.setSynchronous(false);
                String description = "Between " + new Date(startTime) + " and " + new Date(endTime) + " " + requestCount + " requests exceeded the configured threshold of " + HTTPRequestTracker.this.m_requestThresholdMilliseconds / 1000L + " seconds. Details of the " + "last " + slowRequests.length + " requests in this period are " + "reported below:\n\n";
                for (String reqInfo : slowRequests) {
                    description = description + reqInfo + "\n";
                }
                facts.setDescription(description);
                if (HTTPRequestTracker.this.m_incidentDumps != null) {
                    facts.setEvaluateDiagnosticRules(false);
                    for (String dump : HTTPRequestTracker.this.m_incidentDumps) {
                        facts.addNamedDiagnosticDump(dump, null, null);
                    }
                }
                try {
                    HTTPRequestTracker.this.m_dfw.getDDE().createIncident(facts, false);
                }
                catch (Exception e) {
                    HTTPRequestTracker.this.m_logger.logp(Level.WARNING, this.CLASS_NAME, "run", "DMS-60002", e);
                }
            }
        }

        synchronized String[] addSlowRequest(String request, boolean reset) {
            String[] requestDetails = null;
            if (!reset) {
                if (HTTPRequestTracker.this.m_maxRequestsReport > 0L && (long)this.m_slowRequests.size() >= HTTPRequestTracker.this.m_maxRequestsReport) {
                    this.m_slowRequests.remove();
                }
                this.m_slowRequests.add(request);
                ++this.m_requestCount;
            } else {
                requestDetails = this.m_slowRequests.toArray(this.STRING_ARRAY);
                this.m_slowRequests.clear();
                this.m_requestCount = 0L;
            }
            return requestDetails;
        }
    }

    class RequestInfo {
        WeakReference<HttpServletRequest> request;
        ExecutionContext ctx;
        long time;

        RequestInfo(ExecutionContext ctx, WeakReference<HttpServletRequest> request, long time) {
            this.ctx = ctx;
            this.time = time;
            this.request = request;
        }

        HttpServletRequest getRequest() {
            return (HttpServletRequest)this.request.get();
        }
    }
}

