/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dms.AbstractParameterDescriptor;
import oracle.dms.ReadableValueHolder;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.ContextParameterFactory;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.DMSCtxParamDescriptor;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.ContextParameterListener;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.util.DMSUtil;

public class ContextParameterFactoryImpl
implements ContextParameterFactory {
    private DomainContextManager mDomainContextManager;
    private Set<ContextParameterListener> mListeners = new CopyOnWriteArraySet<ContextParameterListener>();
    private static Set<String> sWhiteList = new HashSet<String>();
    private static Pattern sAcceptableButNotDesirableIdentifierPattern;

    ContextParameterFactoryImpl(DomainContextManager contextManager) {
        this.mDomainContextManager = contextManager;
    }

    @Override
    public ContextParameterDescriptorInternal createDescriptor(String name, Class<? extends ResourceBundle> resourceBundleClass, String resourceKeyPrefix, int maxValueLength, int ecidCardinality, boolean isUpdateable, ContextParameterDescriptor.Scope scope, Set<String> valueSet, int valueSetSize) {
        if (name == null) {
            throw new IllegalArgumentException("The parameter name can not be null");
        }
        if (!(DMSUtil.isLegalIdentifier(name) && name.indexOf(46) >= 0 || ContextParameterFactoryImpl.isAcceptableButNotDesirableIdentifier(name))) {
            throw new IllegalArgumentException("The proposed parameter name, " + name + ", does not conform to the context-parameter-naming guidelines: " + "names must contain only ASCII characters, " + "and, using the following standard java paradigm, must not " + "reside in the unnamed package");
        }
        if (DMSCtxParamDescriptor.findDescriptor(name) != null) {
            throw new IllegalArgumentException("The proposed name, " + name + ", is reserved and can not be used.");
        }
        if (maxValueLength > this.mDomainContextManager.getDefaultMaxParamValueLength()) {
            throw new IllegalArgumentException("The proposed maximum length for the values of parameter " + name + " is too large.");
        }
        if (valueSet != null) {
            if (valueSet.size() == 0) {
                throw new IllegalArgumentException("The size of the valueSet must be greater than zero.");
            }
            valueSetSize = valueSet.size();
        }
        CtxParamDescImpl retVal = null;
        CtxParamDescImpl newDesc = new CtxParamDescImpl(name, resourceBundleClass, resourceKeyPrefix, maxValueLength, ecidCardinality, isUpdateable, scope, valueSet, valueSetSize, null);
        CtxParamDescImpl oldDesc = (CtxParamDescImpl)this.mDomainContextManager.findContextParameterDescriptor(name);
        if (oldDesc == null) {
            this.mDomainContextManager.addContextParameterDescriptor(newDesc);
            retVal = newDesc;
            for (ContextParameterListener listener : this.mListeners) {
                listener.parameterDescriptorCreated(retVal);
            }
        } else if (oldDesc.equals(newDesc)) {
            oldDesc.addResourceBundleClass(resourceBundleClass);
            retVal = oldDesc;
        } else {
            throw new IllegalArgumentException("The proposed new paramaeter descriptor has the same name as an existing parameter descriptor, but the details of the descriptor differ.");
        }
        if (scope.isPropagatedViaWrap()) {
            this.mDomainContextManager.setParameterAttribute(name, DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
        }
        if (scope.isPropagatedToDB()) {
            this.mDomainContextManager.setParameterAttribute(name, DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
        }
        return retVal;
    }

    @Override
    public ContextParameterDescriptorInternal createDescriptor(String name, Class<? extends ResourceBundle> resourceBundleClass, String resourceKeyPrefix, int maxValueLength, int ecidCardinality, Set<String> valueSet, int valueSetSize, ReadableValueHolder<String> valueDelegate) {
        if (name == null) {
            throw new IllegalArgumentException("The parameter name can not be null");
        }
        if (!(sWhiteList.contains(name) || DMSUtil.isLegalIdentifier(name) && name.indexOf(46) >= 0)) {
            throw new IllegalArgumentException("The proposed parameter name, " + name + ", does not conform to the context-parameter-naming guidelines: " + "names must contain only ASCII characters, " + "and, using the following standard java paradigm, must not " + "reside in the unnamed package");
        }
        if (this.mDomainContextManager.findContextParameterDescriptor(name) != null) {
            throw new IllegalArgumentException("A ContextParameterDescriptor with name, " + name + ", has already been created.");
        }
        if (valueDelegate == null) {
            throw new IllegalArgumentException("Can not create a ContextParameterDescriptor using this method without passing a ReadableValueHolder.");
        }
        if (maxValueLength > this.mDomainContextManager.getDefaultMaxParamValueLength()) {
            throw new IllegalArgumentException("The proposed maximum length for the values of parameter " + name + " is too large.");
        }
        if (valueSet != null) {
            if (valueSet.size() == 0) {
                throw new IllegalArgumentException("The size of the valueSet must be greater than zero.");
            }
            valueSetSize = valueSet.size();
        }
        CtxParamDescImpl retVal = new CtxParamDescImpl(name, resourceBundleClass, resourceKeyPrefix, maxValueLength, ecidCardinality, false, ContextParameterDescriptor.Scope.SINGLE_CONTEXT_ONLY, valueSet, valueSetSize, new ValueHolderVeneer(valueDelegate));
        this.mDomainContextManager.addContextParameterDescriptor(retVal);
        return retVal;
    }

    public void registerListener(ContextParameterListener listener, boolean reportCurrentDescriptors) {
        this.mListeners.add(listener);
        if (reportCurrentDescriptors) {
            Set<ContextParameterDescriptorInternal> currentDescriptors = this.mDomainContextManager.getContextParameterDescriptors();
            for (ContextParameterDescriptorInternal di : currentDescriptors) {
                listener.parameterDescriptorCreated(di);
            }
        }
    }

    public void deregisterListener(ContextParameterListener listener) {
        this.mListeners.remove(listener);
    }

    private static boolean isAcceptableButNotDesirableIdentifier(String name) {
        Matcher m = sAcceptableButNotDesirableIdentifierPattern.matcher(name);
        boolean matches = m.matches();
        return matches;
    }

    static {
        sWhiteList.add("tenantId");
        sWhiteList.add("tenantName");
        sAcceptableButNotDesirableIdentifierPattern = Pattern.compile("[A-Z]{3,4}_[A-Za-z0-9]{4,}");
    }

    private class ValueHolderVeneer
    implements ContextParameterDescriptorInternal.DMSCtxValueHolder {
        ReadableValueHolder<String> mReadableValueHolder;

        ValueHolderVeneer(ReadableValueHolder<String> readableValueHolder) {
            this.mReadableValueHolder = readableValueHolder;
        }

        @Override
        public String getValue(DomainExecutionContext ctx) {
            String retVal = null;
            try {
                retVal = this.mReadableValueHolder.getValue();
            }
            catch (Exception e) {
                DMSContextManager.getLogger().log(Level.WARNING, "Failed to invoke getValue() without error.", e);
            }
            return retVal;
        }
    }

    private class CtxParamDescImpl
    extends AbstractParameterDescriptor
    implements ContextParameterDescriptorInternal {
        private final boolean mIsValid;
        private final int mMaxValueLength;
        private final int mEcidCardinality;
        private final boolean mIsUpdateable;
        private final ContextParameterDescriptor.Scope mScope;
        private final int mHashCode;
        private String mAsString;
        private ContextParameterDescriptorInternal.DMSCtxValueHolder mValueHolder;

        CtxParamDescImpl(String name, Class<? extends ResourceBundle> resourceBundleClass, String resourceKeyPrefix, int maxValueLength, int ecidCardinality, boolean isUpdateable, ContextParameterDescriptor.Scope scope, Set<String> valueSet, int valueSetSize, ContextParameterDescriptorInternal.DMSCtxValueHolder valueHolder) {
            super(name, resourceBundleClass, resourceKeyPrefix, valueSet, valueSetSize);
            this.mMaxValueLength = maxValueLength;
            this.mIsUpdateable = isUpdateable;
            this.mEcidCardinality = ecidCardinality;
            this.mScope = scope;
            this.mValueHolder = valueHolder;
            this.mHashCode = (super.hashCode() ^ this.mMaxValueLength ^ this.mEcidCardinality) * (this.mIsUpdateable ? 1 : -1);
            this.mIsValid = true;
        }

        @Override
        public int getMaxValueLength() {
            return this.mMaxValueLength;
        }

        @Override
        public boolean isUpdateable() {
            return this.mIsUpdateable;
        }

        @Override
        public int getECIDCardinality() {
            return this.mEcidCardinality;
        }

        @Override
        public ContextParameterDescriptor.Scope getScope() {
            return this.mScope;
        }

        @Override
        protected Logger getLogger() {
            return DMSContextManager.getLogger();
        }

        @Override
        public String toString() {
            if (this.mAsString == null) {
                this.mAsString = super.toString() + ":[maxLength:" + this.mMaxValueLength + ", mutable:" + this.mIsUpdateable + ", ecidCdnlty:" + this.mEcidCardinality + ", scope:" + (Object)((Object)this.mScope) + "]";
            }
            return this.mAsString;
        }

        @Override
        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof CtxParamDescImpl) {
                CtxParamDescImpl that = (CtxParamDescImpl)o;
                retVal = super.equals(that) && this.mScope == that.mScope && this.mEcidCardinality == that.mEcidCardinality && this.mIsUpdateable == that.mIsUpdateable && this.mMaxValueLength == that.mMaxValueLength;
            }
            return retVal;
        }

        @Override
        public int hashCode() {
            return this.mHashCode;
        }

        @Override
        public ContextParameterDescriptorInternal.DMSCtxValueHolder getValueHolder() {
            return this.mValueHolder;
        }

        @Override
        public boolean isValid() {
            return this.mIsValid;
        }
    }
}

