/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.RID;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.WeakReferenceWithKey;

public abstract class AbstractContextFamily<M extends DomainContextManager, C extends DomainExecutionContext> {
    public static final int ROOT = 0;
    protected M mDomainContextManager;
    protected String mECID;
    protected final Logger sLogger = DMSContextManager.getLogger();
    private HashMap<String, WeakReferenceWithKey<String, C>> m_ctxMap = new HashMap(4, 0.75f);
    private ReentrantReadWriteLock m_ctxMapRWLock = new ReentrantReadWriteLock();
    private ReferenceQueue<WeakReferenceWithKey<String, C>> m_ctxMapReferenceQueue = new ReferenceQueue();
    private ReentrantLock m_ctxMapRefQueueLock = new ReentrantLock();
    protected EnumMap<DomainContextManager.ParameterAttribute, Set<String>> mParamAttribute2ParamNameMap = new EnumMap(DomainContextManager.ParameterAttribute.class);
    private volatile Level mLogLevel = null;
    private AtomicInteger mPurgeDecimator = new AtomicInteger();

    protected AbstractContextFamily(M mgr, String ecid) {
        this.mDomainContextManager = mgr;
        if (ecid == null) {
            throw new IllegalArgumentException("Can not construct ContextFamily with null ecid value.");
        }
        this.mECID = ecid;
        if (this.sLogger.isLoggable(Level.FINER)) {
            this.sLogger.log(Level.FINER, "New ContextFamily created [{0}] - invoked with stack:\n{1}", new Object[]{this.mECID, ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
    }

    public String getECID() {
        return this.mECID;
    }

    public void setLogLevel(Level level) {
        if (this.mLogLevel == null && level != null) {
            this.mDomainContextManager.incrementLevels();
        }
        if (this.mLogLevel != null && level == null) {
            this.mDomainContextManager.decrementLevels();
        }
        this.mLogLevel = level;
    }

    public Level getLogLevel() {
        return this.mLogLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterAttribute(String parameterName, DomainContextManager.ParameterAttribute paramAttr) {
        if (parameterName == null) {
            return;
        }
        String internedParameterName = parameterName.intern();
        if (this.mDomainContextManager.getParameterNames(paramAttr).contains(internedParameterName)) {
            return;
        }
        Set<String> parameterNamesSet = this.mParamAttribute2ParamNameMap.get((Object)paramAttr);
        if (parameterNamesSet == null) {
            AbstractContextFamily abstractContextFamily = this;
            synchronized (abstractContextFamily) {
                parameterNamesSet = this.mParamAttribute2ParamNameMap.get((Object)paramAttr);
                if (parameterNamesSet == null) {
                    parameterNamesSet = new CopyOnWriteArraySet<String>();
                    this.mParamAttribute2ParamNameMap.put(paramAttr, parameterNamesSet);
                }
            }
        }
        parameterNamesSet.add(internedParameterName);
    }

    public Set<String> getParameterNames(DomainContextManager.ParameterAttribute paramAttr) {
        Set<String> retVal = this.mParamAttribute2ParamNameMap.get((Object)paramAttr);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, C> getContexts() {
        HashMap<String, DomainExecutionContext> map = new HashMap<String, DomainExecutionContext>();
        this.purgeCtxMap();
        this.lockCtxMapForRead();
        try {
            for (Map.Entry<String, WeakReferenceWithKey<String, C>> entry : this.m_ctxMap.entrySet()) {
                WeakReferenceWithKey<String, C> ctxRef = entry.getValue();
                DomainExecutionContext ctx = (DomainExecutionContext)ctxRef.get();
                if (ctx == null) continue;
                map.put(entry.getKey(), ctx);
            }
        }
        finally {
            this.unlockCtxMapForRead();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(DomainExecutionContext dctx) {
        String keyRID = dctx.getRID().toString();
        this.purgeCtxMap();
        this.lockCtxMapForWrite();
        try {
            WeakReferenceWithKey<String, DomainExecutionContext> prevCtx = this.m_ctxMap.put(keyRID, new WeakReferenceWithKey<String, DomainExecutionContext>(keyRID, dctx, this.m_ctxMapReferenceQueue));
            if (prevCtx != null && prevCtx.get() != null) {
                this.m_ctxMap.put(keyRID, prevCtx);
                throw new IllegalArgumentException("Context of the same RID, " + keyRID + " already present in this family, " + this.mECID + ".");
            }
        }
        finally {
            this.unlockCtxMapForWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(C ctx) {
        this.lockCtxMapForWrite();
        String keyRID = ctx.getRID().toString();
        try {
            this.m_ctxMap.remove(keyRID);
        }
        finally {
            this.unlockCtxMapForWrite();
        }
    }

    public C getExecutionContext(RID rid) {
        return this.getExecutionContext(rid.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getExecutionContext(String ridStr) {
        if (ridStr == null) {
            return null;
        }
        DomainExecutionContext ctx = null;
        this.lockCtxMapForRead();
        try {
            WeakReference ctxRef = this.m_ctxMap.get(ridStr);
            if (ctxRef != null) {
                ctx = (DomainExecutionContext)ctxRef.get();
            }
        }
        finally {
            this.unlockCtxMapForRead();
        }
        return (C)ctx;
    }

    private void lockCtxMapForWrite() {
        ReentrantReadWriteLock.WriteLock writeLock = this.m_ctxMapRWLock.writeLock();
        writeLock.lock();
    }

    private void unlockCtxMapForWrite() {
        ReentrantReadWriteLock.WriteLock writeLock = this.m_ctxMapRWLock.writeLock();
        writeLock.unlock();
    }

    private void lockCtxMapForRead() {
        ReentrantReadWriteLock.ReadLock readLock = this.m_ctxMapRWLock.readLock();
        readLock.lock();
    }

    private void unlockCtxMapForRead() {
        ReentrantReadWriteLock.ReadLock readLock = this.m_ctxMapRWLock.readLock();
        readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int purgeCtxMap() {
        int retVal = 0;
        if (this.mPurgeDecimator.incrementAndGet() > 10) {
            if (this.m_ctxMapRefQueueLock.tryLock()) {
                this.lockCtxMapForWrite();
                try {
                    Reference<WeakReferenceWithKey<String, C>> ref = null;
                    while ((ref = this.m_ctxMapReferenceQueue.poll()) != null) {
                        WeakReferenceWithKey refWithKey = (WeakReferenceWithKey)ref;
                        this.m_ctxMap.remove(refWithKey.getKey());
                        ++retVal;
                    }
                }
                finally {
                    this.unlockCtxMapForWrite();
                    this.m_ctxMapRefQueueLock.unlock();
                }
            }
            this.mPurgeDecimator.set(0);
        }
        return retVal;
    }

    protected void appendPrettyInstanceSummary(StringBuilder sb, Level level) {
        sb.append("\n            mECID: " + this.mECID);
        sb.append("\n          mCtxMap: " + (this.m_ctxMap == null ? "null" : Integer.toString(this.m_ctxMap.size())));
        if (this.m_ctxMap != null && level.intValue() < Level.FINER.intValue()) {
            StringBuilder ctxb = new StringBuilder(50);
            for (Map.Entry<String, WeakReferenceWithKey<String, C>> entry : this.m_ctxMap.entrySet()) {
                ctxb.append(entry.getKey()).append(", ");
                if (ctxb.length() <= 50) continue;
                sb.append("\n                 : ");
                sb.append(ctxb.toString());
                ctxb = new StringBuilder(50);
            }
            if (ctxb.length() > 0) {
                sb.append("\n                 : ");
                sb.append(ctxb.toString());
            }
        }
        Set<String> mPropagateKeys = this.mParamAttribute2ParamNameMap.get((Object)DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
        sb.append("\n   mPropagateKeys: " + (mPropagateKeys == null ? "null" : Integer.toString(mPropagateKeys.size())));
        if (mPropagateKeys != null && level.intValue() < Level.FINER.intValue()) {
            Iterator<String> iterator = mPropagateKeys.iterator();
            while (iterator.hasNext()) {
                sb.append("\n                 : " + iterator.next());
            }
        }
        Set<String> mLogKeys = this.mParamAttribute2ParamNameMap.get((Object)DomainContextManager.ParameterAttribute.LOGGABLE);
        sb.append("\n         mLogKeys: " + (mLogKeys == null ? "null" : Integer.toString(mLogKeys.size())));
        if (mLogKeys != null && level.intValue() < Level.FINER.intValue()) {
            Iterator<String> iterator = mLogKeys.iterator();
            while (iterator.hasNext()) {
                sb.append("\n                 : " + iterator.next());
            }
        }
        Set<String> mLimitKeys = this.mParamAttribute2ParamNameMap.get((Object)DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP);
        sb.append("\n       mLimitKeys: " + (mLimitKeys == null ? "null" : Integer.toString(mLimitKeys.size())));
        if (mLimitKeys != null && level.intValue() < Level.FINER.intValue()) {
            Iterator<String> iterator = mLimitKeys.iterator();
            while (iterator.hasNext()) {
                sb.append("\n                 : " + iterator.next());
            }
        }
    }
}

