/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.sampling;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.config.DumpSampleInfo;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpRegistrationEvent;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.impl.common.TempFileManager;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.resource.DiagnosticsResourceBundle;
import oracle.dfw.sampling.AccessCheck;
import oracle.dfw.sampling.DumpSamplingEventListener;
import oracle.dfw.sampling.DumpSamplingMetrics;
import oracle.dfw.sampling.Metrics;
import oracle.dfw.sampling.SampleArchiveInfo;

public class DumpSampling
extends Thread
implements DiagnosticsListener {
    static final String LOGGER_NAME = "oracle.dfw.sampling";
    static final String THREAD_NAME = "DFW Diagnostic Dump Sampling";
    static final long DEFAULT_NUM_RECORDS_TO_HOLD = 10L;
    static final long DEFAULT_INTERVAL = 60000L;
    static final long DEFAULT_SLEEP = 1000L;
    static final long DEFAULT_SHUTDOWN_TIMEOUT = 1000L;
    public static final String DEFAULT_DUMP_DIR = "sampling";
    private static final String DMP_EXTENSION = "txt";
    private static final String ZIP_EXTENSION = "zip";
    private static final String NONLETTERORDIGIT_REPLACEMENT = "_";
    private static final int IOBUFFERSIZE = 65536;
    private static boolean idleWhenHealthy_s = true;
    private static boolean isHealthy_s = true;
    private static long nextHealthCheckTime_s = 0L;
    private static long minHealthyPeriodMillis_s = 259200000L;
    private static byte[] healthCheckLock_s = new byte[0];
    private static byte[] init_lock_s = new byte[0];
    private static Map<String, DumpSampling> dumpSamplingMap_s = new HashMap<String, DumpSampling>(1);
    private static DumpSamplingEventListener eventListener_s = new DumpSamplingEventListener();
    private static boolean enabled_s = true;
    private static boolean isServerAllowed_s = true;
    private static boolean alreadyCheckedServer_s = false;
    private Hashtable<Long, SampleArchiveInfo> archiveInfos_ = new Hashtable();
    private long index_ = 0L;
    private long nKept_ = 10L;
    private long interval_ = 60000L;
    private boolean keepSampling_ = true;
    private Logger logger_;
    private DiagnosticDump diagnosticDump_;
    private DumpContext dumpCtx_;
    private DumpSampleInfo di_;
    private byte[] configUpdateLock_ = new byte[0];
    private byte[] dumpRegisterLock_ = new byte[0];
    private boolean intervalIsUpdated_ = false;
    private boolean isDumpRegistered_;
    private DumpSamplingMetrics dumpSamplingMetrics_;
    private long nextSamplingTime_ = 0L;

    DumpSampling() {
        this.setDaemon(true);
        this.isDumpRegistered_ = false;
        this.logger_ = Logger.getLogger(LOGGER_NAME, DiagnosticsResourceBundle.class.getName());
    }

    DumpSampling(DumpSampleInfo di) {
        this();
        if (di != null) {
            this.nKept_ = di.getRotationCount();
            this.interval_ = di.getSamplingInterval() * 1000L;
            this.di_ = di;
            this.assignDiagnosticDump();
            this.setName("DFW Diagnostic Dump Sampling - " + this.di_.getSampleName());
            if (this.keepSampling_) {
                this.dumpSamplingMetrics_ = new DumpSamplingMetrics(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recreateAllInstances(DiagnosticsConfiguration config) {
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            DumpSampling.removeAllInstances();
            Map<String, DumpSampleInfo> dsMap = config.getDumpSamples();
            if (dsMap != null) {
                for (DumpSampleInfo dsInfo : dsMap.values()) {
                    DumpSampling.createInstance(dsInfo);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllInstances() {
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            if (dumpSamplingMap_s.size() > 0) {
                for (Map.Entry<String, DumpSampling> samplings : dumpSamplingMap_s.entrySet()) {
                    samplings.getValue().stopIt();
                }
                dumpSamplingMap_s.clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInstance(String name) {
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            DumpSampling ds = dumpSamplingMap_s.remove(name);
            if (ds != null) {
                ds.stopIt();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DumpSampling createInstance(DumpSampleInfo di) {
        DumpSampling ds = null;
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            if (!isServerAllowed_s) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            ds = dumpSamplingMap_s.get(di.getSampleName());
            if (ds == null) {
                ds = new DumpSampling(di);
                DiagnosticsEventManager.registerListener(ds);
                dumpSamplingMap_s.put(di.getSampleName(), ds);
                ds.startIt();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DumpSampling getInstance(String name) {
        DumpSampling ds = null;
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            ds = dumpSamplingMap_s.get(name);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(String name) {
        boolean result = false;
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            result = dumpSamplingMap_s.containsKey(name);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getNameSet() {
        HashSet<String> names = new HashSet<String>(1);
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            names.addAll(dumpSamplingMap_s.keySet());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return names;
        }
    }

    public static DiagnosticsListener getEventListener() {
        return eventListener_s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DumpSampling> getAllInstances() {
        LinkedList<DumpSampling> list = null;
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            Collection<DumpSampling> c = dumpSamplingMap_s.values();
            list = new LinkedList<DumpSampling>(c);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return list;
        }
    }

    public static boolean isEnabled() {
        return enabled_s && isServerAllowed_s;
    }

    public static void setEnable(boolean enable) {
        enabled_s = enable;
    }

    public static boolean idleWhenHealthy() {
        return idleWhenHealthy_s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIdleWhenHealthy(boolean idleWhenHealthy) {
        byte[] byArray = healthCheckLock_s;
        synchronized (healthCheckLock_s) {
            if (idleWhenHealthy_s == idleWhenHealthy) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            idleWhenHealthy_s = idleWhenHealthy;
            isHealthy_s = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static long getMinimumHealthyPeriod() {
        return minHealthyPeriodMillis_s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMinmumHealthyPeriod(long healthyPeriod) {
        if (healthyPeriod < 0L) {
            return;
        }
        byte[] byArray = healthCheckLock_s;
        synchronized (healthCheckLock_s) {
            if (minHealthyPeriodMillis_s == healthyPeriod) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            minHealthyPeriodMillis_s = healthyPeriod;
            isHealthy_s = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkServer() {
        if (alreadyCheckedServer_s) {
            return;
        }
        byte[] byArray = init_lock_s;
        synchronized (init_lock_s) {
            if (!alreadyCheckedServer_s) {
                boolean isBIServer = false;
                try {
                    String val = AccessCheck.getProperty("bi.oracle.home");
                    if (val != null && val.length() > 0) {
                        isBIServer = true;
                    }
                    if (isBIServer) {
                        isServerAllowed_s = false;
                    }
                }
                catch (Throwable th) {
                    isServerAllowed_s = false;
                }
                alreadyCheckedServer_s = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    void startIt() {
        block3: {
            try {
                if (!this.isAlive() && this.keepSampling_) {
                    this.start();
                }
            }
            catch (IllegalStateException ilsx) {
                if (!this.logger_.isLoggable(Level.FINEST)) break block3;
                this.logger_.log(Level.FINEST, this + " has been started already");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void stopIt() {
        block8: {
            try {
                Object object = this;
                // MONITORENTER : object
                this.keepSampling_ = false;
                byte[] byArray = this.configUpdateLock_;
                // MONITORENTER : this.configUpdateLock_
                this.configUpdateLock_.notifyAll();
                // MONITOREXIT : byArray
                this.notifyAll();
                // MONITOREXIT : object
                object = this.dumpRegisterLock_;
                // MONITORENTER : this.dumpRegisterLock_
                this.dumpRegisterLock_.notifyAll();
                // MONITOREXIT : object
                this.join(1000L);
            }
            catch (Exception ex) {
                if (!this.logger_.isLoggable(Level.FINE)) break block8;
                this.logger_.log(Level.FINE, this + " cannot be stopped.", ex);
            }
        }
        if (!this.logger_.isLoggable(Level.FINEST)) return;
        this.logger_.log(Level.FINEST, "Archive info : " + this.archiveInfos_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            byte[] byArray = this.dumpRegisterLock_;
            // MONITORENTER : this.dumpRegisterLock_
            while (!this.isDumpRegistered_ && this.keepSampling_) {
                this.dumpRegisterLock_.wait();
            }
            // MONITOREXIT : byArray
        }
        catch (InterruptedException inex) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, this + " is unable to run due to dump " + "registration.");
            }
            this.keepSampling_ = false;
        }
        while (this.keepSampling_) {
            try {
                Object inex = this.configUpdateLock_;
                // MONITORENTER : this.configUpdateLock_
                do {
                    this.intervalIsUpdated_ = false;
                    long timeToWaitForNextSampling = this.interval_ - System.currentTimeMillis() % this.interval_;
                    if (this.interval_ > 0L) {
                        this.nextSamplingTime_ = System.currentTimeMillis() + timeToWaitForNextSampling;
                        this.configUpdateLock_.wait(timeToWaitForNextSampling);
                        continue;
                    }
                    this.nextSamplingTime_ = 0L;
                    this.configUpdateLock_.wait();
                } while (this.intervalIsUpdated_);
                // MONITOREXIT : inex
                DumpSampling dumpSampling = this;
                inex = dumpSampling;
                // MONITORENTER : dumpSampling
                if (!idleWhenHealthy_s || !DumpSampling.isSystemHealthy()) {
                    if (this.interval_ > 0L && this.nKept_ > 0L && this.keepSampling_) {
                        this.executeDump();
                        this.purge(this.index_ - this.nKept_, false);
                        this.sizeCheck();
                    }
                    ++this.index_;
                }
                // MONITOREXIT : inex
            }
            catch (InterruptedException inex) {
                if (!this.logger_.isLoggable(Level.FINE)) break;
                this.logger_.log(Level.FINE, this + " is interrupted.");
                break;
            }
            catch (Exception ex) {
                if (!this.logger_.isLoggable(Level.FINE)) continue;
                this.logger_.log(Level.FINE, this + " is terminated unexpectedly.", ex);
            }
        }
        this.cleanup();
    }

    private void cleanup() {
        block2: {
            try {
                this.dumpSamplingMetrics_.destroyDMSSensors();
                this.purgeAll();
                DiagnosticsEventManager.deregisterListener(this);
            }
            catch (Throwable th) {
                if (!this.logger_.isLoggable(Level.FINEST)) break block2;
                this.logger_.log(Level.FINEST, this + " is unable to cleanup", th);
            }
        }
    }

    private void executeDump() {
        block8: {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "execute Diagnostic Dump - " + this.diagnosticDump_);
            }
            long time = System.currentTimeMillis();
            try {
                this.checkDumpPath(this.dumpCtx_, false);
                DumpResult dr = this.diagnosticDump_.executeDump(this.dumpCtx_);
                String dumpPath = dr.getDumpContext().getDumpPath();
                LinkedList<String> files = new LinkedList<String>();
                long fileSize = 0L;
                for (String f : dr.getDumpFiles()) {
                    File dumpFile = new File(dumpPath + File.separator + f);
                    if (AccessCheck.exists(dumpFile)) {
                        fileSize += AccessCheck.length(dumpFile);
                    }
                    files.add(AccessCheck.getAbsolutePath(dumpFile));
                }
                if (files != null) {
                    SampleArchiveInfo dainfo = new SampleArchiveInfo(this.index_, time, files, fileSize, this.di_.getSampleName(), this.di_.getDiagnosticDumpName());
                    this.archiveInfos_.put(this.index_, dainfo);
                }
            }
            catch (DumpExecutionException deex) {
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "Unable to execute Diagnostic Dump", deex);
                }
            }
            catch (DumpWriterException dwex) {
                if (!this.logger_.isLoggable(Level.FINEST)) break block8;
                this.logger_.log(Level.FINEST, "Unable to write Diagnostic Dump contents", dwex);
            }
        }
    }

    private void purge(long idxToPurge, boolean force) {
        SampleArchiveInfo dainfo = this.archiveInfos_.remove(idxToPurge);
        this.purge(dainfo, force);
    }

    private void purge(SampleArchiveInfo dainfo, boolean force) {
        if (dainfo == null) {
            return;
        }
        List<String> files = dainfo.getFilenames();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.size() && force | this.keepSampling_; ++i) {
            boolean result;
            File f;
            if (files.get(i) == null || (f = new File(files.get(i))) == null || !AccessCheck.exists(f) || (result = AccessCheck.delete(f)) || !this.logger_.isLoggable(Level.FINEST)) continue;
            this.logger_.log(Level.FINEST, "Unable to delete " + f);
        }
    }

    private void purgeAll() {
        Collection<SampleArchiveInfo> collection = this.archiveInfos_.values();
        for (SampleArchiveInfo daInfo : collection) {
            this.purge(daInfo, true);
        }
        this.archiveInfos_.clear();
    }

    private void sizeCheck() {
        if (this.archiveInfos_ == null || (long)this.archiveInfos_.size() <= this.nKept_) {
            return;
        }
        TreeSet<Long> indices = new TreeSet<Long>(this.archiveInfos_.keySet());
        for (Long idx : indices) {
            this.purge(idx, false);
            if ((long)this.archiveInfos_.size() > this.nKept_ && this.keepSampling_) continue;
            break;
        }
    }

    synchronized List<String> dumpArchives(DumpContext context, boolean explicit, PrintWriter readmeWriter) {
        LinkedList<String> list;
        block3: {
            list = new LinkedList<String>();
            if (this.archiveInfos_ == null || this.archiveInfos_.size() <= 0 || !explicit && !this.di_.canBeDumpedImplicitly().booleanValue()) {
                return list;
            }
            TreeSet<Long> ids = new TreeSet<Long>(this.archiveInfos_.keySet());
            Iterator<Long> ita = ids.iterator();
            try {
                File f = null;
                f = this.di_.isAppending() != false ? DumpSampling.dumpArchives(context, ita, this.archiveInfos_, this.di_, ids.size(), readmeWriter) : DumpSampling.zipArchives(context, ita, this.archiveInfos_, this.di_, readmeWriter);
                list.add(f.getName());
            }
            catch (IOException ioex) {
                if (!this.logger_.isLoggable(Level.FINEST)) break block3;
                this.logger_.log(Level.FINEST, "Unable to dump " + this.archiveInfos_, ioex);
            }
        }
        return list;
    }

    private void assignDiagnosticDump() {
        DiagnosticsFramework df = null;
        try {
            DiagnosticDump d;
            df = new DiagnosticsFramework();
            boolean sScope = false;
            String appName = this.di_.getAppName();
            if (appName == null || appName.length() == 0) {
                sScope = true;
            }
            if ((d = df.getDumpManager().getDump(this.di_.getDiagnosticDumpName(), sScope, this.di_.getAppName())) != null) {
                this.assignDiagnosticDump(d);
            }
        }
        catch (Exception ex) {
            this.isDumpRegistered_ = false;
            this.diagnosticDump_ = null;
        }
    }

    private void assignDiagnosticDump(DiagnosticDump d) {
        this.diagnosticDump_ = d;
        DiagnosticDump.DumpRunMode drm = d.getRunMode();
        if (drm == DiagnosticDump.DumpRunMode.SYNCHRONOUS) {
            if (this.logger_.isLoggable(Level.WARNING)) {
                this.logger_.log(Level.WARNING, "DFW-40209", d.getFullDumpName());
            }
            this.isDumpRegistered_ = false;
            this.diagnosticDump_ = null;
            this.keepSampling_ = false;
            return;
        }
        this.dumpCtx_ = DumpContext.createDumpContext(this.diagnosticDump_.getOwner() + "." + this.diagnosticDump_.getName());
        this.checkDumpPath(this.dumpCtx_, true);
        this.isDumpRegistered_ = true;
        Map<String, String> arguments = this.di_.getDumpArguments();
        if (arguments != null) {
            for (Map.Entry<String, String> e : arguments.entrySet()) {
                this.dumpCtx_.addArgument(e.getKey(), (Serializable)((Object)e.getValue()));
            }
        }
    }

    String getDiagnosticDumpName() {
        return this.di_.getDiagnosticDumpName();
    }

    String getSamplingName() {
        return this.di_.getSampleName();
    }

    public DumpSampleInfo getSettings() {
        DumpSampleInfo di = new DumpSampleInfo();
        di.setSampleName(this.di_.getSampleName());
        di.setToBeDumpedImplicitly(this.di_.canBeDumpedImplicitly());
        di.setAppName(this.di_.getAppName());
        di.setDiagnosticDumpName(this.di_.getDiagnosticDumpName());
        di.setRotationCount(this.di_.getRotationCount());
        di.setSamplingInterval(this.di_.getSamplingInterval());
        di.setToAppend(this.di_.isAppending());
        HashMap<String, String> cloneArgs = new HashMap<String, String>(0);
        di.setDumpArguments(cloneArgs);
        Map<String, String> args = di.getDumpArguments();
        if (args != null) {
            for (Map.Entry<String, String> e : args.entrySet()) {
                cloneArgs.put(e.getKey(), e.getValue());
            }
        }
        return di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRuntimeSettings(DumpSampleInfo newDi) {
        Object object = this;
        synchronized (object) {
            DumpSampleInfo oldDi = this.di_;
            this.di_ = newDi;
            if (!newDi.equalDiagnsticDump(oldDi)) {
                this.assignDiagnosticDump();
            }
            this.nKept_ = this.di_.getRotationCount();
            if (this.nKept_ < 0L) {
                this.nKept_ = 0L;
            }
        }
        object = this.configUpdateLock_;
        synchronized (this.configUpdateLock_) {
            long oldInterval_ = this.interval_;
            this.interval_ = this.di_.getSamplingInterval() * 1000L;
            if (this.interval_ < 0L) {
                this.interval_ = 0L;
            }
            if (oldInterval_ != this.interval_) {
                this.intervalIsUpdated_ = true;
                this.configUpdateLock_.notifyAll();
            } else {
                this.intervalIsUpdated_ = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    synchronized Metrics getMetrics() {
        long oldestArchiveTime = -1L;
        long mostRecentArchiveTime = -1L;
        long samplingIntervalInMillis = this.interval_;
        long archivesCount = 0L;
        double diskUsage = 0.0;
        String diagnosticDumpName = this.di_.getDiagnosticDumpName();
        boolean addToDFWDumpArchive = this.di_.canBeDumpedImplicitly();
        if (this.archiveInfos_ != null && this.archiveInfos_.size() > 0) {
            archivesCount = this.archiveInfos_.size();
            TreeSet<Long> ids = new TreeSet<Long>(this.archiveInfos_.keySet());
            SampleArchiveInfo daInfo = this.archiveInfos_.get(ids.first());
            oldestArchiveTime = daInfo.getTime();
            daInfo = this.archiveInfos_.get(ids.last());
            mostRecentArchiveTime = daInfo.getTime();
            Iterator<Long> ita = ids.iterator();
            while (ita.hasNext()) {
                daInfo = this.archiveInfos_.get(ita.next());
                diskUsage += (double)daInfo.getFileSize();
            }
            if (diskUsage > 0.0) {
                diskUsage /= 1024.0;
            }
        }
        Metrics metrics = new Metrics(oldestArchiveTime, mostRecentArchiveTime, this.nextSamplingTime_, samplingIntervalInMillis, archivesCount, diskUsage, diagnosticDumpName, addToDFWDumpArchive);
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSystemHealthy() {
        long currentTime = System.currentTimeMillis();
        byte[] byArray = healthCheckLock_s;
        synchronized (healthCheckLock_s) {
            if (!isHealthy_s && currentTime <= nextHealthCheckTime_s) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return isHealthy_s;
            }
            long onsetThreshold = currentTime - minHealthyPeriodMillis_s;
            isHealthy_s = ADRInfo.getLastIncidentTime() <= onsetThreshold;
            nextHealthCheckTime_s = currentTime + minHealthyPeriodMillis_s;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return isHealthy_s;
        }
    }

    static FileOutputStream getFileOutputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File dumpArchives(DumpContext context, Iterator<Long> indices, Hashtable<Long, SampleArchiveInfo> archives, DumpSampleInfo di, int total, PrintWriter readmeWriter) throws IOException {
        String suffix = di.getSampleName();
        File f = DumpSampling.generateFileName(context, suffix, DMP_EXTENSION);
        FileOutputStream fos = null;
        OutputStreamWriter oswr = null;
        long lineNumber = 0L;
        DumpSampling.writeArchiveHeader(readmeWriter, di, archives.size(), f);
        int i = 0;
        long idx = 1L;
        try {
            fos = DumpSampling.getFileOutputStream(f);
            oswr = new OutputStreamWriter(new BufferedOutputStream(fos, 65536));
            while (indices.hasNext()) {
                SampleArchiveInfo daInfo = archives.get(indices.next());
                if (daInfo == null) {
                    ++idx;
                    continue;
                }
                DumpSampling.writeArchiveDesc(readmeWriter, false, idx, daInfo, lineNumber + 2L, null, 0L);
                oswr.write(daInfo.toHeaderString(++i, total));
                lineNumber += 4L;
                oswr.flush();
                List<String> filenames = daInfo.getFilenames();
                for (String ar : filenames) {
                    File arFile = new File(ar);
                    FileInputStream fis = DumpSampling.getFileInputStream(arFile);
                    BufferedInputStream bis = new BufferedInputStream(fis, 65536);
                    LineNumberReader lrd = new LineNumberReader(new InputStreamReader(bis));
                    String line = null;
                    do {
                        if ((line = lrd.readLine()) == null) continue;
                        oswr.write(line);
                        oswr.write("\n");
                        ++lineNumber;
                    } while (line != null);
                    oswr.flush();
                    lrd.close();
                }
                oswr.write(daInfo.toFooterString(i, total));
                ++lineNumber;
                oswr.flush();
                ++idx;
            }
            readmeWriter.println();
            fos.flush();
        }
        finally {
            try {
                if (oswr != null) {
                    oswr.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioex) {
                fos = null;
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File zipArchives(DumpContext context, Iterator<Long> indices, Hashtable<Long, SampleArchiveInfo> archives, DumpSampleInfo di, PrintWriter readmeWriter) throws IOException {
        String suffix = di.getSampleName();
        File f = DumpSampling.generateFileName(context, suffix, ZIP_EXTENSION);
        DumpSampling.writeArchiveHeader(readmeWriter, di, archives.size(), f);
        FileOutputStream fos = null;
        ZipOutputStream zout = null;
        byte[] buffer = new byte[65536];
        try {
            fos = DumpSampling.getFileOutputStream(f);
            zout = new ZipOutputStream(fos);
            long idx = 1L;
            while (indices.hasNext()) {
                SampleArchiveInfo daInfo = archives.get(indices.next());
                if (daInfo == null) {
                    ++idx;
                    continue;
                }
                List<String> filenames = daInfo.getFilenames();
                for (String ar : filenames) {
                    File arFile = new File(ar);
                    FileInputStream fis = DumpSampling.getFileInputStream(arFile);
                    DumpSampling.writeArchiveDesc(readmeWriter, true, idx, daInfo, 0L, arFile.getName(), arFile.length());
                    ZipEntry ze = new ZipEntry(arFile.getName());
                    ze.setTime(arFile.lastModified());
                    zout.putNextEntry(ze);
                    int len = 0;
                    do {
                        if ((len = fis.read(buffer)) <= 0) continue;
                        zout.write(buffer, 0, len);
                    } while (len > 0);
                    zout.closeEntry();
                    fis.close();
                }
                ++idx;
            }
            readmeWriter.println();
            fos.flush();
        }
        finally {
            try {
                if (zout != null) {
                    zout.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioex) {
                fos = null;
            }
        }
        return f;
    }

    static void writeArchiveHeader(PrintWriter w, DumpSampleInfo di, long quantity, File file) {
        w.println("Diagnostic Dump Sampling");
        w.println("------------------------");
        w.println("Dump Sampling:    " + di.getSampleName());
        w.println("Diagnostic Dump:  " + di.getDiagnosticDumpName());
        w.println("Dump Arguments:   " + di.getDumpArguments());
        w.println("Interval (sec):   " + di.getSamplingInterval());
        w.println("Quantity:         " + quantity);
        w.println("Archive Filename: " + file.getName());
        w.println();
        w.println("Samples");
        w.println("-------");
    }

    static void writeArchiveDesc(PrintWriter w, boolean isZip, long idx, SampleArchiveInfo archInfo, long lineNumber, String filename, long len) {
        w.print("#");
        w.print(idx);
        w.print(", idx:");
        w.print(archInfo.getIndex());
        w.print(", ");
        w.print(new Date(archInfo.getTime()));
        w.print(", ");
        if (isZip) {
            w.print(filename);
            w.print(" (");
            w.print(len);
            w.print(" bytes)");
        } else {
            w.print("line#:");
            w.print(lineNumber);
        }
        w.println();
    }

    static File generateFileName(DumpContext context, String suffix, String extension) throws IOException {
        File file = null;
        String newSuffix = suffix;
        if (suffix != null) {
            StringBuffer strBuf = new StringBuffer();
            int len = suffix.length();
            for (int i = 0; i < len; ++i) {
                char c = suffix.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    strBuf.append(c);
                    continue;
                }
                strBuf.append(NONLETTERORDIGIT_REPLACEMENT);
            }
            strBuf.append('.');
            strBuf.append(extension);
            newSuffix = strBuf.toString();
        }
        file = context.generateUniqueFile(newSuffix);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkDumpPath(DumpContext dumpCtx, boolean reset) {
        block8: {
            try {
                DumpContext dumpContext = dumpCtx;
                synchronized (dumpContext) {
                    if (reset) {
                        dumpCtx.setDumpPath(DumpSampling.getNewDumpPath());
                    } else {
                        File ctxPath = new File(dumpCtx.getDumpPath());
                        if (!AccessCheck.exists(ctxPath)) {
                            dumpCtx.setDumpPath(DumpSampling.getNewDumpPath());
                        }
                    }
                }
            }
            catch (IOException ioex) {
                if (!this.logger_.isLoggable(Level.FINEST)) break block8;
                this.logger_.log(Level.FINEST, "Unable to set dump path, default to " + dumpCtx.getDumpPath());
            }
        }
    }

    static String getNewDumpPath() throws IOException {
        File root = TempFileManager.getTemporaryDirectory();
        File dumpPath = new File(root, DEFAULT_DUMP_DIR);
        if (!AccessCheck.exists(dumpPath)) {
            dumpPath.mkdir();
        }
        return dumpPath.getAbsolutePath();
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class, DumpRegistrationEvent.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof DiagnosticsConfigurationChangedEvent) {
            DiagnosticsConfiguration config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration();
            if (config == null) {
                return;
            }
            DumpSampleInfo oldDi = this.di_;
            DumpSampleInfo newDi = config.getDumpSamples().get(oldDi.getSampleName());
            if (newDi == null || !newDi.getSampleName().equals(oldDi.getSampleName())) {
                return;
            }
            this.updateRuntimeSettings(newDi);
            return;
        }
        if (!(event instanceof DumpRegistrationEvent)) return;
        try {
            byte[] config = this.dumpRegisterLock_;
            synchronized (this.dumpRegisterLock_) {
                String name;
                if (this.isDumpRegistered_) return;
                DiagnosticDump d = ((DumpRegistrationEvent)event).getDump();
                if (d != null && (name = d.getFullDumpName()) != null && name.equals(this.di_.getDiagnosticDumpName())) {
                    this.assignDiagnosticDump(d);
                }
                this.dumpRegisterLock_.notifyAll();
                // ** MonitorExit[config] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            if (!this.logger_.isLoggable(Level.FINEST)) return;
            this.logger_.log(Level.FINEST, "Unable to complete dump registeration.");
        }
    }

    static {
        DumpSampling.checkServer();
    }
}

