/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.impl.common.NamedThreadFactory;

public class ExternalUtility {
    private static ExecutorService s_executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("oracle.dfw.impl.ExternalUtility - JVM Command executor"));
    private static Object s_executeLock = new Object();
    private static Method m_executeMethod;
    private static volatile Object m_diagCmd;

    static void execute(COMMAND cmd, DumpWriter dw) throws Exception {
        ExternalUtility.internalExecute(cmd, dw);
    }

    static ArrayList<String> execute(COMMAND cmd) throws Exception {
        return ExternalUtility.internalExecute(cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> internalExecute(COMMAND cmd, DumpWriter dw) throws Exception {
        String vendor = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            vendor = System.getProperty("java.vm.vendor");
        }
        catch (SecurityException ex) {
            vendor = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.vm.vendor");
                }
            });
        }
        String vmName = null;
        try {
            vmName = System.getProperty("java.vm.name");
        }
        catch (SecurityException ex) {
            vmName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.vm.name");
                }
            });
        }
        Object object = s_executeLock;
        synchronized (object) {
            if (vendor != null && vendor.startsWith("Oracle") && vmName.indexOf("JRockit") != -1 && !cmd.equals((Object)COMMAND.JPS)) {
                ExternalUtility.executeJRockitCommand(cmd, dw);
            } else {
                Process proc = ExternalUtility.launchUtility(cmd, vendor, vmName);
                if (proc == null) {
                    return lines;
                }
                if (dw != null && cmd.equals((Object)COMMAND.THREAD)) {
                    dw.dumpln("");
                    dw.dumpln("===== FULL THREAD DUMP ===============");
                }
                StreamReader outputReader = new StreamReader(proc.getInputStream(), dw, lines);
                outputReader.start();
                ExternalUtility.getProcessExitValue(proc, 120L);
                outputReader.join();
                if (dw != null && cmd.equals((Object)COMMAND.THREAD)) {
                    dw.dumpln("===== END OF THREAD DUMP ===============");
                    dw.dumpln("");
                }
            }
        }
        return lines;
    }

    private static int getProcessExitValue(final Process proc, long timeout) throws Exception {
        Callable<Integer> call = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                proc.waitFor();
                return proc.exitValue();
            }
        };
        try {
            Future<Integer> ft = s_executor.submit(call);
            int exitVal = ft.get(timeout, TimeUnit.SECONDS);
            return exitVal;
        }
        catch (TimeoutException toe) {
            proc.destroy();
            throw new Exception("Timeout executing JVM command");
        }
    }

    private static Process launchUtility(COMMAND command, String vendor, String vmName) throws Exception {
        String cmd = null;
        Process retProc = null;
        try {
            cmd = System.getProperty("java.home") + File.separator + ".." + File.separator + "bin" + File.separator;
        }
        catch (SecurityException ex) {
            cmd = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.home") + File.separator + ".." + File.separator + "bin" + File.separator;
                }
            });
        }
        String pid = ExternalUtility.getMyJVMPID();
        if (command.equals((Object)COMMAND.JPS) || vendor != null && (vendor.startsWith("Sun") || vendor.startsWith("Oracle Corporation") && vmName != null && vmName.startsWith("Java HotSpot"))) {
            switch (command) {
                case HEAP: {
                    cmd = cmd + "jmap -heap " + pid;
                    break;
                }
                case CLASSHISTOGRAM: {
                    cmd = cmd + "jmap -histo:live " + pid;
                    break;
                }
                case THREAD: {
                    cmd = cmd + "jstack -l " + pid;
                    break;
                }
                case JPS: {
                    cmd = cmd + "jps";
                    break;
                }
            }
        } else {
            throw new Exception("no external command identified for VM \"" + vmName + "\"");
        }
        final String fcmd = cmd;
        try {
            retProc = Runtime.getRuntime().exec(fcmd);
        }
        catch (SecurityException ex) {
            try {
                retProc = AccessController.doPrivileged(new PrivilegedExceptionAction<Process>(){

                    @Override
                    public Process run() throws IOException {
                        return Runtime.getRuntime().exec(fcmd);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }
        return retProc;
    }

    private static void executeJRockitCommand(COMMAND cmd, DumpWriter dw) throws Exception {
        String jrockitCommand = null;
        switch (cmd) {
            case HEAP: {
                jrockitCommand = "print_memusage";
                break;
            }
            case CLASSHISTOGRAM: {
                jrockitCommand = "heap_diagnostics";
                break;
            }
            case THREAD: {
                jrockitCommand = "print_threads";
                break;
            }
            default: {
                return;
            }
        }
        try {
            if (m_diagCmd == null || m_executeMethod == null) {
                Class jvmFactoryClass = ExternalUtility.getClass("com.bea.jvm.JVMFactory");
                Method getJVM = jvmFactoryClass.getMethod("getJVM", new Class[0]);
                Class jvmClass = ExternalUtility.getClass("com.bea.jvm.JVM");
                Method getDiagnosticCommand = jvmClass.getMethod("getDiagnosticCommand", new Class[0]);
                Class diagnosticCommandClass = ExternalUtility.getClass("com.bea.jvm.DiagnosticCommand");
                m_executeMethod = diagnosticCommandClass.getMethod("execute", String.class);
                Object jvm = getJVM.invoke(null, new Object[0]);
                m_diagCmd = getDiagnosticCommand.invoke(jvm, new Object[0]);
            }
            dw.dumpln((String)m_executeMethod.invoke(m_diagCmd, jrockitCommand));
        }
        catch (Throwable e) {
            throw new Exception("Issue executing JRockit command " + jrockitCommand, e);
        }
    }

    private static Class getClass(final String className) throws Exception {
        Class resultClass = null;
        try {
            resultClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws Exception {
                    return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return resultClass;
    }

    public static Object getExecuteLock() {
        return s_executeLock;
    }

    public static String getMyJVMPID() {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        int idx = pid.indexOf("@");
        pid = pid.substring(0, idx);
        return pid;
    }

    public static ArrayList<String> getAllJVMPIDS() {
        ArrayList<String> pids = null;
        try {
            ArrayList<String> retList = ExternalUtility.execute(COMMAND.JPS);
            if (retList != null && retList.size() > 0) {
                pids = new ArrayList<String>();
                for (String line : retList) {
                    int idx;
                    if (line == null || (line = line.trim()) == null || (idx = line.indexOf(32)) <= 0) continue;
                    String pid = line.substring(0, idx);
                    pids.add(pid);
                }
            }
        }
        catch (Exception ex) {
            pids = null;
        }
        return pids;
    }

    private static class StreamReader
    extends Thread {
        private DumpWriter m_dw;
        private InputStream m_is;
        private ArrayList<String> m_lines;

        StreamReader(InputStream is, DumpWriter dw, ArrayList<String> lines) {
            this.m_dw = dw;
            this.m_is = is;
            this.m_lines = lines;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.m_is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.m_dw == null) {
                        if (this.m_lines == null) continue;
                        this.m_lines.add(line);
                        continue;
                    }
                    this.m_dw.dumpln(line);
                }
            }
            catch (IOException ioe) {
                this.m_dw.dumpln("Failure reading stream: " + ioe.getMessage());
            }
        }
    }

    static enum COMMAND {
        CLASSHISTOGRAM,
        HEAP,
        THREAD,
        JPS;

    }
}

