/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.ObjectUtils;

@JSONUtils.JSONFormatToString
public class ParameterConstraint {
    public static final int UNSPECIFIED_MAX_VALUES = -2;
    private final String mParameterName;
    private final String[] mParameterValues;
    private final String mDefaultValue;
    private final int mMaxNumberOfValues;
    final int mHashCode;
    private static final CompositeType PARAM_CONS_CT;
    private static final OpenType[] PARAM_CONS_CT_ITEM_TYPES;
    private static final String[] PARAM_CONS_CT_ITEM_NAMES;
    private static final String[] PARAM_CONS_CT_ITEM_DESCRIPTIONS;

    @ConstructorProperties(value={"parameterName", "parameterValues", "defaultValue", "maxNumberOfValues"})
    public ParameterConstraint(String parameterName, String[] parameterValues, String defaultValue, int maxNumberOfValues) {
        int tmpHashCode = 0;
        if (parameterName == null) {
            throw new IllegalArgumentException("ParameterName must not be null.");
        }
        if (maxNumberOfValues != -2 && maxNumberOfValues < 0) {
            throw new IllegalArgumentException("maxNumberOfValues must be greater than zero or ParameterConstraint.UNSPECIFIED_MAX_VALUES");
        }
        this.mParameterName = parameterName;
        this.mDefaultValue = defaultValue;
        tmpHashCode ^= this.mParameterName.hashCode();
        tmpHashCode ^= this.mDefaultValue == null ? 0 : this.mDefaultValue.hashCode();
        if (parameterValues != null && parameterValues.length > 0) {
            this.mParameterValues = parameterValues;
            this.mMaxNumberOfValues = -2;
            for (String s : parameterValues) {
                tmpHashCode ^= s.hashCode();
            }
        } else {
            this.mParameterValues = null;
            this.mMaxNumberOfValues = maxNumberOfValues > 0 ? maxNumberOfValues : -2;
            tmpHashCode ^= this.mMaxNumberOfValues;
        }
        this.mHashCode = tmpHashCode;
    }

    public String getParameterName() {
        return this.mParameterName;
    }

    public String[] getParameterValues() {
        return this.mParameterValues;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public int getMaxNumberOfValues() {
        return this.mMaxNumberOfValues;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object o) {
        boolean retVal = false;
        if (o instanceof ParameterConstraint) {
            ParameterConstraint that = (ParameterConstraint)o;
            if (this == that) {
                retVal = true;
            } else if (Arrays.equals(this.mParameterValues, that.mParameterValues) && ObjectUtils.areEqual(this.mParameterName, that.mParameterName) && ObjectUtils.areEqual(this.mDefaultValue, that.mDefaultValue) && this.mMaxNumberOfValues == that.mMaxNumberOfValues) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static CompositeType toCompositeType() {
        return PARAM_CONS_CT;
    }

    public CompositeData toCompositeData(CompositeType ct) {
        CompositeDataSupport retVal = null;
        if (PARAM_CONS_CT != null) {
            try {
                HashMap<String, Object> allData = new HashMap<String, Object>();
                allData.put(PARAM_CONS_CT_ITEM_NAMES[0], this.mParameterName);
                if (this.mParameterValues == null) {
                    allData.put(PARAM_CONS_CT_ITEM_NAMES[1], null);
                } else {
                    allData.put(PARAM_CONS_CT_ITEM_NAMES[1], this.mParameterValues);
                }
                allData.put(PARAM_CONS_CT_ITEM_NAMES[2], this.mDefaultValue);
                allData.put(PARAM_CONS_CT_ITEM_NAMES[3], this.mMaxNumberOfValues);
                retVal = new CompositeDataSupport(PARAM_CONS_CT, allData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public static ParameterConstraint from(CompositeData cd) {
        String paramName = (String)cd.get(PARAM_CONS_CT_ITEM_NAMES[0]);
        String[] valueArr = null;
        String[] valueCDArr = (String[])cd.get(PARAM_CONS_CT_ITEM_NAMES[1]);
        if (valueCDArr != null && valueCDArr.length > 0) {
            valueArr = valueCDArr;
        }
        String defaultValue = (String)cd.get(PARAM_CONS_CT_ITEM_NAMES[2]);
        Integer maxNumOfValues = (Integer)cd.get(PARAM_CONS_CT_ITEM_NAMES[3]);
        ParameterConstraint retVal = new ParameterConstraint(paramName, valueArr, defaultValue, maxNumOfValues);
        return retVal;
    }

    public String toString() {
        boolean addComma = false;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        JSONUtils.appendNameValuePair(sb, "parameterName", this.mParameterName);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "defaultValue", this.mDefaultValue);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "maxNumOfValues", this.mMaxNumberOfValues);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "valueSet", this.mParameterValues);
        sb.append('}');
        String retVal = sb.toString();
        return retVal;
    }

    static {
        PARAM_CONS_CT_ITEM_NAMES = new String[]{"parameterConstraintParameterName", "parameterConstraintParameterValues", "parameterConstraintDefaultValue", "parameterConstraintNumberOfValues"};
        PARAM_CONS_CT_ITEM_DESCRIPTIONS = new String[]{"The name of the parameter to which the constraint applies.", "The sub set of values applied by the constraint (if any).", "The default value to be assumed by the constraint if the parameter value is null (if any).", "The maximum number of distinct values applied by the constraint (if any)."};
        CompositeType constraintCT = null;
        OpenType[] constraintItemTypes = null;
        try {
            ArrayType<String[]> paramValuesCT = ArrayType.getArrayType(SimpleType.STRING);
            constraintItemTypes = new OpenType[]{SimpleType.STRING, paramValuesCT, SimpleType.STRING, SimpleType.INTEGER};
            constraintCT = new CompositeType("DMSParameterConstraint", "Read-only data describing a DMS parameter constraint.", PARAM_CONS_CT_ITEM_NAMES, PARAM_CONS_CT_ITEM_DESCRIPTIONS, constraintItemTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (constraintItemTypes != null && constraintCT != null) {
            PARAM_CONS_CT = constraintCT;
            PARAM_CONS_CT_ITEM_TYPES = constraintItemTypes;
        } else {
            PARAM_CONS_CT = null;
            PARAM_CONS_CT_ITEM_TYPES = null;
        }
    }
}

