/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.core.ojdl.logging.LogUtil;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;

class ProblemKeyFilterChecker
implements DiagnosticsListener {
    private final ReentrantReadWriteLock m_rwLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_rwLock.readLock();
    private final Lock m_writeLock = this.m_rwLock.writeLock();
    private ArrayList<Pattern> m_filters = new ArrayList(1);

    ProblemKeyFilterChecker(DiagnosticsConfiguration config) {
        this.updateFilters(config);
        DiagnosticsEventManager.registerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFiltered(String problemKey) {
        boolean isFiltered = false;
        this.m_readLock.lock();
        try {
            for (Pattern pattern : this.m_filters) {
                Matcher matcher = pattern.matcher(problemKey);
                if (!matcher.matches()) continue;
                isFiltered = true;
                break;
            }
        }
        finally {
            this.m_readLock.unlock();
        }
        return isFiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilters(DiagnosticsConfiguration config) {
        this.m_writeLock.lock();
        try {
            this.m_filters.clear();
            for (String filter : config.getProblemKeyFilters().values()) {
                try {
                    this.m_filters.add(Pattern.compile(filter));
                }
                catch (PatternSyntaxException e) {
                    LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40128", (Object)filter, (Throwable)e);
                }
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        DiagnosticsConfigurationChangedEvent configEvent;
        if (event instanceof DiagnosticsConfigurationChangedEvent && (configEvent = (DiagnosticsConfigurationChangedEvent)event).getChangedValues() != null && configEvent.getChangedValues().containsKey("problemKeyFilters")) {
            this.updateFilters(configEvent.getDiagnosticsConfiguration());
        }
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }
}

