/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.event.HTTPRequestTracker;

public class HTTPRequestTrackerDump
extends ComponentDiagnosticDump {
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();
    private static final String ECID_ARG = "ecid";

    public HTTPRequestTrackerDump() {
        this.defineArgument(ECID_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_HTTP_REQUESTS_ECID_ARG");
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        DumpWriter dw = new DumpWriter(context);
        HTTPRequestTracker tracker = HTTPRequestTracker.getInstance();
        if (tracker.isActive()) {
            String ecid = context.getArguments().getString(ECID_ARG);
            if (ecid == null) {
                dw.dumpln("Active HTTP Requests\n");
                ArrayList<String> list = tracker.getRequests();
                for (String request : list) {
                    dw.dumpln(request);
                }
            } else {
                dw.dumpln("HTTP Request for Execution Context " + ecid);
                String request = tracker.getRequest(ecid);
                if (request != null) {
                    dw.dumpln();
                    dw.dumpln(request);
                }
            }
        } else {
            dw.dumpln(this.getMsg("DFW_HTTP_REQUESTS_NOTRACK", null));
        }
        return dw.getDumpResult();
    }

    @Override
    public String getName() {
        return "requests";
    }

    @Override
    public String getOwner() {
        return "http";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.HTTP_REQUESTS);
    }

    @Override
    public String getDumpDescription() {
        return this.getMsg("DFW_HTTP_REQUESTS_DESCRIPTION", null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_HTTP_REQUESTS_DESCRIPTION", locale);
    }

    @Override
    public DiagnosticDump.DumpRunMode getRunMode() {
        return DiagnosticDump.DumpRunMode.SYNCHRONOUS_ASYNCHRONOUS;
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }
}

