/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class DoubleValue
extends Value {
    private double _value = 0.0;
    private double _min = Double.MAX_VALUE;
    private double _max = Double.MIN_VALUE;

    private void setValue(double newval) {
        this._value = newval;
        if (this.MAX && this._value > this._max) {
            this._max = newval;
        }
        if (this.MIN && this._value < this._min) {
            this._min = newval;
        }
    }

    @Override
    public void update(double newval) {
        this.setValue(newval);
    }

    @Override
    public void update(int newval) {
        double dval = newval;
        this.setValue(dval);
    }

    @Override
    public void update(long newval) {
        double dval = newval;
        this.setValue(dval);
    }

    @Override
    public void increment() {
        this.setValue(this._value + 1.0);
    }

    @Override
    public void increment(int inc) {
        double dval = this._value + (double)inc;
        this.setValue(dval);
    }

    @Override
    public void increment(long inc) {
        double dval = this._value + (double)inc;
        this.setValue(dval);
    }

    @Override
    public void increment(double inc) {
        this.setValue(this._value + inc);
    }

    @Override
    void initMinMax() {
        if (this._initialized) {
            if (this.MIN && this._min > this._value) {
                this._min = this._value;
            }
            if (this.MAX && this._max < this._value) {
                this._max = this._value;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.MIN) {
            this._min = this._value;
        }
        if (this.MAX) {
            this._max = this._value;
        }
    }

    @Override
    public Object getValue() {
        return new Double(this._value);
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Double.MAX_VALUE) {
            return new Double(this._min);
        }
        return new Double(0.0);
    }

    @Override
    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Double.MIN_VALUE) {
            return new Double(this._max);
        }
        return new Double(0.0);
    }

    @Override
    public String toString() {
        return Double.toString(this._value);
    }

    @Override
    public Object clone() {
        DoubleValue retVal = (DoubleValue)super.clone();
        return retVal;
    }
}

