/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ErrorMessage
implements Serializable {
    private String m_originalErrorMessageId;
    private String m_errorFacility;
    private int m_errorNumber;
    private String m_errorMessageText;
    private List<String> m_errorArgs;
    private static final char FACILITY_BREAK = '-';
    public static final String DEFAULT_INCIDENT_FACILITY = "DFW";
    public static final int DEFAULT_INCIDENT_NUMBER = 99999;
    private static final long serialVersionUID = 0L;

    public ErrorMessage(String errorFacility, int errorNumber) {
        if (errorFacility == null || errorFacility.length() == 0) {
            throw new IllegalArgumentException("errorFacility=" + errorFacility + " errorNumber=" + errorNumber);
        }
        this.m_errorFacility = errorFacility;
        this.m_errorNumber = errorNumber;
        this.m_originalErrorMessageId = this.getErrorFacilityAndNumber();
    }

    public ErrorMessage(String errorString) {
        if (errorString == null || errorString.length() == 0) {
            throw new IllegalArgumentException("errorString=" + errorString);
        }
        int pos = errorString.lastIndexOf(45);
        String errorFacility = null;
        String errorNumber = errorString;
        if (pos > 0 && errorString.length() > pos + 1) {
            errorFacility = errorString.substring(0, pos);
            errorNumber = errorString.substring(pos + 1, errorString.length());
        }
        if (errorNumber == null || errorFacility == null) {
            throw new IllegalArgumentException("Error message ID invalid. It must be of the form [FACILITY]-[NUMBER], i.e. ORA-600");
        }
        this.m_errorFacility = errorFacility;
        this.m_errorNumber = Integer.parseInt(errorNumber);
        if (this.m_errorNumber < 0) {
            throw new IllegalArgumentException("Error message ID invalid. It must be of the form [FACILITY]-[NUMBER], i.e. ORA-600");
        }
        this.m_originalErrorMessageId = errorString;
    }

    @ConstructorProperties(value={"errorFacilityAndNumber", "errorMessageText", "errorArguments"})
    public ErrorMessage(String errorString, String errorMessageText, List<String> errorArguments) {
        this(errorString);
        if (errorMessageText != null) {
            this.setErrorMessageText(errorMessageText);
        }
        if (errorArguments != null) {
            this.setErrorArguments(errorArguments);
        }
    }

    public String getErrorFacility() {
        return this.m_errorFacility;
    }

    public int getErrorNumber() {
        return this.m_errorNumber;
    }

    public String getErrorFacilityAndNumber() {
        String fullMsg = "";
        if (this.m_errorFacility != null) {
            fullMsg = this.m_errorFacility;
            fullMsg = fullMsg + '-';
        }
        fullMsg = fullMsg + this.m_errorNumber;
        return fullMsg;
    }

    public String getOriginalErrorMessageId() {
        return this.m_originalErrorMessageId;
    }

    public List<String> getErrorArguments() {
        if (this.m_errorArgs != null) {
            return this.m_errorArgs;
        }
        return Collections.emptyList();
    }

    public void setErrorArguments(List<String> arguments) {
        this.m_errorArgs = arguments;
    }

    public String getErrorMessageText() {
        return this.m_errorMessageText;
    }

    public void setErrorMessageText(String errorMessageText) {
        this.m_errorMessageText = errorMessageText;
    }

    public String toString() {
        StringBuilder val = new StringBuilder();
        if (this.m_errorFacility != null) {
            val.append(this.m_errorFacility);
            val.append('-');
        }
        val.append(this.m_errorNumber);
        if (this.m_errorArgs != null) {
            val.append(" ");
            for (String value : this.m_errorArgs) {
                val.append("[");
                val.append(value);
                val.append("]");
            }
        }
        return val.toString();
    }

    public static enum SystemErrorMessage {
        DEFAULT_ERROR_MESSAGE("DFW", 99999, "incident created, refer to incident readme.txt for more information"),
        UNHANDLED_EXCEPTION_ERROR_MESSAGE("DFW", 99998, "unhandled Exception detected"),
        OOME_ERROR_MESSAGE("DFW", 99997, "java.lang.OutOfMemoryError detected"),
        SQL_EXCEPTION_ERROR_MESSAGE("DFW", 99996, "unhandled java.lang.SQLException detected"),
        SLOW_HTTP_REQUEST_ERROR_MESSAGE("DFW", 99995, "slow HTTP request detected");

        private ErrorMessage m_errMessage;

        private SystemErrorMessage(String errorFacility, int errorNumber, String errorText) {
            this.m_errMessage = new ErrorMessage(errorFacility, errorNumber);
            this.m_errMessage.setErrorMessageText(errorText);
        }

        public ErrorMessage getErrorMessage() {
            return this.m_errMessage;
        }

        public ErrorMessage getErrorMessage(String errorText) {
            ErrorMessage errMsg = new ErrorMessage(this.m_errMessage.getErrorFacility(), this.m_errMessage.getErrorNumber());
            errMsg.setErrorMessageText(errorText);
            return errMsg;
        }
    }
}

