/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.sampling;

import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.dfw.sampling.DumpSampling;
import oracle.dfw.sampling.Metrics;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class DumpSamplingMetrics
implements GroupRefresh {
    static final String ROOTNAME = "/oracle/dfw/diagnosticDumpSampling";
    static final String NOUNTYPE = "DFW_DiagnosticDumpSamplingInfo";
    static final String ST_DIAGNOSTICDUMP = "diagnosticDump";
    static final String ST_OLDESTTIME = "oldestTimestamp";
    static final String ST_RECENTTIME = "rencentTimestamp";
    static final String ST_ARCHIVECOUNT = "archiveCount";
    static final String ST_SAMPLINGINTERVAL = "samplingInterval";
    static final String ST_DISKUSAGE = "diskUsage";
    static final String ST_COUNTDOWNTONEXTSAMPLE = "countdown";
    static final String ST_DUMPEDIMPLICITLY = "dumpedImplicitly";
    static final String TIME_STAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    static final String NOT_AVAILABLE = "N/A";
    private static byte[] initLock_s = new byte[0];
    private static SimpleDateFormat dateFormat_s = null;
    private static Noun nounRoot_s = null;
    private DumpSampling ds_;
    private Noun noun_;
    private State stateDiagnosticDump_;
    private State stateOldestTime_;
    private State stateMostRecentTime_;
    private State stateArchiveCount_;
    private State stateSamplingInterval_;
    private State stateDiskUsage_;
    private State stateCountdown_;
    private State stateDumpedImplicitly_;
    private boolean destroyed_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumpSamplingMetrics(DumpSampling ds) {
        byte[] byArray = initLock_s;
        synchronized (initLock_s) {
            if (dateFormat_s == null) {
                dateFormat_s = new SimpleDateFormat(TIME_STAMP_FORMAT);
            }
            if (nounRoot_s == null) {
                try {
                    nounRoot_s = Noun.get(ROOTNAME);
                }
                catch (Exception ex) {
                    nounRoot_s = Noun.create(ROOTNAME);
                }
                if (nounRoot_s == null) {
                    nounRoot_s = Noun.create(ROOTNAME);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.ds_ = ds;
            this.noun_ = Noun.create(nounRoot_s, ds.getSamplingName(), NOUNTYPE);
            this.createSensors();
            return;
        }
    }

    private synchronized void createSensors() {
        this.stateDiagnosticDump_ = State.create(this.noun_, ST_DIAGNOSTICDUMP, (byte)5, "name", "diagnostic dump name");
        this.stateOldestTime_ = State.create(this.noun_, ST_OLDESTTIME, (byte)5, "time", "time stamp of the oldest archive on disk");
        this.stateMostRecentTime_ = State.create(this.noun_, ST_RECENTTIME, (byte)5, "time", "time stamp of the most recent archive on disk");
        this.stateArchiveCount_ = State.create(this.noun_, ST_ARCHIVECOUNT, (byte)2, "archives", "number of archives on disk");
        this.stateSamplingInterval_ = State.create(this.noun_, ST_SAMPLINGINTERVAL, (byte)2, "seconds", "sampling interval");
        this.stateDiskUsage_ = State.create(this.noun_, ST_DISKUSAGE, (byte)1, "KB", "disk space occupied by archives");
        this.stateCountdown_ = State.create(this.noun_, ST_COUNTDOWNTONEXTSAMPLE, (byte)2, "seconds", "countdown to the next sampling");
        this.stateDumpedImplicitly_ = State.create(this.noun_, ST_DUMPEDIMPLICITLY, (byte)5, "boolean", "archives are dumped implicitly");
        this.destroyed_ = false;
        this.stateDiagnosticDump_.setRefresh(this);
        this.stateOldestTime_.setRefresh(this);
        this.stateMostRecentTime_.setRefresh(this);
        this.stateArchiveCount_.setRefresh(this);
        this.stateSamplingInterval_.setRefresh(this);
        this.stateDiskUsage_.setRefresh(this);
        this.stateCountdown_.setRefresh(this);
        this.stateDumpedImplicitly_.setRefresh(this);
    }

    synchronized void destroyDMSSensors() {
        this.stateDiagnosticDump_.removeRefresh();
        this.stateOldestTime_.removeRefresh();
        this.stateMostRecentTime_.removeRefresh();
        this.stateArchiveCount_.removeRefresh();
        this.stateSamplingInterval_.removeRefresh();
        this.stateDiskUsage_.removeRefresh();
        this.stateCountdown_.removeRefresh();
        this.stateDumpedImplicitly_.removeRefresh();
        this.stateDiagnosticDump_.destroy();
        this.stateOldestTime_.destroy();
        this.stateMostRecentTime_.destroy();
        this.stateArchiveCount_.destroy();
        this.stateSamplingInterval_.destroy();
        this.stateDiskUsage_.destroy();
        this.stateCountdown_.destroy();
        this.stateDumpedImplicitly_.destroy();
        this.noun_.destroy();
        this.destroyed_ = true;
    }

    @Override
    public synchronized void refresh() {
        if (this.destroyed_) {
            return;
        }
        Metrics metrics = this.ds_.getMetrics();
        String timeStamp = NOT_AVAILABLE;
        try {
            this.stateArchiveCount_.update(metrics.getArchivesCount());
            this.stateDumpedImplicitly_.update(Boolean.toString(metrics.isToBeDumpedImplicitly()));
            this.stateDiagnosticDump_.update(metrics.getDiagnosticDumpName());
            this.stateSamplingInterval_.update(metrics.getSamplingIntervalInMillis() / 1000L);
            this.stateDiskUsage_.update(metrics.getDiskUsage());
            long countdown = metrics.getNextSamplingTimeInMillis() > 0L ? (metrics.getNextSamplingTimeInMillis() - System.currentTimeMillis()) / 1000L : 0L;
            this.stateCountdown_.update(countdown);
            long time = metrics.getOldestArchiveTime();
            if (time > 0L) {
                timeStamp = dateFormat_s.format(new Date(time));
            }
            this.stateOldestTime_.update(timeStamp);
            timeStamp = NOT_AVAILABLE;
            time = metrics.getMostRecentArchiveTime();
            if (time > 0L) {
                timeStamp = dateFormat_s.format(new Date(time));
            }
            this.stateMostRecentTime_.update(timeStamp);
        }
        catch (Exception ex) {
            timeStamp = null;
        }
    }
}

