/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.LeakStatistic;
import oracle.jvmmon.agent.SampleDataProcessor;

class PotentialLeak
implements GroupRefresh {
    static final String NOUN_NAME = "PotentialLeak";
    static final int MAX_ROW = 5;
    static final byte COL_TRACIID = 0;
    static final byte COL_CLSSNAM = 1;
    static final byte COL_LKCOUNT = 2;
    static final byte COL_TOTSIZE = 3;
    static final byte COL_GRPCOUN = 4;
    static final byte COL_AVEGAGE = 5;
    static final byte COL_OLDESTA = 6;
    static final byte COL_YOUNGES = 7;
    static final String[] COLUMN_NAMES = new String[]{"Id", "classname", "count", "size", "ageGroupCount", "avgAge", "oldest", "youngest"};
    static final String[] COLUMN_DESCS = new String[]{"ID of the allocation origin", "Class name", "Instance count", "Total size", "Total number of age groups", "Average age", "Oldest age", "Youngest age"};
    static final byte[] COLUMN_STATES = new byte[]{3, 5, 2, 2, 3, 2, 2, 2};
    private static Noun s_baseNoun;
    private static Vector<PotentialLeak> s_allStats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    PotentialLeak(Noun baseNoun, int index) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/PotentialLeak") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, Integer.toString(index), "JVMMON_PotentialLeak");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        PotentialLeak.create(base, 5);
    }

    static void create(Noun base, int quantity) {
        if (s_allStats != null) {
            return;
        }
        s_allStats = new Vector(quantity);
        for (int i = 1; i <= quantity; ++i) {
            s_allStats.addElement(new PotentialLeak(base, i));
        }
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        LeakStatistic[] lks = this.dataPsr_.getMemoryLeakTable();
        if (lks == null) {
            return;
        }
        for (int index = 0; index < s_allStats.size(); ++index) {
            PotentialLeak plk = s_allStats.elementAt(index);
            block11: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
                State state = plk.states_[col];
                switch (col) {
                    case 0: {
                        if (index < lks.length) {
                            state.update(lks[index].getTraceId());
                            continue block11;
                        }
                        state.update(0);
                        continue block11;
                    }
                    case 1: {
                        if (index < lks.length) {
                            state.update(lks[index].getClassname());
                            continue block11;
                        }
                        state.update("-NA-");
                        continue block11;
                    }
                    case 2: {
                        if (index < lks.length) {
                            state.update(lks[index].getCount());
                            continue block11;
                        }
                        state.update(0);
                        continue block11;
                    }
                    case 4: {
                        if (index < lks.length) {
                            state.update(lks[index].getAgeGroupCount());
                            continue block11;
                        }
                        state.update(0);
                        continue block11;
                    }
                    case 3: {
                        if (index < lks.length) {
                            state.update(lks[index].getTotalSize());
                            continue block11;
                        }
                        state.update(0);
                        continue block11;
                    }
                    case 5: {
                        if (index < lks.length) {
                            state.update(lks[index].getAvergeAge());
                            continue block11;
                        }
                        state.update(0);
                        continue block11;
                    }
                    case 6: {
                        if (index < lks.length) {
                            state.update(lks[index].getOldestAge());
                            continue block11;
                        }
                        state.update(0);
                        continue block11;
                    }
                    case 7: {
                        if (index < lks.length) {
                            state.update(lks[index].getYoungestAge());
                            continue block11;
                        }
                        state.update(0);
                    }
                }
            }
        }
    }

    static void exit() {
        if (s_allStats != null) {
            s_allStats.clear();
        }
        s_baseNoun = null;
    }
}

