/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import java.util.Vector;
import oracle.dms.instrument.Noun;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.metrics.ClassHistogram;
import oracle.jvmmon.metrics.CpuHotspotStat;
import oracle.jvmmon.metrics.ExceptionStat;
import oracle.jvmmon.metrics.ExceptionSummary;
import oracle.jvmmon.metrics.FullGCEvents;
import oracle.jvmmon.metrics.FullGCSummary;
import oracle.jvmmon.metrics.HeapSummary;
import oracle.jvmmon.metrics.MonitorObjectUsage;
import oracle.jvmmon.metrics.PotentialLeak;
import oracle.jvmmon.metrics.UncaughtExpStat;

public class MgmtStats {
    static final String NOUN_ROOT = "JVM";
    static final String NOUN_SEP = "/";
    static final String NOUN_TYPE_PREFIX = "JVMMON_";
    static final String NOUN_NODE = "JVMmon";
    static final String NOT_AVAILABLE = "-NA-";
    private static MgmtStats s_stats = null;
    private static Noun s_baseNoun = null;
    private static String[] nounNames_s = null;

    private MgmtStats() {
        Vector<String> names = new Vector<String>(10);
        ClassHistogram.create(s_baseNoun);
        names.addElement("ClassHistogram");
        HeapSummary.create(s_baseNoun);
        names.addElement("HeapSummary");
        PotentialLeak.create(s_baseNoun);
        names.addElement("PotentialLeak");
        CpuHotspotStat.create(s_baseNoun);
        names.addElement("CpuHotspot");
        MonitorObjectUsage.create(s_baseNoun);
        names.addElement("MonitorObjectUsage");
        ExceptionSummary.create(s_baseNoun);
        names.addElement("ExceptionSummary");
        ExceptionStat.create(s_baseNoun);
        names.addElement("Exceptions");
        UncaughtExpStat.create(s_baseNoun);
        names.addElement("Uncaught");
        FullGCSummary.create(s_baseNoun);
        names.addElement("FullGCSummary");
        FullGCEvents.create(s_baseNoun);
        names.addElement("FullGCEvents");
        nounNames_s = new String[names.size()];
        names.toArray(nounNames_s);
    }

    public static void create(Noun noun) {
        try {
            if (!JVMMonitor.isAgentInitialized()) {
                return;
            }
            if (s_stats != null) {
                return;
            }
            s_baseNoun = noun != null ? Noun.create(noun, NOUN_NODE, "") : Noun.create("/JVM/JVMmon");
            s_stats = new MgmtStats();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void exit() {
        s_stats = null;
        s_baseNoun = null;
        ClassHistogram.exit();
        HeapSummary.exit();
        PotentialLeak.exit();
        CpuHotspotStat.exit();
        MonitorObjectUsage.exit();
        ExceptionSummary.exit();
        ExceptionStat.exit();
        UncaughtExpStat.exit();
        FullGCSummary.exit();
    }

    public static String getPathName() {
        String name = NOUN_SEP;
        if (s_baseNoun != null) {
            name = name + s_baseNoun.getName();
            Noun current = s_baseNoun;
            while (current.getParent() != null) {
                Noun parent = current.getParent();
                name = NOUN_SEP + parent.getName() + name;
                current = parent;
            }
        }
        return name;
    }

    public static String[] getNounNames() {
        return nounNames_s;
    }
}

