/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.metrics;

import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.jvmmon.agent.AllExceptionStatistic;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.agent.SampleDataProcessor;

class ExceptionSummary
implements GroupRefresh {
    static final String NOUN_NAME = "ExceptionSummary";
    static final byte COL_THROWNCNT = 0;
    static final byte COL_CAUGHTCNT = 1;
    static final byte COL_UNCAUGHTCNT = 2;
    static final String[] COLUMN_NAMES = new String[]{"TotalThrownCount", "TotalCaughtCount", "TotalUncaughtCount"};
    static final String[] COLUMN_DESCS = new String[]{"Total number of Exceptions thrown", "total number of caught Exceptions", "Total number of uncaught Exceptions"};
    static final byte[] COLUMN_STATES = new byte[]{2, 2, 2};
    private static Noun s_baseNoun;
    private static ExceptionSummary s_stats;
    private State[] states_;
    private SampleDataProcessor dataPsr_ = JVMMonitor.getDataProcessor();

    ExceptionSummary(Noun baseNoun) {
        s_baseNoun = baseNoun == null ? Noun.create("JVM/JVMmon/ExceptionSummary") : Noun.create(baseNoun, NOUN_NAME, "");
        Noun noun = Noun.create(s_baseNoun, NOUN_NAME, "JVMMON_ExceptionSummary");
        this.states_ = new State[COLUMN_NAMES.length];
        for (int i = 0; i < this.states_.length; ++i) {
            this.states_[i] = State.create(noun, COLUMN_NAMES[i], COLUMN_STATES[i], "", COLUMN_DESCS[i]);
            this.states_[i].setRefresh(this);
        }
        this.refresh();
    }

    static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new ExceptionSummary(base);
    }

    public void refresh() {
        if (this.dataPsr_ == null) {
            return;
        }
        AllExceptionStatistic exStat = this.dataPsr_.getExceptionStat();
        if (exStat == null) {
            return;
        }
        block5: for (int col = 0; col < COLUMN_NAMES.length; col = (int)((byte)(col + 1))) {
            State state = this.states_[col];
            switch (col) {
                case 0: {
                    state.update(exStat.getTotalThrownCount());
                    continue block5;
                }
                case 1: {
                    state.update(exStat.getTotalCaughtCount());
                    continue block5;
                }
                case 2: {
                    state.update(exStat.getTotalUnCaughtCount());
                }
            }
        }
    }

    static void exit() {
        s_stats = null;
        s_baseNoun = null;
    }
}

