/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvmmon.dfwdump;

import java.util.EnumSet;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.formatter.TableFormatter;
import oracle.jvmmon.agent.ClassStatComparator;
import oracle.jvmmon.agent.ClassStatistic;
import oracle.jvmmon.agent.JVMMonitor;
import oracle.jvmmon.common.StringID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHistogram
extends ComponentDiagnosticDump {
    private static final int COL_WIDTH = 8;

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException {
        TableFormatter tf;
        block4: {
            DumpWriter dw = new DumpWriter(context);
            tf = new TableFormatter(dw, true);
            try {
                tf.addColumn(StringID.translate("1024", new Object[0]), 20);
                tf.addColumn(StringID.translate("1025", new Object[0]), 8);
                tf.addColumn(StringID.translate("1026", new Object[0]), 8);
                tf.addColumn(StringID.translate("1027", new Object[0]), 8);
                tf.addColumn(StringID.translate("1028", new Object[0]), 8);
                tf.addColumn(StringID.translate("1029", new Object[0]), 8);
                tf.addColumn(StringID.translate("1030", new Object[0]), 8);
                tf.addColumn(StringID.translate("1031", new Object[0]), 8);
                tf.addColumn(StringID.translate("1032", new Object[0]), 8);
                tf.addColumn(StringID.translate("1033", new Object[0]), 8);
                tf.addColumn(StringID.translate("1034", new Object[0]), 8);
                ClassStatistic[] cs = JVMMonitor.getDataProcessor().getClassHistogram(ClassStatComparator.SORT_OPTIONS.LIVECOUNT);
                if (cs != null) {
                    for (int i = 0; i < cs.length; ++i) {
                        tf.addRow(cs[i].getClassname(), cs[i].getLiveInstanceCount(), cs[i].getInstanceCreatedCount(), cs[i].getInstanceFreedCount(), cs[i].getTotalSize(), cs[i].getAverageSize(), cs[i].getOldestInstanceAge(), cs[i].getYoungestInstanceAge(), cs[i].getAverageAge(), cs[i].getAgeGroupCount(), cs[i].getDifferentStackTraceCount());
                    }
                    break block4;
                }
                dw.dump(StringID.translate("901", new Object[0]));
                return dw.getDumpResult();
            }
            catch (Exception ex) {
                throw new DumpExecutionException("56000", (Throwable)ex, "DMS", "oracle.jvmmon.messages.Translation");
            }
        }
        return tf.getDumpWriter().getDumpResult();
    }

    @Override
    public String getName() {
        return StringID.translate("1004", new Object[0]);
    }

    @Override
    public String getOwner() {
        return "jvmmon";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.MEMORY);
    }

    @Override
    public String getDumpDescription() {
        return StringID.translate("1005", new Object[0]);
    }
}

