/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dms.spy.Spy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DMSUtil {
    private static final String PIDNOTSET = "";
    private static String _pid = "";
    private static String _localhost = null;
    private static String _dmsMount = "dms0";
    private static volatile boolean _pidSet = false;

    public static synchronized String getLocalHostname() {
        if (_localhost != null) {
            return _localhost;
        }
        _localhost = "localhost";
        try {
            _localhost = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getCanonicalHostName();
                }
            });
        }
        catch (PrivilegedActionException e) {
            return _localhost;
        }
        return _localhost;
    }

    public static void setProcessID(int pid) {
        if (pid <= 0) {
            return;
        }
        DMSUtil.setProcessID(Integer.toString(pid));
    }

    public static synchronized void setProcessID(String pid) {
        if (_pidSet || pid == null || pid.trim().length() == 0) {
            return;
        }
        _pid = pid;
        _pidSet = true;
    }

    public static synchronized String getProcessID() {
        if (PIDNOTSET.equals(_pid)) {
            int pid;
            while ((pid = (int)(Math.random() * 100000.0)) == 0) {
            }
            _pid = Integer.toString(pid);
        }
        return _pid;
    }

    public static String getProcessName() {
        return DMSUtil.getProcessName(Spy.getName(), DMSUtil.getProcessID(), null);
    }

    public static String getProcessName(String name, String id, String group) {
        if (name == null || name.trim().length() == 0 || id == null || id.trim().length() == 0) {
            return null;
        }
        String idString = ":" + id;
        StringBuilder procName = new StringBuilder(name);
        if (!name.endsWith(idString)) {
            procName.append(idString);
        }
        if (group != null && group.trim().length() > 0) {
            procName.append(':');
            procName.append(group);
        }
        return procName.toString();
    }

    public static String sanitize(String s, int length, boolean spacesToo, boolean dotToo) {
        if (s == null || length <= 0) {
            return PIDNOTSET;
        }
        if (length < s.length()) {
            StringBuilder sb = new StringBuilder(s);
            sb.setLength(length);
            return DMSUtil.sanitize(sb, spacesToo, dotToo, 0);
        }
        length = s.length();
        int newCh = 32;
        block3: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' && !spacesToo) continue;
            if (!Character.isWhitespace(c) && !Character.isISOControl(c)) {
                switch (c) {
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '.': 
                    case '<': 
                    case '>': {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            StringBuilder sb = new StringBuilder(s);
            return DMSUtil.sanitize(sb, spacesToo, dotToo, i);
        }
        return s;
    }

    private static final String sanitize(StringBuilder sb, boolean spacesToo, boolean dotToo, int pos) {
        int length = sb.length();
        block7: for (int i = pos; i < length; ++i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' && !spacesToo) continue;
            if (Character.isWhitespace(c)) {
                if (spacesToo) {
                    sb.setCharAt(i, '_');
                    continue;
                }
                sb.setCharAt(i, ' ');
                continue;
            }
            if (Character.isISOControl(c)) {
                sb.setCharAt(i, '_');
                continue;
            }
            switch (c) {
                case '<': {
                    sb.setCharAt(i, '(');
                    continue block7;
                }
                case '>': {
                    sb.setCharAt(i, ')');
                    continue block7;
                }
                case '&': {
                    sb.setCharAt(i, '^');
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    sb.setCharAt(i, '`');
                    continue block7;
                }
                case '.': {
                    String sfx;
                    if (!dotToo || (sfx = sb.substring(i)).lastIndexOf(46) != 0 || !".value".equals(sfx) && !".count".equals(sfx) && !".time".equals(sfx) && !".minTime".equals(sfx) && !".minValue".equals(sfx) && !".maxTime".equals(sfx) && !".maxValue".equals(sfx) && !".completed".equals(sfx) && !".avg".equals(sfx) && !".sum".equals(sfx) && !".active".equals(sfx) && !".maxActive".equals(sfx) && !".logged".equals(sfx) && !".exclTime".equals(sfx) && !".lastUpdate".equals(sfx) && !".ts".equals(sfx)) continue block7;
                    sb.setCharAt(i, '_');
                    continue block7;
                }
                default: {
                    continue block7;
                }
            }
        }
        return sb.toString();
    }

    public static String getLeafFromPath(String pathname) {
        if (pathname == null || pathname.trim().length() == 0) {
            return null;
        }
        char delim = pathname.charAt(0);
        String my_name = pathname.substring(pathname.lastIndexOf(delim) + 1);
        return my_name;
    }

    public static String removeTrailingDelimFromPath(String pathname) {
        if (pathname == null || pathname.length() <= 1) {
            return pathname;
        }
        int len = pathname.length();
        if (pathname.charAt(0) == pathname.charAt(len - 1)) {
            return pathname.substring(0, len - 1);
        }
        return pathname;
    }

    public static String getParentFromPath(String pathname) {
        if (pathname == null || pathname.trim().length() == 0) {
            return null;
        }
        char delim = pathname.charAt(0);
        return pathname.substring(0, pathname.lastIndexOf(delim));
    }

    public static String genCompNounPath(String nounName) {
        return "/DMS-Internal/" + nounName;
    }

    public static void cleanFormatArgs(Object[] args) {
        if (args != null) {
            for (int i = args.length - 1; i >= 0; --i) {
                if (args[i] != null) continue;
                args[i] = "null";
            }
        }
    }

    public static String getDMSMount() {
        return _dmsMount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMapSets(Map<?, ?> hashmap) {
        ArrayList list;
        if (hashmap == null) {
            return;
        }
        Map<?, ?> map = hashmap;
        synchronized (map) {
            list = new ArrayList(hashmap.values());
            hashmap.clear();
        }
        for (Object obj : list) {
            Object obj2;
            if (obj instanceof Collection) {
                obj2 = obj;
                synchronized (obj2) {
                    ((Collection)obj).clear();
                    continue;
                }
            }
            if (!(obj instanceof Map)) continue;
            obj2 = obj;
            synchronized (obj2) {
                ((Map)obj).clear();
            }
        }
        list.clear();
    }

    public static String xmlEscape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder newText = new StringBuilder();
        int i = 0;
        while ((i = text.indexOf("]]>")) != -1) {
            newText.append(text.substring(0, i));
            newText.append("&#x5d;&#x5d;&#x3e;");
            text = text.substring(i + 3);
        }
        newText.append(text);
        return newText.toString();
    }

    public static <T> HashSet<T> createHashSet(T[] array) {
        HashSet<T> set = new HashSet<T>();
        if (array == null) {
            return set;
        }
        for (T element : array) {
            if (element == null) continue;
            set.add(element);
        }
        return set;
    }

    public static <T> ArrayList<T> createArrayList(T[] array) {
        ArrayList<T> set = new ArrayList<T>();
        if (array == null) {
            return set;
        }
        for (T element : array) {
            if (element == null) continue;
            set.add(element);
        }
        return set;
    }

    public static int[] parseVersion(String version) throws NumberFormatException {
        if (version == null || version.trim().length() == 0) {
            throw new NumberFormatException(version);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer verTok = new StringTokenizer(version, ".");
        while (verTok.hasMoreTokens()) {
            String token = verTok.nextToken();
            list.add(new Integer(token));
        }
        int size = list.size();
        if (size == 0) {
            throw new NumberFormatException(version);
        }
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static int compareVersion(String version, int[] versionNums) throws NumberFormatException {
        if (version == null || versionNums == null || versionNums.length == 0) {
            throw new NumberFormatException();
        }
        int[] numbers = DMSUtil.parseVersion(version);
        return DMSUtil.compareVersion(numbers, versionNums);
    }

    public static int compareVersion(int[] versionNum1, int[] versionNum2) throws NumberFormatException {
        if (versionNum1 == null || versionNum1.length == 0 || versionNum2 == null || versionNum2.length == 0) {
            throw new NumberFormatException();
        }
        int min = versionNum1.length < versionNum2.length ? versionNum1.length : versionNum2.length;
        for (int i = 0; i < min; ++i) {
            if (versionNum1[i] < versionNum2[i]) {
                return -1;
            }
            if (versionNum1[i] <= versionNum2[i]) continue;
            return 1;
        }
        int[] longer = versionNum1.length > versionNum2.length ? versionNum1 : versionNum2;
        boolean is0 = true;
        for (int i = min; i < longer.length; ++i) {
            if (longer[i] == 0) continue;
            is0 = false;
            break;
        }
        if (is0) {
            return 0;
        }
        if (versionNum1.length < versionNum2.length) {
            return -1;
        }
        if (versionNum1.length > versionNum2.length) {
            return 1;
        }
        return 0;
    }

    private DMSUtil() {
    }

    public static synchronized void exit() {
        _pidSet = false;
        _dmsMount = "dms0";
        _localhost = null;
        _pid = PIDNOTSET;
    }
}

