/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Locale;
import java.util.MissingResourceException;
import oracle.as.management.translation.NLSupport;

public abstract class DMSNLSupport {
    public static final String DMS_MESSAGE_FILE = "oracle.dms.util.dms";

    public static String getString(String key) {
        return DMSNLSupport.getString(key, null);
    }

    public static String getString(String key, String defaultString) {
        return DMSNLSupport.getString(key, defaultString, null);
    }

    public static String getString(String key, String defaultString, Locale locale) {
        String translation;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NLSupport nls = NLSupport.getNLSupport(DMS_MESSAGE_FILE, DMSNLSupport.class.getClassLoader());
        try {
            translation = nls.getTranslation(key, locale);
        }
        catch (MissingResourceException e) {
            return defaultString;
        }
        if (translation == null || translation.trim().length() == 0) {
            return defaultString;
        }
        return translation;
    }

    public static String getMessage(String key, Object[] args) {
        return DMSNLSupport.getMessage(key, args, null);
    }

    public static String getMessage(String key, Object[] args, String defaultString) {
        return DMSNLSupport.getMessage(key, args, defaultString, null);
    }

    public static String getMessage(String key, Object[] args, String defaultString, Locale locale) {
        String translation;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NLSupport nls = NLSupport.getNLSupport(DMS_MESSAGE_FILE, DMSNLSupport.class.getClassLoader());
        try {
            translation = nls.getTranslation(key, args, locale);
        }
        catch (MissingResourceException e) {
            return defaultString;
        }
        if (translation == null || translation.trim().length() == 0) {
            return defaultString;
        }
        return translation;
    }

    private DMSNLSupport() {
    }
}

