/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.Comparator;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.Row;
import oracle.dms.table.ValueComparator;
import oracle.dms.table.ValueType;
import oracle.dms.util.NameSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowComparator
extends NameSupport
implements Comparator<Row> {
    private boolean m_isAscending = true;
    private ValueComparator m_valueComparator = new ValueComparator();

    public RowComparator(String name, boolean isAscending) {
        super(name);
        this.m_isAscending = isAscending;
    }

    @Override
    public int compare(Row row1, Row row2) {
        Serializable value1 = row1.getValue(this.m_name);
        Serializable value2 = row2.getValue(this.m_name);
        ValueType typeId = row1.getTypeID(this.m_name);
        if (value1 == null && value2 == null) {
            value1 = row1.getValue("Name");
            value2 = row2.getValue("Name");
            typeId = row1.getTypeID("Name");
        }
        if (value1 == null || value1 instanceof ErrorObject) {
            if (value2 == null || value2 instanceof ErrorObject) {
                return 0;
            }
            return this.m_isAscending ? -1 : 1;
        }
        if (value2 == null || value2 instanceof ErrorObject) {
            return this.m_isAscending ? 1 : -1;
        }
        int ret = this.m_valueComparator.compare(value1, value2, typeId);
        return this.m_isAscending ? ret : -ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RowComparator)) {
            return false;
        }
        RowComparator comp = (RowComparator)obj;
        return this.m_name.equals(comp.m_name) && this.m_isAscending == comp.m_isAscending;
    }
}

