/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.spy.Metric;
import oracle.dms.table.ValueComparator;
import oracle.dms.table.ValueType;
import oracle.dms.util.TableQueryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankingElement
implements Comparable<RankingElement> {
    private Noun m_noun;
    private Serializable m_value;
    private ValueType m_type;
    private ValueComparator m_comparator;
    private TableQueryDescriptor.Order m_order;

    public RankingElement(Noun noun, Serializable value, ValueType type, ValueComparator comparator, TableQueryDescriptor.Order order) {
        if (noun == null || value == null || type == null || order == null) {
            throw new IllegalArgumentException("noun=" + noun + " value=" + value + " type=" + (Object)((Object)type) + " comparator=" + comparator + " order=" + (Object)((Object)order));
        }
        this.m_noun = noun;
        this.m_value = value;
        this.m_type = type;
        this.m_comparator = comparator;
        this.m_order = order;
    }

    public Noun getNoun() {
        return this.m_noun;
    }

    @Override
    public int compareTo(RankingElement element) {
        if (this.m_order == TableQueryDescriptor.Order.ASC) {
            return this.m_comparator.compare(this.m_value, element.m_value, this.m_type);
        }
        return this.m_comparator.compare(element.m_value, this.m_value, this.m_type);
    }

    public static Noun[] rankingSelect(Noun[] nouns, NounDescriptor ndesc, Set<GroupRefresh> gRefresh, TableQueryDescriptor.RankingSelection rankSelect) {
        SensorDescriptor sdesc;
        if (rankSelect == null) {
            return nouns;
        }
        int numRows = rankSelect.getNumRows();
        String columnSorted = rankSelect.getColumn();
        TableQueryDescriptor.Order order = rankSelect.getOrder();
        if (order == null || columnSorted == null || columnSorted.trim().length() == 0 || numRows <= 0) {
            return nouns;
        }
        String sensorName = null;
        MetricDescriptor mdesc = null;
        int index = columnSorted.indexOf(46);
        if (index > 0 && (sdesc = ndesc.getSensorDescriptor(sensorName = columnSorted.substring(0, index))) != null) {
            mdesc = sdesc.getMetricDescriptor(columnSorted);
        }
        ValueComparator comparator = new ValueComparator();
        LinkedList<RankingElement> elements = new LinkedList<RankingElement>();
        if (mdesc == null) {
            block0: for (Noun noun : nouns) {
                if (noun == null) continue;
                Noun root = Noun.getRoot();
                for (Noun parent = noun.getParent(); parent != root; parent = parent.getParent()) {
                    String type = parent.getType();
                    if (type.trim().length() == 0 || "n/a".equals(type) || !type.equals(columnSorted)) continue;
                    RankingElement element = new RankingElement(noun, (Serializable)((Object)parent.getName()), ValueType.STRING, comparator, order);
                    elements.addLast(element);
                    continue block0;
                }
            }
        } else {
            String typeString = mdesc.getValueType();
            ValueType type = ValueType.valueOf(typeString.toUpperCase());
            Metric[] mets = new Metric[nouns.length];
            for (int i = 0; i < nouns.length; ++i) {
                if (nouns[i] == null) continue;
                Sensor sensor = null;
                Metric metric = null;
                if (sensorName != null) {
                    sensor = nouns[i].getSensor(sensorName);
                }
                if (sensor != null) {
                    metric = sensor.getMetric(columnSorted);
                }
                mets[i] = metric;
            }
            Serializable[] values = Metric.getSerializableValues(mets, gRefresh);
            for (int i = 0; i < nouns.length; ++i) {
                if (nouns[i] == null || mets[i] == null) continue;
                RankingElement element = new RankingElement(nouns[i], values[i], type, comparator, order);
                elements.addLast(element);
            }
        }
        if (elements.size() == 0) {
            return nouns;
        }
        Collections.sort(elements);
        while (elements.size() > numRows) {
            elements.removeLast();
        }
        Noun[] ret = new Noun[elements.size()];
        int i = 0;
        for (RankingElement element : elements) {
            ret[i++] = element.getNoun();
        }
        elements.clear();
        return ret;
    }
}

