/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import oracle.dms.table.KeyColumns;
import oracle.dms.table.NullValue;
import oracle.dms.table.RowSupport;
import oracle.dms.util.NetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Key
implements KeyColumns,
Cloneable {
    private Map<String, Serializable> m_keys = new Hashtable<String, Serializable>();
    static final long serialVersionUID = -1150676829041L;

    public Key(Map<String, ? extends Serializable> keyMap) {
        if (keyMap == null) {
            throw new IllegalArgumentException(this.toString() + " keyMap=" + keyMap);
        }
        for (Map.Entry<String, ? extends Serializable> entry : keyMap.entrySet()) {
            String name = entry.getKey();
            Serializable value = entry.getValue();
            this.addKey(name, value);
        }
    }

    public Object getKeyValue(String key) {
        Serializable value = this.m_keys.get(key);
        if (value instanceof NullValue) {
            return null;
        }
        return value;
    }

    @Override
    public int keyCount() {
        return this.m_keys.size();
    }

    @Override
    public String[] getKeys() {
        String[] ret = new String[this.m_keys.size()];
        this.m_keys.keySet().toArray(ret);
        return ret;
    }

    @Override
    public boolean containsKey(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        return this.m_keys.containsKey(name);
    }

    public void addKey(String name, Serializable value) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        if (value == null) {
            value = RowSupport.NULL;
        }
        this.m_keys.put(name, value);
    }

    public void removeKey(String name) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        this.m_keys.remove(name);
    }

    @Override
    public Enumeration<String> enumerateKeys(boolean sorted) {
        return Collections.enumeration(this.m_keys.keySet());
    }

    public int hashCode() {
        if (this.m_keys.size() == 0) {
            return super.hashCode();
        }
        long hash = 0L;
        for (Serializable value : this.m_keys.values()) {
            if (value == null) continue;
            hash += (long)value.hashCode();
        }
        return (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        if (this.m_keys.size() == 0) {
            return false;
        }
        Key key = (Key)obj;
        if (this.m_keys.size() != key.m_keys.size()) {
            return false;
        }
        for (Map.Entry<String, Serializable> entry : this.m_keys.entrySet()) {
            boolean match;
            String name = entry.getKey();
            Serializable value = entry.getValue();
            if (!key.m_keys.containsKey(name)) {
                return false;
            }
            Serializable comparedValue = key.m_keys.get(name);
            if (name.equalsIgnoreCase("Host") || name.equalsIgnoreCase("Host.value")) {
                match = value instanceof String && comparedValue instanceof String ? NetUtil.isSameHost((String)((Object)value), (String)((Object)comparedValue)) : value.equals(comparedValue);
            } else if (value != null) {
                match = value.equals(comparedValue);
            } else {
                boolean bl = match = value == comparedValue;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append('#');
        for (Serializable value : this.m_keys.values()) {
            buf.append(',');
            buf.append(value);
        }
        return buf.toString();
    }

    public Object clone() {
        Key clone = null;
        try {
            clone = (Key)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.m_keys = new Hashtable<String, Serializable>(this.m_keys);
        return clone;
    }
}

