/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dms.table.ColumnGroup;
import oracle.dms.util.NameSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroupSupport
extends NameSupport
implements ColumnGroup {
    private String m_type = null;
    protected String m_description = null;
    protected TreeSet<String> m_members = new TreeSet();
    static final long serialVersionUID = -1150676773410L;

    protected ColumnGroupSupport(String name, String type, String description) {
        super(name);
        if (type == null || type.trim().length() == 0) {
            throw new IllegalArgumentException(this.getClass().getName() + " column group name=" + name + " column group type=" + type);
        }
        this.m_type = type;
        this.m_description = description;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public int memberCount() {
        return this.m_members.size();
    }

    @Override
    public Enumeration<String> enumerateMemberNames(boolean sorted) {
        return Collections.enumeration(this.m_members);
    }

    protected synchronized Object clone() {
        ColumnGroupSupport clone = null;
        try {
            clone = (ColumnGroupSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.m_members = new TreeSet<String>((SortedSet<String>)this.m_members);
        return clone;
    }

    protected void addMember(String name) {
        if (name != null && name.trim().length() > 0) {
            this.m_members.add(name);
        }
    }

    @Override
    public boolean containsMember(String member) {
        if (member == null || member.trim().length() == 0) {
            return false;
        }
        return this.m_members.contains(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMemberNames() {
        String[] ret = null;
        TreeSet<String> treeSet = this.m_members;
        synchronized (treeSet) {
            ret = new String[this.m_members.size()];
            this.m_members.toArray(ret);
        }
        return ret;
    }

    protected synchronized void close() {
        this.m_members.clear();
    }

    protected void printTbml(long schemaRefreshTime, PrintWriter out) {
        if (!this.isPrintColumnGroup(schemaRefreshTime)) {
            return;
        }
        out.print('<');
        out.print("columngroupdef");
        out.print(' ');
        out.print("name");
        out.print("='");
        out.print(this.m_name);
        if (this.m_type != null && this.m_type.length() != 0) {
            out.print("' ");
            out.print("type");
            out.print("='");
            out.print(this.m_type);
        }
        out.print("' ");
        out.print("columns");
        out.print("='");
        Iterator<String> iter = this.m_members.iterator();
        while (iter.hasNext()) {
            String columnName = iter.next();
            out.print(columnName);
            if (!iter.hasNext()) continue;
            out.print(' ');
        }
        if (this.m_description != null && this.m_description.trim().length() > 0) {
            out.print("'>\n<");
            out.print("description");
            out.print("><![CDATA[");
            out.print(this.m_description);
            out.print("]]></");
            out.print("description");
            out.print(">\n</");
            out.print("columngroupdef");
            out.print(">\n");
        } else {
            out.print("'/>\n");
        }
    }

    protected boolean isPrintColumnGroup(long schemaRefreshTime) {
        return true;
    }
}

