/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class ThreadStats
implements GroupRefresh {
    private static ThreadStats s_stats = null;
    private ThreadMXBean m_bean = null;
    private State m_liveThreads = null;
    private State m_startedThreads = null;
    private State m_peakThreads = null;
    private State m_daemonThreads = null;
    private State m_deadlockThreads = null;

    private ThreadStats() {
    }

    private ThreadStats(Noun baseNoun) {
        this.m_bean = ManagementFactory.getThreadMXBean();
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        Noun noun = Noun.create(baseNoun, "threads", "JVM_ThreadStats");
        this.m_liveThreads = State.create(noun, "live", (byte)3, "threads", "number of live threads");
        this.m_liveThreads.setRefresh(this);
        this.m_startedThreads = State.create(noun, "started", (byte)3, "threads", "number of threads that have been started");
        this.m_startedThreads.setRefresh(this);
        this.m_peakThreads = State.create(noun, "peak", (byte)3, "threads", "peak number of live threads");
        this.m_peakThreads.setRefresh(this);
        this.m_daemonThreads = State.create(noun, "daemon", (byte)3, "threads", "number of daemon threads");
        this.m_daemonThreads.setRefresh(this);
        this.m_deadlockThreads = State.create(noun, "deadlock", (byte)3, "threads", "number of dead locked threads");
        this.m_deadlockThreads.setRefresh(this);
        this.refresh();
    }

    public static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new ThreadStats(base);
    }

    public void refresh() {
        this.m_liveThreads.update(this.m_bean.getThreadCount());
        this.m_startedThreads.update(this.m_bean.getTotalStartedThreadCount());
        this.m_peakThreads.update(this.m_bean.getPeakThreadCount());
        this.m_daemonThreads.update(this.m_bean.getDaemonThreadCount());
        this.m_deadlockThreads.update(this.getDeadLockCount());
    }

    private int getDeadLockCount() {
        Integer count = null;
        count = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                long[] dead = ThreadStats.this.m_bean.findMonitorDeadlockedThreads();
                int count = dead == null ? 0 : dead.length;
                return new Integer(count);
            }
        });
        return count;
    }

    static void exit() {
        s_stats = null;
    }
}

