/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class ThreadMonitor
implements GroupRefresh {
    private static ConcurrentHashMap<Long, ThreadMonitor> s_statMap = new ConcurrentHashMap();
    private static ThreadMXBean s_bean = ManagementFactory.getThreadMXBean();
    private static boolean s_cpuSupported = s_bean.isThreadCpuTimeSupported();
    private static boolean s_contention = s_bean.isThreadContentionMonitoringSupported() && s_bean.isThreadContentionMonitoringEnabled();
    private static Noun s_baseNoun = null;
    private static long s_maxStale = 2000L;
    private static boolean s_init = false;
    private long m_id = 0L;
    private Noun m_noun = null;
    private State m_cpuTime = null;
    private State m_threadState = null;
    private State m_name = null;
    private State m_blockedTime = null;
    private State m_blockedCount = null;
    private ThreadInfo m_info = null;

    private ThreadMonitor() {
    }

    private static void init() {
        Boolean init = new Boolean(false);
        init = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                s_bean.setThreadContentionMonitoringEnabled(true);
                return new Boolean(true);
            }
        });
        s_init = init;
    }

    private ThreadMonitor(Noun noun, long id) {
        Noun baseNoun = null;
        baseNoun = noun == null ? Noun.create("/JVM/MxBeans/threads") : Noun.create(noun, "threads", "");
        this.m_noun = Noun.create(baseNoun, "Thread-" + Long.toString(id), "JVM_Thread");
        this.m_id = id;
        this.m_info = ThreadMonitor.getThreadInfo(id);
        this.m_name = State.create(this.m_noun, "name", (byte)5, "", "name of thread");
        this.m_name.update(this.m_info.getThreadName());
        this.m_threadState = State.create(this.m_noun, "state", (byte)5, "", "The current state of this thread");
        this.m_threadState.setRefresh(this);
        if (s_cpuSupported) {
            this.m_cpuTime = State.create(this.m_noun, "cpu", (byte)2, "msecs", "CPU time used by this thread");
            this.m_cpuTime.setRefresh(this);
        }
        if (s_contention) {
            this.m_blockedCount = State.create(this.m_noun, "blocking", (byte)2, "times", "number of times this thread has been blocked");
            this.m_blockedCount.setRefresh(this);
            this.m_blockedTime = State.create(this.m_noun, "blocked", (byte)2, "msec", "total milliseconds this thread has been blocked");
            this.m_blockedTime.setRefresh(this);
        }
        this.refresh();
    }

    public static void create(Noun base) {
        if (!s_init) {
            ThreadMonitor.init();
        }
        if (s_statMap.size() > 0) {
            return;
        }
        ThreadMonitor tm = null;
        long[] ids = ThreadMonitor.getThreadIds();
        for (int i = 0; i < ids.length; ++i) {
            tm = new ThreadMonitor(base, ids[i]);
            s_statMap.put(ids[i], tm);
        }
        Thread t = ThreadMonitor.makeCleanerThread();
        t.setDaemon(true);
        t.start();
    }

    private static long[] getThreadIds() {
        long[] ids = new long[]{};
        ids = AccessController.doPrivileged(new PrivilegedAction<long[]>(){

            @Override
            public long[] run() {
                return s_bean.getAllThreadIds();
            }
        });
        return ids;
    }

    private static ThreadInfo getThreadInfo(final long id) {
        ThreadInfo info = null;
        info = AccessController.doPrivileged(new PrivilegedAction<ThreadInfo>(){

            @Override
            public ThreadInfo run() {
                return s_bean.getThreadInfo(id);
            }
        });
        return info;
    }

    public void refresh() {
        long nsecs;
        ThreadInfo info = ThreadMonitor.getThreadInfo(this.m_id);
        if (info == null) {
            this.m_threadState.update("TERMINATED");
            return;
        }
        this.m_threadState.update((Object)info.getThreadState());
        if (s_cpuSupported && (nsecs = s_bean.getThreadCpuTime(this.m_id)) >= 0L) {
            long msecs = (nsecs + 500000L) / 1000000L;
            this.m_cpuTime.update(msecs);
        }
        if (s_contention) {
            this.m_blockedCount.update(info.getBlockedCount());
            this.m_blockedTime.update(info.getBlockedTime());
        }
    }

    private static void checkForNew() {
        long[] ids = ThreadMonitor.getThreadIds();
        ThreadMonitor tm = null;
        for (int i = 0; i < ids.length; ++i) {
            tm = s_statMap.get(ids[i]);
            if (tm != null) continue;
            tm = new ThreadMonitor(null, ids[i]);
            s_statMap.put(ids[i], tm);
        }
    }

    private static Thread makeCleanerThread() {
        Runnable cleanloop = new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(s_maxStale);
                        ThreadMonitor.cleanup();
                        ThreadMonitor.checkForNew();
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        return new Thread(cleanloop);
    }

    private static boolean isMember(long[] ids, long test) {
        for (int i = 0; i < ids.length; ++i) {
            if (test != ids[i]) continue;
            return true;
        }
        return false;
    }

    private static void cleanup() {
        ThreadMonitor tm = null;
        Object dump = null;
        long[] ids = ThreadMonitor.getThreadIds();
        Set keys = s_statMap.keySet();
        for (int i = 0; i < ids.length; ++i) {
            keys.remove(ids[i]);
        }
        int count = keys.size();
        for (Long key : keys) {
            tm = s_statMap.get(key);
            ThreadMonitor.clean(tm);
        }
    }

    private static void clean(ThreadMonitor tm) {
        if (tm == null) {
            return;
        }
        long id = tm.m_id;
        s_statMap.remove(id);
        tm.m_cpuTime.removeRefresh();
        tm.m_threadState.removeRefresh();
        if (s_contention) {
            tm.m_blockedCount.removeRefresh();
            tm.m_blockedTime.removeRefresh();
        }
        tm.m_noun.destroy();
    }

    static void exit() {
        s_statMap.clear();
        s_baseNoun = null;
        s_maxStale = 2000L;
    }
}

