/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class MemoryTypeStats
implements GroupRefresh {
    private static HashMap<MemoryType, MemoryTypeStats> s_stats = new HashMap();
    private MemoryTypeStats m_stats = null;
    private MemoryMXBean m_memory = null;
    private MemoryUsage m_usage = null;
    private State m_used = null;
    private State m_committed = null;
    private State m_max = null;
    private State m_init = null;

    private MemoryTypeStats() {
    }

    private MemoryTypeStats(Noun baseNoun, MemoryType type) {
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        String tname = type.toString();
        Noun noun = Noun.create(baseNoun, tname, "JVM_MemorySet");
        this.m_memory = ManagementFactory.getMemoryMXBean();
        switch (type) {
            case HEAP: {
                this.m_usage = this.m_memory.getHeapMemoryUsage();
            }
            case NON_HEAP: {
                this.m_usage = this.m_memory.getNonHeapMemoryUsage();
            }
        }
        this.m_used = State.create(noun, "used", (byte)2, "KB", "memory in use");
        this.m_used.setRefresh(this);
        this.m_max = State.create(noun, "max", (byte)2, "KB", "available");
        this.m_max.setRefresh(this);
        this.m_committed = State.create(noun, "committed", (byte)2, "KB", "to the JVM");
        this.m_committed.setRefresh(this);
        this.m_init = State.create(noun, "init", (byte)2, "KB", "requested by JVM");
        long kb = (this.m_usage.getInit() + 500L) / 1000L;
        this.m_init.update(kb);
        this.refresh();
    }

    public static MemoryTypeStats create(Noun base, MemoryType type) {
        if (base == null || type == null) {
            return null;
        }
        MemoryTypeStats stats = s_stats.get((Object)type);
        if (stats != null) {
            return stats;
        }
        stats = new MemoryTypeStats(base, type);
        s_stats.put(type, stats);
        return stats;
    }

    public void refresh() {
        long kb = (this.m_usage.getUsed() + 500L) / 1000L;
        this.m_used.update(kb);
        kb = (this.m_usage.getMax() + 500L) / 1000L;
        this.m_max.update(kb);
        kb = (this.m_usage.getCommitted() + 500L) / 1000L;
        this.m_committed.update(kb);
    }

    static void exit() {
        s_stats.clear();
    }
}

