/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.IllegalOperation;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.PrependStringBuffer;

public abstract class TreeNode {
    public static final int NAME_LEN = 511;
    public static final int DESC_LEN = 1023;
    protected String _name;
    private static final String ILLEGAL_OPER = "ILLEGAL_OPER";
    private String _description;
    protected Noun _parent;
    protected boolean _alive;

    public TreeNode(Noun parent, String name, String description) {
        if (name == null || description == null) {
            throw new IllegalOperation(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), parent, name, description}, "Malformed TreeNode: " + parent + ":" + name + ":" + description));
        }
        this._name = DMSUtil.sanitize(name, 511, false, false);
        this._description = DMSUtil.sanitize(description, 1023, false, false);
        this._parent = parent;
        this._alive = true;
        State st = StatisticsProducer._nodes_state;
        if (st != null) {
            st.increment(1);
        }
    }

    public TreeNode(Noun parent, String name, String description, boolean sanitize) {
        if (name == null || description == null) {
            throw new IllegalOperation(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), parent, name, description}, "Malformed TreeNode: " + parent + ":" + name + ":" + description));
        }
        if (sanitize) {
            this._name = DMSUtil.sanitize(name, 511, true, true);
            this._description = DMSUtil.sanitize(description, 1023, false, false);
        } else {
            this._name = name;
            this._description = description;
        }
        this._parent = parent;
        this._alive = true;
        State st = StatisticsProducer._nodes_state;
        if (st != null) {
            st.increment(1);
        }
    }

    public Noun getParent() {
        return this._parent;
    }

    public String getName() {
        return this._name;
    }

    public synchronized String toString() {
        Noun rootNoun = Noun.getRoot();
        if (this == rootNoun) {
            return "/";
        }
        PrependStringBuffer buf = new PrependStringBuffer(50, this._name);
        Noun n = this._parent;
        while (n != rootNoun) {
            buf.prepend('/');
            buf.prepend(n._name);
            n = n._parent;
        }
        buf.prepend('/');
        return buf.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isAlive() {
        return this._alive;
    }

    public void destroy() {
        this._alive = false;
        State st = StatisticsProducer._nodes_state;
        if (st != null) {
            st.increment(-1);
        }
    }

    void setName(String name) {
        this._name = name;
    }
}

