/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.Serializable;
import oracle.dms.reporter.NounTreeletNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeletNode<T>
implements Comparable<TreeletNode> {
    protected T m_mappedNode = null;
    protected String m_name = null;
    protected NounTreeletNode m_parent = null;

    protected TreeletNode(T root) {
        if (root == null) {
            throw new IllegalArgumentException(this.toString() + ": root=" + root);
        }
        this.m_mappedNode = root;
    }

    protected TreeletNode(String name, NounTreeletNode parent, T mappedNode) {
        if (name == null || name.trim().length() == 0 || parent == null || mappedNode == null) {
            throw new IllegalArgumentException(this.toString() + ": name=" + name + ": parent=" + parent + ": mappedNode=" + mappedNode);
        }
        this.m_name = name;
        this.m_parent = parent;
        this.m_mappedNode = mappedNode;
    }

    protected void clear() {
        this.m_mappedNode = null;
        this.m_name = null;
        this.m_parent = null;
    }

    public String toString() {
        if (this.m_mappedNode == null) {
            return this.m_name;
        }
        return this.m_mappedNode.toString();
    }

    protected final T getNode() {
        return this.m_mappedNode;
    }

    protected final TreeletNode getParent() {
        return this.m_parent;
    }

    @Override
    public final int compareTo(TreeletNode obj) {
        return this.m_name.compareTo(obj.m_name);
    }

    protected final String getName() {
        return this.m_name;
    }

    public static String getValueType(Serializable value) {
        if (value == null) {
            return "string";
        }
        if (value instanceof Long) {
            return "long";
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return "integer";
        }
        if (value instanceof Double || value instanceof Float) {
            return "double";
        }
        return "string";
    }
}

