/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import oracle.dms.http.Request;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Sensor;
import oracle.dms.reporter.TableBaseReporter;
import oracle.dms.spy.Metric;
import oracle.dms.table.RankingElement;
import oracle.dms.util.TableQueryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TabletReporter
extends TableBaseReporter {
    TabletReporter(Request request) {
        super(request);
    }

    @Override
    public final void printResponse(PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException("out=" + out);
        }
        HashSet<String> badTables = new HashSet<String>();
        String[] tables = this.m_request.getTables();
        if (tables == null || tables.length == 0) {
            tables = Noun.getAllTypes();
        }
        this.printHeading(out);
        HashSet<String> printedNames = new HashSet<String>();
        for (String table : tables) {
            boolean includeRows;
            boolean includeSchema;
            if (printedNames.contains(table)) continue;
            Noun[] nouns = Noun.getNounsByType(table);
            if (nouns == null || nouns.length == 0) {
                badTables.add(table);
                continue;
            }
            NounDescriptor ndesc = Noun.getDescriptorByType(table);
            if (ndesc == null) {
                badTables.add(table);
                continue;
            }
            printedNames.add(table);
            TableQueryDescriptor qdesc = this.m_options.getTableQueryDescriptor(table);
            if (qdesc != null) {
                includeSchema = qdesc.includeSchema();
                includeRows = qdesc.includeRows();
            } else {
                includeSchema = this.m_options.includeSchema();
                includeRows = this.m_options.includeRows();
            }
            this.printTableHeading(table, out);
            long schemaRefreshTime = qdesc == null || includeRows ? 0L : qdesc.schemaRefreshTime();
            this.printSchema(table, ndesc, schemaRefreshTime, includeSchema, out);
            if (includeRows) {
                HashSet<GroupRefresh> gRefresh = new HashSet<GroupRefresh>();
                TableQueryDescriptor.RankingSelection rankSelect = null;
                if (qdesc != null) {
                    rankSelect = qdesc.getRankingSelection();
                }
                if (rankSelect != null) {
                    nouns = RankingElement.rankingSelect(nouns, ndesc, gRefresh, rankSelect);
                }
                long valueRefreshTime = qdesc == null ? 0L : qdesc.valueRefreshTime();
                Set<String> columns = qdesc == null ? null : qdesc.getColumns();
                Sensor[][] sensors = new Sensor[nouns.length][];
                Metric[][][] metrics = new Metric[nouns.length][][];
                Serializable[][][] values = null;
                values = this._refreshMetrics(nouns, sensors, metrics, columns, valueRefreshTime, gRefresh);
                this.printValues(table, nouns, sensors, metrics, values, valueRefreshTime, out);
            }
            this.printTableEnding(table, out);
        }
        this.printBadParams(null, badTables, out);
        this.printEnding(out);
        badTables.clear();
        printedNames.clear();
    }

    private Serializable[][][] _refreshMetrics(Noun[] nouns, Sensor[][] sensors, Metric[][][] metrics, Set<String> columns, long valueRefreshTime, HashSet<GroupRefresh> gRefresh) {
        int size = 0;
        for (int j = nouns.length - 1; j >= 0; --j) {
            sensors[j] = nouns[j].getSensors();
            if (sensors[j] == null) continue;
            metrics[j] = new Metric[sensors[j].length][];
            for (int i = sensors[j].length - 1; i >= 0; --i) {
                int len;
                long lastSensorUpdate;
                if (sensors[j][i] == null || valueRefreshTime > (lastSensorUpdate = sensors[j][i].getUpdateTime()) && lastSensorUpdate != 0L) continue;
                Vector metricVec = new Vector();
                sensors[j][i].getMetrics(metricVec);
                if (metricVec.size() == 0) continue;
                if (columns != null && columns.size() > 0) {
                    Iterator iter = metricVec.iterator();
                    while (iter.hasNext()) {
                        Metric metric = (Metric)iter.next();
                        String metricName = metric.getName();
                        if (columns.contains(metricName)) continue;
                        iter.remove();
                    }
                }
                if ((len = metricVec.size()) == 0) continue;
                size += len;
                metrics[j][i] = new Metric[len];
                metricVec.toArray(metrics[j][i]);
            }
        }
        if (size == 0) {
            return null;
        }
        int p = 0;
        Metric[] metricArray = new Metric[size];
        for (int j = nouns.length - 1; j >= 0; --j) {
            if (sensors[j] == null) continue;
            for (int i = sensors[j].length - 1; i >= 0; --i) {
                if (metrics[j][i] == null) continue;
                int len = metrics[j][i].length;
                System.arraycopy(metrics[j][i], 0, metricArray, p, len);
                p += len;
            }
        }
        Serializable[] values = Metric.getSerializableValues(metricArray, gRefresh);
        p = 0;
        Serializable[][][] ret = new Serializable[nouns.length][][];
        for (int j = nouns.length - 1; j >= 0; --j) {
            if (sensors[j] == null) continue;
            ret[j] = new Serializable[sensors[j].length][];
            for (int i = sensors[j].length - 1; i >= 0; --i) {
                if (metrics[j][i] == null) continue;
                int len = metrics[j][i].length;
                ret[j][i] = new Serializable[len];
                System.arraycopy(values, p, ret[j][i], 0, len);
                p += len;
            }
        }
        return ret;
    }

    abstract void printHeading(PrintWriter var1);

    abstract void printEnding(PrintWriter var1);

    abstract void printTableHeading(String var1, PrintWriter var2);

    abstract void printTableEnding(String var1, PrintWriter var2);

    abstract void printSchema(String var1, NounDescriptor var2, long var3, boolean var5, PrintWriter var6);

    abstract void printValues(String var1, Noun[] var2, Sensor[][] var3, Metric[][][] var4, Serializable[][][] var5, long var6, PrintWriter var8);
}

