/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import oracle.dms.instrument.Noun;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.TreeletNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NounTreeletNode
extends TreeletNode<Noun> {
    HashMap<String, NounTreeletNode> m_nouns = new HashMap();
    HashMap<String, MetricTreeletNode> m_metrics = new HashMap();

    NounTreeletNode(Noun root) {
        super(root);
    }

    NounTreeletNode(String name, NounTreeletNode parent, Noun mappedNode) {
        super(name, parent, mappedNode);
        this.m_parent.addNoun(this.m_name, this);
    }

    String getTable() {
        Noun noun = (Noun)this.m_mappedNode;
        return noun.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear() {
        super.clear();
        HashMap<String, TreeletNode> hashMap = this.m_nouns;
        synchronized (hashMap) {
            for (NounTreeletNode nounTreeletNode : this.m_nouns.values()) {
                nounTreeletNode.clear();
            }
            this.m_nouns.clear();
        }
        hashMap = this.m_metrics;
        synchronized (hashMap) {
            for (MetricTreeletNode metricTreeletNode : this.m_metrics.values()) {
                metricTreeletNode.clear();
            }
            this.m_metrics.clear();
        }
    }

    final MetricTreeletNode findMetric(String name) {
        if (name == null) {
            return null;
        }
        return this.m_metrics.get(name);
    }

    final NounTreeletNode findNoun(String name) {
        if (name == null) {
            return null;
        }
        return this.m_nouns.get(name);
    }

    final Collection<NounTreeletNode> getNouns(boolean isOrdered) {
        if (!isOrdered) {
            return this.m_nouns.values();
        }
        ArrayList<NounTreeletNode> list = new ArrayList<NounTreeletNode>(this.m_nouns.values());
        Collections.sort(list);
        return list;
    }

    final Collection<MetricTreeletNode> getMetrics(boolean isOrdered) {
        if (!isOrdered) {
            return this.m_metrics.values();
        }
        ArrayList<MetricTreeletNode> list = new ArrayList<MetricTreeletNode>(this.m_metrics.values());
        Collections.sort(list);
        return list;
    }

    final void addNoun(String name, NounTreeletNode child) {
        if (name == null || child == null) {
            return;
        }
        this.m_nouns.put(name, child);
    }

    final void addMetric(String name, MetricTreeletNode child) {
        if (name == null || child == null) {
            return;
        }
        this.m_metrics.put(name, child);
    }
}

