/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class IntegerValue
extends Value {
    private int _value = 0;
    private int _min = Integer.MAX_VALUE;
    private int _max = Integer.MIN_VALUE;

    private void setValue(int newval) {
        this._value = newval;
        if (this.MAX && this._value > this._max) {
            this._max = newval;
        }
        if (this.MIN && this._value < this._min) {
            this._min = newval;
        }
    }

    public void update(int newval) {
        this.setValue(newval);
    }

    public void update(double newval) {
        int ival = 0;
        ival = newval >= 0.0 ? (int)Math.round(newval) : -((int)Math.round(-newval));
        this.setValue(ival);
    }

    public void update(long newval) {
        int ival = (int)newval;
        this.setValue(ival);
    }

    public void increment() {
        int ival = this._value + 1;
        this.setValue(ival);
    }

    public void increment(int inc) {
        int ival = this._value + inc;
        this.setValue(ival);
    }

    public void increment(long inc) {
        int ival = (int)inc;
        this.setValue(ival += this._value);
    }

    public void increment(double inc) {
        int ival = (int)Math.round(inc);
        this.setValue(ival += this._value);
    }

    void initMinMax() {
        if (this._initialized) {
            if (this.MIN && this._min > this._value) {
                this._min = this._value;
            }
            if (this.MAX && this._max < this._value) {
                this._max = this._value;
            }
        }
    }

    public void reset() {
        super.reset();
        if (this.MIN) {
            this._min = this._value;
        }
        if (this.MAX) {
            this._max = this._value;
        }
    }

    public Object getValue() {
        return new Integer(this._value);
    }

    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Integer.MAX_VALUE) {
            return new Integer(this._min);
        }
        return new Integer(0);
    }

    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Integer.MIN_VALUE) {
            return new Integer(this._max);
        }
        return new Integer(0);
    }
}

