/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;

public class TracerRecord {
    Sensor sensor = null;
    Noun noun = null;
    Sensor cousin = null;
    long tstamp = System.currentTimeMillis();
    String action = null;
    int actionID = -1;
    Object detail = null;
    Map m_attMap = null;
    Map m_stateValues;
    Map m_updatedStates;

    public TracerRecord(Sensor s, String a) {
        this.sensor = s;
        this.noun = s.getParent();
        this.action = a;
    }

    public TracerRecord(Sensor s, int id) {
        this.sensor = s;
        this.noun = s.getParent();
        this.actionID = id;
    }

    public TracerRecord(Sensor s, String a, String d) {
        this.sensor = s;
        this.noun = s.getParent();
        this.action = a;
        this.detail = d;
    }

    public TracerRecord(Sensor s, int id, String d) {
        this.sensor = s;
        this.noun = s.getParent();
        this.actionID = id;
        this.detail = d;
    }

    public TracerRecord(Noun n, int id) {
        this.noun = n;
        this.actionID = id;
    }

    public TracerRecord(int id) {
        this.actionID = id;
    }

    public void setTime(long tim) {
        this.tstamp = tim;
    }

    public long getTime() {
        return this.tstamp;
    }

    public Map getAttributeMap() {
        if (this.m_attMap == null) {
            this.m_attMap = new HashMap();
        }
        return this.m_attMap;
    }

    public void setAttributeMap(Map map) {
        this.m_attMap = map;
    }

    Map getStateValues() {
        if (this.m_stateValues == null) {
            this.m_stateValues = new HashMap();
        }
        return this.m_stateValues;
    }

    Map getUpdatedStates() {
        if (this.m_updatedStates == null) {
            this.m_updatedStates = new HashMap();
        }
        return this.m_updatedStates;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toStringBuffer(buf);
        return buf.toString();
    }

    void toStringBuffer(StringBuffer buf) {
        if (this.actionID == 5) {
            buf.append("<REQUEST>");
            if (this.m_attMap != null) {
                Set ks = this.m_attMap.keySet();
                for (Object key : ks) {
                    buf.append("\n    <PROPERTY name=\"");
                    buf.append(key);
                    buf.append("\"> <![CDATA[");
                    buf.append(this.m_attMap.get(key));
                    buf.append("]]> </PROPERTY>");
                }
            }
            buf.append('\n');
        }
        buf.append("  <EVENT time=\"");
        buf.append(this.tstamp);
        if (this.actionID != 5 && this.actionID != 10) {
            if (this.sensor != null) {
                buf.append("\" type=\"");
                buf.append(this.noun.getType());
                buf.append("\" noun=\"");
                buf.append(this.noun.toString());
                buf.append("\" sensor=\"");
                buf.append(this.sensor.getName());
            } else if (this.noun != null) {
                buf.append("\" type=\"");
                buf.append(this.noun.getType());
                buf.append("\" noun=\"");
                buf.append(this.noun.toString());
            }
        }
        buf.append("\" action=\"");
        if (this.actionID >= 0) {
            buf.append(Tracer.ActionList[this.actionID]);
        } else {
            buf.append(this.action);
        }
        if (this.detail != null) {
            buf.append("\">\n    <![CDATA[");
            buf.append(this.detail);
            buf.append("]]></EVENT>\n");
        } else {
            buf.append("\"/>");
        }
        if (this.actionID == 6) {
            buf.append("\n</REQUEST>");
        }
    }

    public TracerRecord findMatchingStart(Stack stack) {
        int startidx;
        if (stack.empty()) {
            return null;
        }
        TracerRecord topREC = (TracerRecord)stack.peek();
        if (this.sensor == topREC.sensor && topREC.actionID == 1) {
            return (TracerRecord)stack.pop();
        }
        Stack vect = stack;
        for (int idx = startidx = vect.size() - 2; idx >= 0; --idx) {
            TracerRecord rec2 = (TracerRecord)vect.elementAt(idx);
            if (rec2.sensor != this.sensor || rec2.actionID != 1) continue;
            vect.removeElementAt(idx);
            return rec2;
        }
        return null;
    }
}

