/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.HashSet;
import java.util.Hashtable;
import oracle.dms.instrument.Descriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.SensorDescriptor;

public class NounDescriptor
extends Descriptor {
    private Hashtable<String, SensorDescriptor> m_children = new Hashtable(31);
    private HashSet<String> m_ancestorTypes = new HashSet(31);
    private HashSet<Noun> m_nouns = new HashSet(31);
    private boolean m_isTraceable = false;
    private volatile long m_lastUpdateTime = System.currentTimeMillis();

    public NounDescriptor(String name) {
        super(name);
        this.setTraceable();
    }

    public SensorDescriptor getSensorDescriptor(String name) {
        return this.m_children.get(name);
    }

    public void addSensorDescriptor(SensorDescriptor sdesc) {
        if (sdesc == null) {
            return;
        }
        if (this.m_children.put(sdesc.getName(), sdesc) == null) {
            this.m_lastUpdateTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSensorNames() {
        String[] ret = null;
        Hashtable<String, SensorDescriptor> hashtable = this.m_children;
        synchronized (hashtable) {
            ret = new String[this.m_children.size()];
            this.m_children.keySet().toArray(ret);
        }
        return ret;
    }

    public int getSensorCount() {
        return this.m_children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAncestorTypes() {
        String[] ret = null;
        HashSet<String> hashSet = this.m_ancestorTypes;
        synchronized (hashSet) {
            ret = new String[this.m_ancestorTypes.size()];
            this.m_ancestorTypes.toArray(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAncestorCount() {
        HashSet<String> hashSet = this.m_ancestorTypes;
        synchronized (hashSet) {
            return this.m_ancestorTypes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAncestorTypes(Noun parent) {
        if (parent == null) {
            return;
        }
        NounDescriptor pdesc = null;
        boolean added = false;
        Noun root = Noun.getRoot();
        while (parent != root) {
            pdesc = parent.getDescriptor();
            if (pdesc != null) {
                HashSet<String> hashSet = this.m_ancestorTypes;
                synchronized (hashSet) {
                    added |= this.m_ancestorTypes.addAll(pdesc.m_ancestorTypes);
                }
                if (added |= this.m_ancestorTypes.add(parent.getType())) {
                    this.m_lastUpdateTime = System.currentTimeMillis();
                }
                return;
            }
            parent = parent.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNoun(Noun noun) {
        if (noun == null) {
            return;
        }
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            this.m_nouns.add(noun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNoun(Noun noun) {
        if (noun == null) {
            return false;
        }
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            return this.m_nouns.remove(noun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNounCount() {
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            return this.m_nouns.size();
        }
    }

    public boolean isTraceable() {
        return this.m_isTraceable;
    }

    public void setTraceable(boolean b) {
        this.m_isTraceable = b;
    }

    private void setTraceable() {
        String name = this.getName();
        if (name.startsWith("oc4j_url") || name.startsWith("oc4j_servlet") || name.startsWith("oc4j_ejb") || name.startsWith("oc4j_jsp(") || name.startsWith("JDBC_")) {
            this.setTraceable(true);
        } else {
            this.setTraceable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Noun[] getNouns() {
        Noun[] ret;
        HashSet<Noun> hashSet = this.m_nouns;
        synchronized (hashSet) {
            ret = new Noun[this.m_nouns.size()];
            this.m_nouns.toArray(ret);
        }
        return ret;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.m_lastUpdateTime = lastUpdateTime;
    }

    public long getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    NounDescriptor duplicateWithoutNouns() {
        NounDescriptor clone = null;
        try {
            clone = (NounDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.m_children = new Hashtable<String, SensorDescriptor>(this.m_children);
        clone.m_ancestorTypes = new HashSet<String>(this.m_ancestorTypes);
        clone.m_nouns = new HashSet();
        return clone;
    }
}

